// license:BSD-3-Clause
// copyright-holders:Ville Linde, Barry Rodewald, Carl, Phil Bennett
#define OP_I386         0x1
#define OP_FPU          0x2
#define OP_I486         0x4
#define OP_PENTIUM      0x8
#define OP_MMX          0x10
#define OP_PPRO         0x20
#define OP_SSE          0x40
#define OP_SSE2         0x80
#define OP_SSE3         0x100
#define OP_CYRIX        0x8000
#define OP_2BYTE        0x80000000
#define OP_3BYTE66      0x40000000
#define OP_3BYTEF2      0x20000000
#define OP_3BYTEF3      0x10000000

const i386_device::X86_OPCODE i386_device::s_x86_opcode_table[] =
{
//  Opcode      Flags                       16-bit handler                  32-bit handler
	{ 0x00,     OP_I386,                    &i386_device::i386_add_rm8_r8,             &i386_device::i386_add_rm8_r8,         true },
	{ 0x01,     OP_I386,                    &i386_device::i386_add_rm16_r16,           &i386_device::i386_add_rm32_r32,       true },
	{ 0x02,     OP_I386,                    &i386_device::i386_add_r8_rm8,             &i386_device::i386_add_r8_rm8,         false},
	{ 0x03,     OP_I386,                    &i386_device::i386_add_r16_rm16,           &i386_device::i386_add_r32_rm32,       false},
	{ 0x04,     OP_I386,                    &i386_device::i386_add_al_i8,              &i386_device::i386_add_al_i8,          false},
	{ 0x05,     OP_I386,                    &i386_device::i386_add_ax_i16,             &i386_device::i386_add_eax_i32,        false},
	{ 0x06,     OP_I386,                    &i386_device::i386_push_es16,              &i386_device::i386_push_es32,          false},
	{ 0x07,     OP_I386,                    &i386_device::i386_pop_es16,               &i386_device::i386_pop_es32,           false},
	{ 0x08,     OP_I386,                    &i386_device::i386_or_rm8_r8,              &i386_device::i386_or_rm8_r8,          true },
	{ 0x09,     OP_I386,                    &i386_device::i386_or_rm16_r16,            &i386_device::i386_or_rm32_r32,        true },
	{ 0x0A,     OP_I386,                    &i386_device::i386_or_r8_rm8,              &i386_device::i386_or_r8_rm8,          false},
	{ 0x0B,     OP_I386,                    &i386_device::i386_or_r16_rm16,            &i386_device::i386_or_r32_rm32,        false},
	{ 0x0C,     OP_I386,                    &i386_device::i386_or_al_i8,               &i386_device::i386_or_al_i8,           false},
	{ 0x0D,     OP_I386,                    &i386_device::i386_or_ax_i16,              &i386_device::i386_or_eax_i32,         false},
	{ 0x0E,     OP_I386,                    &i386_device::i386_push_cs16,              &i386_device::i386_push_cs32,          false},
	{ 0x0F,     OP_I386,                    &i386_device::i386_decode_two_byte,        &i386_device::i386_decode_two_byte,    true },
	{ 0x10,     OP_I386,                    &i386_device::i386_adc_rm8_r8,             &i386_device::i386_adc_rm8_r8,         true },
	{ 0x11,     OP_I386,                    &i386_device::i386_adc_rm16_r16,           &i386_device::i386_adc_rm32_r32,       true },
	{ 0x12,     OP_I386,                    &i386_device::i386_adc_r8_rm8,             &i386_device::i386_adc_r8_rm8,         false},
	{ 0x13,     OP_I386,                    &i386_device::i386_adc_r16_rm16,           &i386_device::i386_adc_r32_rm32,       false},
	{ 0x14,     OP_I386,                    &i386_device::i386_adc_al_i8,              &i386_device::i386_adc_al_i8,          false},
	{ 0x15,     OP_I386,                    &i386_device::i386_adc_ax_i16,             &i386_device::i386_adc_eax_i32,        false},
	{ 0x16,     OP_I386,                    &i386_device::i386_push_ss16,              &i386_device::i386_push_ss32,          false},
	{ 0x17,     OP_I386,                    &i386_device::i386_pop_ss16,               &i386_device::i386_pop_ss32,           false},
	{ 0x18,     OP_I386,                    &i386_device::i386_sbb_rm8_r8,             &i386_device::i386_sbb_rm8_r8,         true },
	{ 0x19,     OP_I386,                    &i386_device::i386_sbb_rm16_r16,           &i386_device::i386_sbb_rm32_r32,       true },
	{ 0x1A,     OP_I386,                    &i386_device::i386_sbb_r8_rm8,             &i386_device::i386_sbb_r8_rm8,         false},
	{ 0x1B,     OP_I386,                    &i386_device::i386_sbb_r16_rm16,           &i386_device::i386_sbb_r32_rm32,       false},
	{ 0x1C,     OP_I386,                    &i386_device::i386_sbb_al_i8,              &i386_device::i386_sbb_al_i8,          false},
	{ 0x1D,     OP_I386,                    &i386_device::i386_sbb_ax_i16,             &i386_device::i386_sbb_eax_i32,        false},
	{ 0x1E,     OP_I386,                    &i386_device::i386_push_ds16,              &i386_device::i386_push_ds32,          false},
	{ 0x1F,     OP_I386,                    &i386_device::i386_pop_ds16,               &i386_device::i386_pop_ds32,           false},
	{ 0x20,     OP_I386,                    &i386_device::i386_and_rm8_r8,             &i386_device::i386_and_rm8_r8,         true },
	{ 0x21,     OP_I386,                    &i386_device::i386_and_rm16_r16,           &i386_device::i386_and_rm32_r32,       true },
	{ 0x22,     OP_I386,                    &i386_device::i386_and_r8_rm8,             &i386_device::i386_and_r8_rm8,         false},
	{ 0x23,     OP_I386,                    &i386_device::i386_and_r16_rm16,           &i386_device::i386_and_r32_rm32,       false},
	{ 0x24,     OP_I386,                    &i386_device::i386_and_al_i8,              &i386_device::i386_and_al_i8,          false},
	{ 0x25,     OP_I386,                    &i386_device::i386_and_ax_i16,             &i386_device::i386_and_eax_i32,        false},
	{ 0x26,     OP_I386,                    &i386_device::i386_segment_ES,             &i386_device::i386_segment_ES,         false},
	{ 0x27,     OP_I386,                    &i386_device::i386_daa,                    &i386_device::i386_daa,                false},
	{ 0x28,     OP_I386,                    &i386_device::i386_sub_rm8_r8,             &i386_device::i386_sub_rm8_r8,         true },
	{ 0x29,     OP_I386,                    &i386_device::i386_sub_rm16_r16,           &i386_device::i386_sub_rm32_r32,       true },
	{ 0x2A,     OP_I386,                    &i386_device::i386_sub_r8_rm8,             &i386_device::i386_sub_r8_rm8,         false},
	{ 0x2B,     OP_I386,                    &i386_device::i386_sub_r16_rm16,           &i386_device::i386_sub_r32_rm32,       false},
	{ 0x2C,     OP_I386,                    &i386_device::i386_sub_al_i8,              &i386_device::i386_sub_al_i8,          false},
	{ 0x2D,     OP_I386,                    &i386_device::i386_sub_ax_i16,             &i386_device::i386_sub_eax_i32,        false},
	{ 0x2E,     OP_I386,                    &i386_device::i386_segment_CS,             &i386_device::i386_segment_CS,         false},
	{ 0x2F,     OP_I386,                    &i386_device::i386_das,                    &i386_device::i386_das,                false},
	{ 0x30,     OP_I386,                    &i386_device::i386_xor_rm8_r8,             &i386_device::i386_xor_rm8_r8,         true },
	{ 0x31,     OP_I386,                    &i386_device::i386_xor_rm16_r16,           &i386_device::i386_xor_rm32_r32,       true },
	{ 0x32,     OP_I386,                    &i386_device::i386_xor_r8_rm8,             &i386_device::i386_xor_r8_rm8,         false},
	{ 0x33,     OP_I386,                    &i386_device::i386_xor_r16_rm16,           &i386_device::i386_xor_r32_rm32,       false},
	{ 0x34,     OP_I386,                    &i386_device::i386_xor_al_i8,              &i386_device::i386_xor_al_i8,          false},
	{ 0x35,     OP_I386,                    &i386_device::i386_xor_ax_i16,             &i386_device::i386_xor_eax_i32,        false},
	{ 0x36,     OP_I386,                    &i386_device::i386_segment_SS,             &i386_device::i386_segment_SS,         false},
	{ 0x37,     OP_I386,                    &i386_device::i386_aaa,                    &i386_device::i386_aaa,                false},
	{ 0x38,     OP_I386,                    &i386_device::i386_cmp_rm8_r8,             &i386_device::i386_cmp_rm8_r8,         false},
	{ 0x39,     OP_I386,                    &i386_device::i386_cmp_rm16_r16,           &i386_device::i386_cmp_rm32_r32,       false},
	{ 0x3A,     OP_I386,                    &i386_device::i386_cmp_r8_rm8,             &i386_device::i386_cmp_r8_rm8,         false},
	{ 0x3B,     OP_I386,                    &i386_device::i386_cmp_r16_rm16,           &i386_device::i386_cmp_r32_rm32,       false},
	{ 0x3C,     OP_I386,                    &i386_device::i386_cmp_al_i8,              &i386_device::i386_cmp_al_i8,          false},
	{ 0x3D,     OP_I386,                    &i386_device::i386_cmp_ax_i16,             &i386_device::i386_cmp_eax_i32,        false},
	{ 0x3E,     OP_I386,                    &i386_device::i386_segment_DS,             &i386_device::i386_segment_DS,         false},
	{ 0x3F,     OP_I386,                    &i386_device::i386_aas,                    &i386_device::i386_aas,                false},
	{ 0x40,     OP_I386,                    &i386_device::i386_inc_ax,                 &i386_device::i386_inc_eax,            false},
	{ 0x41,     OP_I386,                    &i386_device::i386_inc_cx,                 &i386_device::i386_inc_ecx,            false},
	{ 0x42,     OP_I386,                    &i386_device::i386_inc_dx,                 &i386_device::i386_inc_edx,            false},
	{ 0x43,     OP_I386,                    &i386_device::i386_inc_bx,                 &i386_device::i386_inc_ebx,            false},
	{ 0x44,     OP_I386,                    &i386_device::i386_inc_sp,                 &i386_device::i386_inc_esp,            false},
	{ 0x45,     OP_I386,                    &i386_device::i386_inc_bp,                 &i386_device::i386_inc_ebp,            false},
	{ 0x46,     OP_I386,                    &i386_device::i386_inc_si,                 &i386_device::i386_inc_esi,            false},
	{ 0x47,     OP_I386,                    &i386_device::i386_inc_di,                 &i386_device::i386_inc_edi,            false},
	{ 0x48,     OP_I386,                    &i386_device::i386_dec_ax,                 &i386_device::i386_dec_eax,            false},
	{ 0x49,     OP_I386,                    &i386_device::i386_dec_cx,                 &i386_device::i386_dec_ecx,            false},
	{ 0x4A,     OP_I386,                    &i386_device::i386_dec_dx,                 &i386_device::i386_dec_edx,            false},
	{ 0x4B,     OP_I386,                    &i386_device::i386_dec_bx,                 &i386_device::i386_dec_ebx,            false},
	{ 0x4C,     OP_I386,                    &i386_device::i386_dec_sp,                 &i386_device::i386_dec_esp,            false},
	{ 0x4D,     OP_I386,                    &i386_device::i386_dec_bp,                 &i386_device::i386_dec_ebp,            false},
	{ 0x4E,     OP_I386,                    &i386_device::i386_dec_si,                 &i386_device::i386_dec_esi,            false},
	{ 0x4F,     OP_I386,                    &i386_device::i386_dec_di,                 &i386_device::i386_dec_edi,            false},
	{ 0x50,     OP_I386,                    &i386_device::i386_push_ax,                &i386_device::i386_push_eax,           false},
	{ 0x51,     OP_I386,                    &i386_device::i386_push_cx,                &i386_device::i386_push_ecx,           false},
	{ 0x52,     OP_I386,                    &i386_device::i386_push_dx,                &i386_device::i386_push_edx,           false},
	{ 0x53,     OP_I386,                    &i386_device::i386_push_bx,                &i386_device::i386_push_ebx,           false},
	{ 0x54,     OP_I386,                    &i386_device::i386_push_sp,                &i386_device::i386_push_esp,           false},
	{ 0x55,     OP_I386,                    &i386_device::i386_push_bp,                &i386_device::i386_push_ebp,           false},
	{ 0x56,     OP_I386,                    &i386_device::i386_push_si,                &i386_device::i386_push_esi,           false},
	{ 0x57,     OP_I386,                    &i386_device::i386_push_di,                &i386_device::i386_push_edi,           false},
	{ 0x58,     OP_I386,                    &i386_device::i386_pop_ax,                 &i386_device::i386_pop_eax,            false},
	{ 0x59,     OP_I386,                    &i386_device::i386_pop_cx,                 &i386_device::i386_pop_ecx,            false},
	{ 0x5A,     OP_I386,                    &i386_device::i386_pop_dx,                 &i386_device::i386_pop_edx,            false},
	{ 0x5B,     OP_I386,                    &i386_device::i386_pop_bx,                 &i386_device::i386_pop_ebx,            false},
	{ 0x5C,     OP_I386,                    &i386_device::i386_pop_sp,                 &i386_device::i386_pop_esp,            false},
	{ 0x5D,     OP_I386,                    &i386_device::i386_pop_bp,                 &i386_device::i386_pop_ebp,            false},
	{ 0x5E,     OP_I386,                    &i386_device::i386_pop_si,                 &i386_device::i386_pop_esi,            false},
	{ 0x5F,     OP_I386,                    &i386_device::i386_pop_di,                 &i386_device::i386_pop_edi,            false},
	{ 0x60,     OP_I386,                    &i386_device::i386_pusha,                  &i386_device::i386_pushad,             false},
	{ 0x61,     OP_I386,                    &i386_device::i386_popa,                   &i386_device::i386_popad,              false},
	{ 0x62,     OP_I386,                    &i386_device::i386_bound_r16_m16_m16,      &i386_device::i386_bound_r32_m32_m32,  false},
	{ 0x63,     OP_I386,                    &i386_device::i386_arpl,                   &i386_device::i386_arpl,               false},
	{ 0x64,     OP_I386,                    &i386_device::i386_segment_FS,             &i386_device::i386_segment_FS,         false},
	{ 0x65,     OP_I386,                    &i386_device::i386_segment_GS,             &i386_device::i386_segment_GS,         false},
	{ 0x66,     OP_I386,                    &i386_device::i386_operand_size,           &i386_device::i386_operand_size,       false},
	{ 0x67,     OP_I386,                    &i386_device::i386_address_size,           &i386_device::i386_address_size,       false},
	{ 0x68,     OP_I386,                    &i386_device::i386_push_i16,               &i386_device::i386_push_i32,           false},
	{ 0x69,     OP_I386,                    &i386_device::i386_imul_r16_rm16_i16,      &i386_device::i386_imul_r32_rm32_i32,  false},
	{ 0x6A,     OP_I386,                    &i386_device::i386_push_i8,                &i386_device::i386_push_i8,            false},
	{ 0x6B,     OP_I386,                    &i386_device::i386_imul_r16_rm16_i8,       &i386_device::i386_imul_r32_rm32_i8,   false},
	{ 0x6C,     OP_I386,                    &i386_device::i386_insb,                   &i386_device::i386_insb,               false},
	{ 0x6D,     OP_I386,                    &i386_device::i386_insw,                   &i386_device::i386_insd,               false},
	{ 0x6E,     OP_I386,                    &i386_device::i386_outsb,                  &i386_device::i386_outsb,              false},
	{ 0x6F,     OP_I386,                    &i386_device::i386_outsw,                  &i386_device::i386_outsd,              false},
	{ 0x70,     OP_I386,                    &i386_device::i386_jo_rel8,                &i386_device::i386_jo_rel8,            false},
	{ 0x71,     OP_I386,                    &i386_device::i386_jno_rel8,               &i386_device::i386_jno_rel8,           false},
	{ 0x72,     OP_I386,                    &i386_device::i386_jc_rel8,                &i386_device::i386_jc_rel8,            false},
	{ 0x73,     OP_I386,                    &i386_device::i386_jnc_rel8,               &i386_device::i386_jnc_rel8,           false},
	{ 0x74,     OP_I386,                    &i386_device::i386_jz_rel8,                &i386_device::i386_jz_rel8,            false},
	{ 0x75,     OP_I386,                    &i386_device::i386_jnz_rel8,               &i386_device::i386_jnz_rel8,           false},
	{ 0x76,     OP_I386,                    &i386_device::i386_jbe_rel8,               &i386_device::i386_jbe_rel8,           false},
	{ 0x77,     OP_I386,                    &i386_device::i386_ja_rel8,                &i386_device::i386_ja_rel8,            false},
	{ 0x78,     OP_I386,                    &i386_device::i386_js_rel8,                &i386_device::i386_js_rel8,            false},
	{ 0x79,     OP_I386,                    &i386_device::i386_jns_rel8,               &i386_device::i386_jns_rel8,           false},
	{ 0x7A,     OP_I386,                    &i386_device::i386_jp_rel8,                &i386_device::i386_jp_rel8,            false},
	{ 0x7B,     OP_I386,                    &i386_device::i386_jnp_rel8,               &i386_device::i386_jnp_rel8,           false},
	{ 0x7C,     OP_I386,                    &i386_device::i386_jl_rel8,                &i386_device::i386_jl_rel8,            false},
	{ 0x7D,     OP_I386,                    &i386_device::i386_jge_rel8,               &i386_device::i386_jge_rel8,           false},
	{ 0x7E,     OP_I386,                    &i386_device::i386_jle_rel8,               &i386_device::i386_jle_rel8,           false},
	{ 0x7F,     OP_I386,                    &i386_device::i386_jg_rel8,                &i386_device::i386_jg_rel8,            false},
	{ 0x80,     OP_I386,                    &i386_device::i386_group80_8,              &i386_device::i386_group80_8,          true },
	{ 0x81,     OP_I386,                    &i386_device::i386_group81_16,             &i386_device::i386_group81_32,         true },
	{ 0x82,     OP_I386,                    &i386_device::i386_group80_8,              &i386_device::i386_group80_8,          true },
	{ 0x83,     OP_I386,                    &i386_device::i386_group83_16,             &i386_device::i386_group83_32,         true },
	{ 0x84,     OP_I386,                    &i386_device::i386_test_rm8_r8,            &i386_device::i386_test_rm8_r8,        false},
	{ 0x85,     OP_I386,                    &i386_device::i386_test_rm16_r16,          &i386_device::i386_test_rm32_r32,      false},
	{ 0x86,     OP_I386,                    &i386_device::i386_xchg_r8_rm8,            &i386_device::i386_xchg_r8_rm8,        true },
	{ 0x87,     OP_I386,                    &i386_device::i386_xchg_r16_rm16,          &i386_device::i386_xchg_r32_rm32,      true },
	{ 0x88,     OP_I386,                    &i386_device::i386_mov_rm8_r8,             &i386_device::i386_mov_rm8_r8,         false},
	{ 0x89,     OP_I386,                    &i386_device::i386_mov_rm16_r16,           &i386_device::i386_mov_rm32_r32,       false},
	{ 0x8A,     OP_I386,                    &i386_device::i386_mov_r8_rm8,             &i386_device::i386_mov_r8_rm8,         false},
	{ 0x8B,     OP_I386,                    &i386_device::i386_mov_r16_rm16,           &i386_device::i386_mov_r32_rm32,       false},
	{ 0x8C,     OP_I386,                    &i386_device::i386_mov_rm16_sreg,          &i386_device::i386_mov_rm16_sreg,      false},
	{ 0x8D,     OP_I386,                    &i386_device::i386_lea16,                  &i386_device::i386_lea32,              false},
	{ 0x8E,     OP_I386,                    &i386_device::i386_mov_sreg_rm16,          &i386_device::i386_mov_sreg_rm16,      false},
	{ 0x8F,     OP_I386,                    &i386_device::i386_pop_rm16,               &i386_device::i386_pop_rm32,           false},
	{ 0x90,     OP_I386,                    &i386_device::i386_nop,                    &i386_device::i386_nop,                false},
	{ 0x91,     OP_I386,                    &i386_device::i386_xchg_ax_cx,             &i386_device::i386_xchg_eax_ecx,       false},
	{ 0x92,     OP_I386,                    &i386_device::i386_xchg_ax_dx,             &i386_device::i386_xchg_eax_edx,       false},
	{ 0x93,     OP_I386,                    &i386_device::i386_xchg_ax_bx,             &i386_device::i386_xchg_eax_ebx,       false},
	{ 0x94,     OP_I386,                    &i386_device::i386_xchg_ax_sp,             &i386_device::i386_xchg_eax_esp,       false},
	{ 0x95,     OP_I386,                    &i386_device::i386_xchg_ax_bp,             &i386_device::i386_xchg_eax_ebp,       false},
	{ 0x96,     OP_I386,                    &i386_device::i386_xchg_ax_si,             &i386_device::i386_xchg_eax_esi,       false},
	{ 0x97,     OP_I386,                    &i386_device::i386_xchg_ax_di,             &i386_device::i386_xchg_eax_edi,       false},
	{ 0x98,     OP_I386,                    &i386_device::i386_cbw,                    &i386_device::i386_cwde,               false},
	{ 0x99,     OP_I386,                    &i386_device::i386_cwd,                    &i386_device::i386_cdq,                false},
	{ 0x9A,     OP_I386,                    &i386_device::i386_call_abs16,             &i386_device::i386_call_abs32,         false},
	{ 0x9B,     OP_I386,                    &i386_device::i386_wait,                   &i386_device::i386_wait,               false},
	{ 0x9C,     OP_I386,                    &i386_device::i386_pushf,                  &i386_device::i386_pushfd,             false},
	{ 0x9D,     OP_I386,                    &i386_device::i386_popf,                   &i386_device::i386_popfd,              false},
	{ 0x9E,     OP_I386,                    &i386_device::i386_sahf,                   &i386_device::i386_sahf,               false},
	{ 0x9F,     OP_I386,                    &i386_device::i386_lahf,                   &i386_device::i386_lahf,               false},
	{ 0xA0,     OP_I386,                    &i386_device::i386_mov_al_m8,              &i386_device::i386_mov_al_m8,          false},
	{ 0xA1,     OP_I386,                    &i386_device::i386_mov_ax_m16,             &i386_device::i386_mov_eax_m32,        false},
	{ 0xA2,     OP_I386,                    &i386_device::i386_mov_m8_al,              &i386_device::i386_mov_m8_al,          false},
	{ 0xA3,     OP_I386,                    &i386_device::i386_mov_m16_ax,             &i386_device::i386_mov_m32_eax,        false},
	{ 0xA4,     OP_I386,                    &i386_device::i386_movsb,                  &i386_device::i386_movsb,              false},
	{ 0xA5,     OP_I386,                    &i386_device::i386_movsw,                  &i386_device::i386_movsd,              false},
	{ 0xA6,     OP_I386,                    &i386_device::i386_cmpsb,                  &i386_device::i386_cmpsb,              false},
	{ 0xA7,     OP_I386,                    &i386_device::i386_cmpsw,                  &i386_device::i386_cmpsd,              false},
	{ 0xA8,     OP_I386,                    &i386_device::i386_test_al_i8,             &i386_device::i386_test_al_i8,         false},
	{ 0xA9,     OP_I386,                    &i386_device::i386_test_ax_i16,            &i386_device::i386_test_eax_i32,       false},
	{ 0xAA,     OP_I386,                    &i386_device::i386_stosb,                  &i386_device::i386_stosb,              false},
	{ 0xAB,     OP_I386,                    &i386_device::i386_stosw,                  &i386_device::i386_stosd,              false},
	{ 0xAC,     OP_I386,                    &i386_device::i386_lodsb,                  &i386_device::i386_lodsb,              false},
	{ 0xAD,     OP_I386,                    &i386_device::i386_lodsw,                  &i386_device::i386_lodsd,              false},
	{ 0xAE,     OP_I386,                    &i386_device::i386_scasb,                  &i386_device::i386_scasb,              false},
	{ 0xAF,     OP_I386,                    &i386_device::i386_scasw,                  &i386_device::i386_scasd,              false},
	{ 0xB0,     OP_I386,                    &i386_device::i386_mov_al_i8,              &i386_device::i386_mov_al_i8,          false},
	{ 0xB1,     OP_I386,                    &i386_device::i386_mov_cl_i8,              &i386_device::i386_mov_cl_i8,          false},
	{ 0xB2,     OP_I386,                    &i386_device::i386_mov_dl_i8,              &i386_device::i386_mov_dl_i8,          false},
	{ 0xB3,     OP_I386,                    &i386_device::i386_mov_bl_i8,              &i386_device::i386_mov_bl_i8,          false},
	{ 0xB4,     OP_I386,                    &i386_device::i386_mov_ah_i8,              &i386_device::i386_mov_ah_i8,          false},
	{ 0xB5,     OP_I386,                    &i386_device::i386_mov_ch_i8,              &i386_device::i386_mov_ch_i8,          false},
	{ 0xB6,     OP_I386,                    &i386_device::i386_mov_dh_i8,              &i386_device::i386_mov_dh_i8,          false},
	{ 0xB7,     OP_I386,                    &i386_device::i386_mov_bh_i8,              &i386_device::i386_mov_bh_i8,          false},
	{ 0xB8,     OP_I386,                    &i386_device::i386_mov_ax_i16,             &i386_device::i386_mov_eax_i32,        false},
	{ 0xB9,     OP_I386,                    &i386_device::i386_mov_cx_i16,             &i386_device::i386_mov_ecx_i32,        false},
	{ 0xBA,     OP_I386,                    &i386_device::i386_mov_dx_i16,             &i386_device::i386_mov_edx_i32,        false},
	{ 0xBB,     OP_I386,                    &i386_device::i386_mov_bx_i16,             &i386_device::i386_mov_ebx_i32,        false},
	{ 0xBC,     OP_I386,                    &i386_device::i386_mov_sp_i16,             &i386_device::i386_mov_esp_i32,        false},
	{ 0xBD,     OP_I386,                    &i386_device::i386_mov_bp_i16,             &i386_device::i386_mov_ebp_i32,        false},
	{ 0xBE,     OP_I386,                    &i386_device::i386_mov_si_i16,             &i386_device::i386_mov_esi_i32,        false},
	{ 0xBF,     OP_I386,                    &i386_device::i386_mov_di_i16,             &i386_device::i386_mov_edi_i32,        false},
	{ 0xC0,     OP_I386,                    &i386_device::i386_groupC0_8,              &i386_device::i386_groupC0_8,          false},
	{ 0xC1,     OP_I386,                    &i386_device::i386_groupC1_16,             &i386_device::i386_groupC1_32,         false},
	{ 0xC2,     OP_I386,                    &i386_device::i386_ret_near16_i16,         &i386_device::i386_ret_near32_i16,     false},
	{ 0xC3,     OP_I386,                    &i386_device::i386_ret_near16,             &i386_device::i386_ret_near32,         false},
	{ 0xC4,     OP_I386,                    &i386_device::i386_les16,                  &i386_device::i386_les32,              false},
	{ 0xC5,     OP_I386,                    &i386_device::i386_lds16,                  &i386_device::i386_lds32,              false},
	{ 0xC6,     OP_I386,                    &i386_device::i386_mov_rm8_i8,             &i386_device::i386_mov_rm8_i8,         false},
	{ 0xC7,     OP_I386,                    &i386_device::i386_mov_rm16_i16,           &i386_device::i386_mov_rm32_i32,       false},
	{ 0xC8,     OP_I386,                    &i386_device::i386_enter16,                &i386_device::i386_enter32,            false},
	{ 0xC9,     OP_I386,                    &i386_device::i386_leave16,                &i386_device::i386_leave32,            false},
	{ 0xCA,     OP_I386,                    &i386_device::i386_retf_i16,               &i386_device::i386_retf_i32,           false},
	{ 0xCB,     OP_I386,                    &i386_device::i386_retf16,                 &i386_device::i386_retf32,             false},
	{ 0xCC,     OP_I386,                    &i386_device::i386_int3,                   &i386_device::i386_int3,               false},
	{ 0xCD,     OP_I386,                    &i386_device::i386_int,                    &i386_device::i386_int,                false},
	{ 0xCE,     OP_I386,                    &i386_device::i386_into,                   &i386_device::i386_into,               false},
	{ 0xCF,     OP_I386,                    &i386_device::i386_iret16,                 &i386_device::i386_iret32,             false},
	{ 0xD0,     OP_I386,                    &i386_device::i386_groupD0_8,              &i386_device::i386_groupD0_8,          false},
	{ 0xD1,     OP_I386,                    &i386_device::i386_groupD1_16,             &i386_device::i386_groupD1_32,         false},
	{ 0xD2,     OP_I386,                    &i386_device::i386_groupD2_8,              &i386_device::i386_groupD2_8,          false},
	{ 0xD3,     OP_I386,                    &i386_device::i386_groupD3_16,             &i386_device::i386_groupD3_32,         false},
	{ 0xD4,     OP_I386,                    &i386_device::i386_aam,                    &i386_device::i386_aam,                false},
	{ 0xD5,     OP_I386,                    &i386_device::i386_aad,                    &i386_device::i386_aad,                false},
	{ 0xD6,     OP_I386,                    &i386_device::i386_setalc,                 &i386_device::i386_setalc,             false},
	{ 0xD7,     OP_I386,                    &i386_device::i386_xlat,                   &i386_device::i386_xlat,               false},
	{ 0xD8,     OP_I386,                    &i386_device::i386_escape,                 &i386_device::i386_escape,             false},
	{ 0xD9,     OP_I386,                    &i386_device::i386_escape,                 &i386_device::i386_escape,             false},
	{ 0xDA,     OP_I386,                    &i386_device::i386_escape,                 &i386_device::i386_escape,             false},
	{ 0xDB,     OP_I386,                    &i386_device::i386_escape,                 &i386_device::i386_escape,             false},
	{ 0xDC,     OP_I386,                    &i386_device::i386_escape,                 &i386_device::i386_escape,             false},
	{ 0xDD,     OP_I386,                    &i386_device::i386_escape,                 &i386_device::i386_escape,             false},
	{ 0xDE,     OP_I386,                    &i386_device::i386_escape,                 &i386_device::i386_escape,             false},
	{ 0xDF,     OP_I386,                    &i386_device::i386_escape,                 &i386_device::i386_escape,             false},
	{ 0xD8,     OP_FPU,                     &i386_device::i386_x87_group_d8,           &i386_device::i386_x87_group_d8,       false},
	{ 0xD9,     OP_FPU,                     &i386_device::i386_x87_group_d9,           &i386_device::i386_x87_group_d9,       false},
	{ 0xDA,     OP_FPU,                     &i386_device::i386_x87_group_da,           &i386_device::i386_x87_group_da,       false},
	{ 0xDB,     OP_FPU,                     &i386_device::i386_x87_group_db,           &i386_device::i386_x87_group_db,       false},
	{ 0xDC,     OP_FPU,                     &i386_device::i386_x87_group_dc,           &i386_device::i386_x87_group_dc,       false},
	{ 0xDD,     OP_FPU,                     &i386_device::i386_x87_group_dd,           &i386_device::i386_x87_group_dd,       false},
	{ 0xDE,     OP_FPU,                     &i386_device::i386_x87_group_de,           &i386_device::i386_x87_group_de,       false},
	{ 0xDF,     OP_FPU,                     &i386_device::i386_x87_group_df,           &i386_device::i386_x87_group_df,       false},
	{ 0xE0,     OP_I386,                    &i386_device::i386_loopne16,               &i386_device::i386_loopne32,           false},
	{ 0xE1,     OP_I386,                    &i386_device::i386_loopz16,                &i386_device::i386_loopz32,            false},
	{ 0xE2,     OP_I386,                    &i386_device::i386_loop16,                 &i386_device::i386_loop32,             false},
	{ 0xE3,     OP_I386,                    &i386_device::i386_jcxz16,                 &i386_device::i386_jcxz32,             false},
	{ 0xE4,     OP_I386,                    &i386_device::i386_in_al_i8,               &i386_device::i386_in_al_i8,           false},
	{ 0xE5,     OP_I386,                    &i386_device::i386_in_ax_i8,               &i386_device::i386_in_eax_i8,          false},
	{ 0xE6,     OP_I386,                    &i386_device::i386_out_al_i8,              &i386_device::i386_out_al_i8,          false},
	{ 0xE7,     OP_I386,                    &i386_device::i386_out_ax_i8,              &i386_device::i386_out_eax_i8,         false},
	{ 0xE8,     OP_I386,                    &i386_device::i386_call_rel16,             &i386_device::i386_call_rel32,         false},
	{ 0xE9,     OP_I386,                    &i386_device::i386_jmp_rel16,              &i386_device::i386_jmp_rel32,          false},
	{ 0xEA,     OP_I386,                    &i386_device::i386_jmp_abs16,              &i386_device::i386_jmp_abs32,          false},
	{ 0xEB,     OP_I386,                    &i386_device::i386_jmp_rel8,               &i386_device::i386_jmp_rel8,           false},
	{ 0xEC,     OP_I386,                    &i386_device::i386_in_al_dx,               &i386_device::i386_in_al_dx,           false},
	{ 0xED,     OP_I386,                    &i386_device::i386_in_ax_dx,               &i386_device::i386_in_eax_dx,          false},
	{ 0xEE,     OP_I386,                    &i386_device::i386_out_al_dx,              &i386_device::i386_out_al_dx,          false},
	{ 0xEF,     OP_I386,                    &i386_device::i386_out_ax_dx,              &i386_device::i386_out_eax_dx,         false},
	{ 0xF0,     OP_I386,                    &i386_device::i386_lock,                   &i386_device::i386_lock,               false},
	{ 0xF1,     OP_I386,                    &i386_device::i386_invalid,                &i386_device::i386_invalid,            false},
	{ 0xF2,     OP_I386,                    &i386_device::i386_repne,                  &i386_device::i386_repne,              false},
	{ 0xF3,     OP_I386,                    &i386_device::i386_rep,                    &i386_device::i386_rep,                false},
	{ 0xF4,     OP_I386,                    &i386_device::i386_hlt,                    &i386_device::i386_hlt,                false},
	{ 0xF5,     OP_I386,                    &i386_device::i386_cmc,                    &i386_device::i386_cmc,                false},
	{ 0xF6,     OP_I386,                    &i386_device::i386_groupF6_8,              &i386_device::i386_groupF6_8,          true },
	{ 0xF7,     OP_I386,                    &i386_device::i386_groupF7_16,             &i386_device::i386_groupF7_32,         true },
	{ 0xF8,     OP_I386,                    &i386_device::i386_clc,                    &i386_device::i386_clc,                false},
	{ 0xF9,     OP_I386,                    &i386_device::i386_stc,                    &i386_device::i386_stc,                false},
	{ 0xFA,     OP_I386,                    &i386_device::i386_cli,                    &i386_device::i386_cli,                false},
	{ 0xFB,     OP_I386,                    &i386_device::i386_sti,                    &i386_device::i386_sti,                false},
	{ 0xFC,     OP_I386,                    &i386_device::i386_cld,                    &i386_device::i386_cld,                false},
	{ 0xFD,     OP_I386,                    &i386_device::i386_std,                    &i386_device::i386_std,                false},
	{ 0xFE,     OP_I386,                    &i386_device::i386_groupFE_8,              &i386_device::i386_groupFE_8,          true },
	{ 0xFF,     OP_I386,                    &i386_device::i386_groupFF_16,             &i386_device::i386_groupFF_32,         true },
	/* 0F ?? */
	{ 0x00,     OP_2BYTE|OP_I386,           &i386_device::i386_group0F00_16,           &i386_device::i386_group0F00_32,       false},
	{ 0x01,     OP_2BYTE|OP_I386,           &i386_device::i386_group0F01_16,           &i386_device::i386_group0F01_32,       false},
	{ 0x01,     OP_2BYTE|OP_I486,           &i386_device::i486_group0F01_16,           &i386_device::i486_group0F01_32,       false},
	{ 0x02,     OP_2BYTE|OP_I386,           &i386_device::i386_lar_r16_rm16,           &i386_device::i386_lar_r32_rm32,       false},
	{ 0x03,     OP_2BYTE|OP_I386,           &i386_device::i386_lsl_r16_rm16,           &i386_device::i386_lsl_r32_rm32,       false},
	{ 0x06,     OP_2BYTE|OP_I386,           &i386_device::i386_clts,                   &i386_device::i386_clts,               false},
	{ 0x07,     OP_2BYTE|OP_I386,           &i386_device::i386_loadall,                &i386_device::i386_loadall,            false},
	{ 0x08,     OP_2BYTE|OP_I486,           &i386_device::i486_invd,                   &i386_device::i486_invd,               false},
	{ 0x09,     OP_2BYTE|OP_I486,           &i386_device::i486_wbinvd,                 &i386_device::i486_wbinvd,             false},
	{ 0x0B,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_ud2,                 &i386_device::pentium_ud2,             false},
	{ 0x10,     OP_2BYTE|OP_SSE,            &i386_device::sse_movups_r128_rm128,       &i386_device::sse_movups_r128_rm128,   false},
	{ 0x11,     OP_2BYTE|OP_SSE,            &i386_device::sse_movups_rm128_r128,       &i386_device::sse_movups_rm128_r128,   false},
	{ 0x12,     OP_2BYTE|OP_SSE,            &i386_device::sse_movlps_r128_m64,         &i386_device::sse_movlps_r128_m64,     false},
	{ 0x13,     OP_2BYTE|OP_SSE,            &i386_device::sse_movlps_m64_r128,         &i386_device::sse_movlps_m64_r128,     false},
	{ 0x14,     OP_2BYTE|OP_SSE,            &i386_device::sse_unpcklps_r128_rm128,     &i386_device::sse_unpcklps_r128_rm128, false},
	{ 0x15,     OP_2BYTE|OP_SSE,            &i386_device::sse_unpckhps_r128_rm128,     &i386_device::sse_unpckhps_r128_rm128, false},
	{ 0x16,     OP_2BYTE|OP_SSE,            &i386_device::sse_movhps_r128_m64,         &i386_device::sse_movhps_r128_m64,     false},
	{ 0x17,     OP_2BYTE|OP_SSE,            &i386_device::sse_movhps_m64_r128,         &i386_device::sse_movhps_m64_r128,     false},
	{ 0x18,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_prefetch_m8,         &i386_device::pentium_prefetch_m8,     false},
	{ 0x20,     OP_2BYTE|OP_I386,           &i386_device::i386_mov_r32_cr,             &i386_device::i386_mov_r32_cr,         false},
	{ 0x21,     OP_2BYTE|OP_I386,           &i386_device::i386_mov_r32_dr,             &i386_device::i386_mov_r32_dr,         false},
	{ 0x22,     OP_2BYTE|OP_I386,           &i386_device::i386_mov_cr_r32,             &i386_device::i386_mov_cr_r32,         false},
	{ 0x22,     OP_2BYTE|OP_I486,           &i386_device::i486_mov_cr_r32,             &i386_device::i486_mov_cr_r32,         false},
	{ 0x23,     OP_2BYTE|OP_I386,           &i386_device::i386_mov_dr_r32,             &i386_device::i386_mov_dr_r32,         false},
	{ 0x24,     OP_2BYTE|OP_I386,           &i386_device::i386_mov_r32_tr,             &i386_device::i386_mov_r32_tr,         false},
	{ 0x26,     OP_2BYTE|OP_I386,           &i386_device::i386_mov_tr_r32,             &i386_device::i386_mov_tr_r32,         false},
	{ 0x28,     OP_2BYTE|OP_SSE,            &i386_device::sse_movaps_r128_rm128,       &i386_device::sse_movaps_r128_rm128,   false},
	{ 0x29,     OP_2BYTE|OP_SSE,            &i386_device::sse_movaps_rm128_r128,       &i386_device::sse_movaps_rm128_r128,   false},
	{ 0x2a,     OP_2BYTE|OP_SSE,            &i386_device::sse_cvtpi2ps_r128_rm64,      &i386_device::sse_cvtpi2ps_r128_rm64,  false},
	{ 0x2b,     OP_2BYTE|OP_SSE,            &i386_device::sse_movntps_m128_r128,       &i386_device::sse_movntps_m128_r128,   false},
	{ 0x2c,     OP_2BYTE|OP_SSE,            &i386_device::sse_cvttps2pi_r64_r128m64,   &i386_device::sse_cvttps2pi_r64_r128m64,false},
	{ 0x2d,     OP_2BYTE|OP_SSE,            &i386_device::sse_cvtps2pi_r64_r128m64,    &i386_device::sse_cvtps2pi_r64_r128m64,false},
	{ 0x2e,     OP_2BYTE|OP_SSE,            &i386_device::sse_ucomiss_r128_r128m32,    &i386_device::sse_ucomiss_r128_r128m32,false},
	{ 0x2f,     OP_2BYTE|OP_SSE,            &i386_device::sse_comiss_r128_r128m32,     &i386_device::sse_comiss_r128_r128m32, false},
	{ 0x30,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_wrmsr,               &i386_device::pentium_wrmsr,           false},
	{ 0x31,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_rdtsc,               &i386_device::pentium_rdtsc,           false},
	{ 0x32,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_rdmsr,               &i386_device::pentium_rdmsr,           false},
	{ 0x40,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovo_r16_rm16,      &i386_device::pentium_cmovo_r32_rm32,  false},
	{ 0x41,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovno_r16_rm16,     &i386_device::pentium_cmovno_r32_rm32, false},
	{ 0x42,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovb_r16_rm16,      &i386_device::pentium_cmovb_r32_rm32,  false},
	{ 0x43,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovae_r16_rm16,     &i386_device::pentium_cmovae_r32_rm32, false},
	{ 0x44,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmove_r16_rm16,      &i386_device::pentium_cmove_r32_rm32,  false},
	{ 0x45,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovne_r16_rm16,     &i386_device::pentium_cmovne_r32_rm32, false},
	{ 0x46,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovbe_r16_rm16,     &i386_device::pentium_cmovbe_r32_rm32, false},
	{ 0x47,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmova_r16_rm16,      &i386_device::pentium_cmova_r32_rm32,  false},
	{ 0x48,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovs_r16_rm16,      &i386_device::pentium_cmovs_r32_rm32,  false},
	{ 0x49,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovns_r16_rm16,     &i386_device::pentium_cmovns_r32_rm32, false},
	{ 0x4a,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovp_r16_rm16,      &i386_device::pentium_cmovp_r32_rm32,  false},
	{ 0x4b,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovnp_r16_rm16,     &i386_device::pentium_cmovnp_r32_rm32, false},
	{ 0x4c,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovl_r16_rm16,      &i386_device::pentium_cmovl_r32_rm32,  false},
	{ 0x4d,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovge_r16_rm16,     &i386_device::pentium_cmovge_r32_rm32, false},
	{ 0x4e,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovle_r16_rm16,     &i386_device::pentium_cmovle_r32_rm32, false},
	{ 0x4f,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmovg_r16_rm16,      &i386_device::pentium_cmovg_r32_rm32,  false},
	{ 0x50,     OP_2BYTE|OP_SSE,            &i386_device::sse_movmskps_r16_r128,       &i386_device::sse_movmskps_r32_r128,   false},
	{ 0x51,     OP_2BYTE|OP_SSE,            &i386_device::sse_sqrtps_r128_rm128,       &i386_device::sse_sqrtps_r128_rm128,   false},
	{ 0x52,     OP_2BYTE|OP_SSE,            &i386_device::sse_rsqrtps_r128_rm128,      &i386_device::sse_rsqrtps_r128_rm128,  false},
	{ 0x53,     OP_2BYTE|OP_SSE,            &i386_device::sse_rcpps_r128_rm128,        &i386_device::sse_rcpps_r128_rm128,    false},
	{ 0x54,     OP_2BYTE|OP_SSE,            &i386_device::sse_andps_r128_rm128,        &i386_device::sse_andps_r128_rm128,    false},
	{ 0x55,     OP_2BYTE|OP_SSE,            &i386_device::sse_andnps_r128_rm128,       &i386_device::sse_andnps_r128_rm128,   false},
	{ 0x56,     OP_2BYTE|OP_SSE,            &i386_device::sse_orps_r128_rm128,         &i386_device::sse_orps_r128_rm128,     false},
	{ 0x57,     OP_2BYTE|OP_SSE,            &i386_device::sse_xorps,                   &i386_device::sse_xorps,               false},
	{ 0x58,     OP_2BYTE|OP_SSE,            &i386_device::sse_addps,                   &i386_device::sse_addps,               false},
	{ 0x59,     OP_2BYTE|OP_SSE,            &i386_device::sse_mulps,                   &i386_device::sse_mulps,               false},
	{ 0x5a,     OP_2BYTE|OP_SSE,            &i386_device::sse_cvtps2pd_r128_r128m64,   &i386_device::sse_cvtps2pd_r128_r128m64,false},
	{ 0x5b,     OP_2BYTE|OP_SSE,            &i386_device::sse_cvtdq2ps_r128_rm128,     &i386_device::sse_cvtdq2ps_r128_rm128, false},
	{ 0x5c,     OP_2BYTE|OP_SSE,            &i386_device::sse_subps,                   &i386_device::sse_subps,               false},
	{ 0x5d,     OP_2BYTE|OP_SSE,            &i386_device::sse_minps,                   &i386_device::sse_minps,               false},
	{ 0x5e,     OP_2BYTE|OP_SSE,            &i386_device::sse_divps,                   &i386_device::sse_divps,               false},
	{ 0x5f,     OP_2BYTE|OP_SSE,            &i386_device::sse_maxps,                   &i386_device::sse_maxps,               false},
	{ 0x60,     OP_2BYTE|OP_MMX,            &i386_device::mmx_punpcklbw_r64_r64m32,    &i386_device::mmx_punpcklbw_r64_r64m32,false},
	{ 0x61,     OP_2BYTE|OP_MMX,            &i386_device::mmx_punpcklwd_r64_r64m32,    &i386_device::mmx_punpcklwd_r64_r64m32,false},
	{ 0x62,     OP_2BYTE|OP_MMX,            &i386_device::mmx_punpckldq_r64_r64m32,    &i386_device::mmx_punpckldq_r64_r64m32,false},
	{ 0x63,     OP_2BYTE|OP_MMX,            &i386_device::mmx_packsswb_r64_rm64,       &i386_device::mmx_packsswb_r64_rm64,   false},
	{ 0x64,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pcmpgtb_r64_rm64,        &i386_device::mmx_pcmpgtb_r64_rm64,    false},
	{ 0x65,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pcmpgtw_r64_rm64,        &i386_device::mmx_pcmpgtw_r64_rm64,    false},
	{ 0x66,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pcmpgtd_r64_rm64,        &i386_device::mmx_pcmpgtd_r64_rm64,    false},
	{ 0x67,     OP_2BYTE|OP_MMX,            &i386_device::mmx_packuswb_r64_rm64,       &i386_device::mmx_packuswb_r64_rm64,   false},
	{ 0x68,     OP_2BYTE|OP_MMX,            &i386_device::mmx_punpckhbw_r64_rm64,      &i386_device::mmx_punpckhbw_r64_rm64,  false},
	{ 0x69,     OP_2BYTE|OP_MMX,            &i386_device::mmx_punpckhwd_r64_rm64,      &i386_device::mmx_punpckhwd_r64_rm64,  false},
	{ 0x6a,     OP_2BYTE|OP_MMX,            &i386_device::mmx_punpckhdq_r64_rm64,      &i386_device::mmx_punpckhdq_r64_rm64,  false},
	{ 0x6b,     OP_2BYTE|OP_MMX,            &i386_device::mmx_packssdw_r64_rm64,       &i386_device::mmx_packssdw_r64_rm64,   false},
	{ 0x6e,     OP_2BYTE|OP_MMX,            &i386_device::mmx_movd_r64_rm32,           &i386_device::mmx_movd_r64_rm32,       false},
	{ 0x6f,     OP_2BYTE|OP_MMX,            &i386_device::mmx_movq_r64_rm64,           &i386_device::mmx_movq_r64_rm64,       false},
	{ 0x70,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pshufw_r64_rm64_i8,      &i386_device::mmx_pshufw_r64_rm64_i8,  false},
	{ 0x71,     OP_2BYTE|OP_MMX,            &i386_device::mmx_group_0f71,              &i386_device::mmx_group_0f71,          false},
	{ 0x72,     OP_2BYTE|OP_MMX,            &i386_device::mmx_group_0f72,              &i386_device::mmx_group_0f72,          false},
	{ 0x73,     OP_2BYTE|OP_MMX,            &i386_device::mmx_group_0f73,              &i386_device::mmx_group_0f73,          false},
	{ 0x74,     OP_2BYTE|OP_CYRIX,          &i386_device::i386_cyrix_unknown,          &i386_device::i386_cyrix_unknown,      false},
	{ 0x74,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pcmpeqb_r64_rm64,        &i386_device::mmx_pcmpeqb_r64_rm64,    false},
	{ 0x75,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pcmpeqw_r64_rm64,        &i386_device::mmx_pcmpeqw_r64_rm64,    false},
	{ 0x76,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pcmpeqd_r64_rm64,        &i386_device::mmx_pcmpeqd_r64_rm64,    false},
	{ 0x77,     OP_2BYTE|OP_MMX,            &i386_device::mmx_emms,                    &i386_device::mmx_emms,                false},
	{ 0x7e,     OP_2BYTE|OP_MMX,            &i386_device::mmx_movd_rm32_r64,           &i386_device::mmx_movd_rm32_r64,       false},
	{ 0x7f,     OP_2BYTE|OP_MMX,            &i386_device::mmx_movq_rm64_r64,           &i386_device::mmx_movq_rm64_r64,       false},
	{ 0x80,     OP_2BYTE|OP_I386,           &i386_device::i386_jo_rel16,               &i386_device::i386_jo_rel32,           false},
	{ 0x81,     OP_2BYTE|OP_I386,           &i386_device::i386_jno_rel16,              &i386_device::i386_jno_rel32,          false},
	{ 0x82,     OP_2BYTE|OP_I386,           &i386_device::i386_jc_rel16,               &i386_device::i386_jc_rel32,           false},
	{ 0x83,     OP_2BYTE|OP_I386,           &i386_device::i386_jnc_rel16,              &i386_device::i386_jnc_rel32,          false},
	{ 0x84,     OP_2BYTE|OP_I386,           &i386_device::i386_jz_rel16,               &i386_device::i386_jz_rel32,           false},
	{ 0x85,     OP_2BYTE|OP_I386,           &i386_device::i386_jnz_rel16,              &i386_device::i386_jnz_rel32,          false},
	{ 0x86,     OP_2BYTE|OP_I386,           &i386_device::i386_jbe_rel16,              &i386_device::i386_jbe_rel32,          false},
	{ 0x87,     OP_2BYTE|OP_I386,           &i386_device::i386_ja_rel16,               &i386_device::i386_ja_rel32,           false},
	{ 0x88,     OP_2BYTE|OP_I386,           &i386_device::i386_js_rel16,               &i386_device::i386_js_rel32,           false},
	{ 0x89,     OP_2BYTE|OP_I386,           &i386_device::i386_jns_rel16,              &i386_device::i386_jns_rel32,          false},
	{ 0x8A,     OP_2BYTE|OP_I386,           &i386_device::i386_jp_rel16,               &i386_device::i386_jp_rel32,           false},
	{ 0x8B,     OP_2BYTE|OP_I386,           &i386_device::i386_jnp_rel16,              &i386_device::i386_jnp_rel32,          false},
	{ 0x8C,     OP_2BYTE|OP_I386,           &i386_device::i386_jl_rel16,               &i386_device::i386_jl_rel32,           false},
	{ 0x8D,     OP_2BYTE|OP_I386,           &i386_device::i386_jge_rel16,              &i386_device::i386_jge_rel32,          false},
	{ 0x8E,     OP_2BYTE|OP_I386,           &i386_device::i386_jle_rel16,              &i386_device::i386_jle_rel32,          false},
	{ 0x8F,     OP_2BYTE|OP_I386,           &i386_device::i386_jg_rel16,               &i386_device::i386_jg_rel32,           false},
	{ 0x90,     OP_2BYTE|OP_I386,           &i386_device::i386_seto_rm8,               &i386_device::i386_seto_rm8,           false},
	{ 0x91,     OP_2BYTE|OP_I386,           &i386_device::i386_setno_rm8,              &i386_device::i386_setno_rm8,          false},
	{ 0x92,     OP_2BYTE|OP_I386,           &i386_device::i386_setc_rm8,               &i386_device::i386_setc_rm8,           false},
	{ 0x93,     OP_2BYTE|OP_I386,           &i386_device::i386_setnc_rm8,              &i386_device::i386_setnc_rm8,          false},
	{ 0x94,     OP_2BYTE|OP_I386,           &i386_device::i386_setz_rm8,               &i386_device::i386_setz_rm8,           false},
	{ 0x95,     OP_2BYTE|OP_I386,           &i386_device::i386_setnz_rm8,              &i386_device::i386_setnz_rm8,          false},
	{ 0x96,     OP_2BYTE|OP_I386,           &i386_device::i386_setbe_rm8,              &i386_device::i386_setbe_rm8,          false},
	{ 0x97,     OP_2BYTE|OP_I386,           &i386_device::i386_seta_rm8,               &i386_device::i386_seta_rm8,           false},
	{ 0x98,     OP_2BYTE|OP_I386,           &i386_device::i386_sets_rm8,               &i386_device::i386_sets_rm8,           false},
	{ 0x99,     OP_2BYTE|OP_I386,           &i386_device::i386_setns_rm8,              &i386_device::i386_setns_rm8,          false},
	{ 0x9A,     OP_2BYTE|OP_I386,           &i386_device::i386_setp_rm8,               &i386_device::i386_setp_rm8,           false},
	{ 0x9B,     OP_2BYTE|OP_I386,           &i386_device::i386_setnp_rm8,              &i386_device::i386_setnp_rm8,          false},
	{ 0x9C,     OP_2BYTE|OP_I386,           &i386_device::i386_setl_rm8,               &i386_device::i386_setl_rm8,           false},
	{ 0x9D,     OP_2BYTE|OP_I386,           &i386_device::i386_setge_rm8,              &i386_device::i386_setge_rm8,          false},
	{ 0x9E,     OP_2BYTE|OP_I386,           &i386_device::i386_setle_rm8,              &i386_device::i386_setle_rm8,          false},
	{ 0x9F,     OP_2BYTE|OP_I386,           &i386_device::i386_setg_rm8,               &i386_device::i386_setg_rm8,           false},
	{ 0xA0,     OP_2BYTE|OP_I386,           &i386_device::i386_push_fs16,              &i386_device::i386_push_fs32,          false},
	{ 0xA1,     OP_2BYTE|OP_I386,           &i386_device::i386_pop_fs16,               &i386_device::i386_pop_fs32,           false},
	{ 0xA2,     OP_2BYTE|OP_I486,           &i386_device::i486_cpuid,                  &i386_device::i486_cpuid,              false},
	{ 0xA3,     OP_2BYTE|OP_I386,           &i386_device::i386_bt_rm16_r16,            &i386_device::i386_bt_rm32_r32,        false},
	{ 0xA4,     OP_2BYTE|OP_I386,           &i386_device::i386_shld16_i8,              &i386_device::i386_shld32_i8,          false},
	{ 0xA5,     OP_2BYTE|OP_I386,           &i386_device::i386_shld16_cl,              &i386_device::i386_shld32_cl,          false},
	{ 0xA8,     OP_2BYTE|OP_I386,           &i386_device::i386_push_gs16,              &i386_device::i386_push_gs32,          false},
	{ 0xA9,     OP_2BYTE|OP_I386,           &i386_device::i386_pop_gs16,               &i386_device::i386_pop_gs32,           false},
	{ 0xAA,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_rsm,                 &i386_device::pentium_rsm,             false},
	{ 0xAB,     OP_2BYTE|OP_I386,           &i386_device::i386_bts_rm16_r16,           &i386_device::i386_bts_rm32_r32,       true },
	{ 0xAC,     OP_2BYTE|OP_I386,           &i386_device::i386_shrd16_i8,              &i386_device::i386_shrd32_i8,          false},
	{ 0xAD,     OP_2BYTE|OP_I386,           &i386_device::i386_shrd16_cl,              &i386_device::i386_shrd32_cl,          false},
	{ 0xAE,     OP_2BYTE|OP_SSE,            &i386_device::sse_sse_group0fae,           &i386_device::sse_sse_group0fae,       false},
	{ 0xAF,     OP_2BYTE|OP_I386,           &i386_device::i386_imul_r16_rm16,          &i386_device::i386_imul_r32_rm32,      false},
	{ 0xB0,     OP_2BYTE|OP_I486,           &i386_device::i486_cmpxchg_rm8_r8,         &i386_device::i486_cmpxchg_rm8_r8,     true },
	{ 0xB1,     OP_2BYTE|OP_I486,           &i386_device::i486_cmpxchg_rm16_r16,       &i386_device::i486_cmpxchg_rm32_r32,   true },
	{ 0xB2,     OP_2BYTE|OP_I386,           &i386_device::i386_lss16,                  &i386_device::i386_lss32,              false},
	{ 0xB3,     OP_2BYTE|OP_I386,           &i386_device::i386_btr_rm16_r16,           &i386_device::i386_btr_rm32_r32,       true },
	{ 0xB4,     OP_2BYTE|OP_I386,           &i386_device::i386_lfs16,                  &i386_device::i386_lfs32,              false},
	{ 0xB5,     OP_2BYTE|OP_I386,           &i386_device::i386_lgs16,                  &i386_device::i386_lgs32,              false},
	{ 0xB6,     OP_2BYTE|OP_I386,           &i386_device::i386_movzx_r16_rm8,          &i386_device::i386_movzx_r32_rm8,      false},
	{ 0xB7,     OP_2BYTE|OP_I386,           &i386_device::i386_invalid,                &i386_device::i386_movzx_r32_rm16,     false},
	{ 0xBA,     OP_2BYTE|OP_I386,           &i386_device::i386_group0FBA_16,           &i386_device::i386_group0FBA_32,       true },
	{ 0xBB,     OP_2BYTE|OP_I386,           &i386_device::i386_btc_rm16_r16,           &i386_device::i386_btc_rm32_r32,       true },
	{ 0xBC,     OP_2BYTE|OP_I386,           &i386_device::i386_bsf_r16_rm16,           &i386_device::i386_bsf_r32_rm32,       false},
	{ 0xBD,     OP_2BYTE|OP_I386,           &i386_device::i386_bsr_r16_rm16,           &i386_device::i386_bsr_r32_rm32,       false},
	{ 0xBE,     OP_2BYTE|OP_I386,           &i386_device::i386_movsx_r16_rm8,          &i386_device::i386_movsx_r32_rm8,      false},
	{ 0xBF,     OP_2BYTE|OP_I386,           &i386_device::i386_invalid,                &i386_device::i386_movsx_r32_rm16,     false},
	{ 0xC0,     OP_2BYTE|OP_I486,           &i386_device::i486_xadd_rm8_r8,            &i386_device::i486_xadd_rm8_r8,        true },
	{ 0xC1,     OP_2BYTE|OP_I486,           &i386_device::i486_xadd_rm16_r16,          &i386_device::i486_xadd_rm32_r32,      true },
	{ 0xC2,     OP_2BYTE|OP_SSE,            &i386_device::sse_cmpps_r128_rm128_i8,     &i386_device::sse_cmpps_r128_rm128_i8, false},
	{ 0xC3,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_movnti_m16_r16,      &i386_device::pentium_movnti_m32_r32,  false},
	{ 0xC4,     OP_2BYTE|OP_SSE,            &i386_device::sse_pinsrw_r64_r16m16_i8,    &i386_device::sse_pinsrw_r64_r32m16_i8,false},
	{ 0xC5,     OP_2BYTE|OP_SSE,            &i386_device::sse_pextrw_r16_r64_i8,       &i386_device::sse_pextrw_r32_r64_i8,   false},
	{ 0xC6,     OP_2BYTE|OP_SSE,            &i386_device::sse_shufps,                  &i386_device::sse_shufps,              false},
	{ 0xC7,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_cmpxchg8b_m64,       &i386_device::pentium_cmpxchg8b_m64,   true },
	{ 0xC8,     OP_2BYTE|OP_I486,           &i386_device::i486_bswap_eax,              &i386_device::i486_bswap_eax,          false},
	{ 0xC9,     OP_2BYTE|OP_I486,           &i386_device::i486_bswap_ecx,              &i386_device::i486_bswap_ecx,          false},
	{ 0xCA,     OP_2BYTE|OP_I486,           &i386_device::i486_bswap_edx,              &i386_device::i486_bswap_edx,          false},
	{ 0xCB,     OP_2BYTE|OP_I486,           &i386_device::i486_bswap_ebx,              &i386_device::i486_bswap_ebx,          false},
	{ 0xCC,     OP_2BYTE|OP_I486,           &i386_device::i486_bswap_esp,              &i386_device::i486_bswap_esp,          false},
	{ 0xCD,     OP_2BYTE|OP_I486,           &i386_device::i486_bswap_ebp,              &i386_device::i486_bswap_ebp,          false},
	{ 0xCE,     OP_2BYTE|OP_I486,           &i386_device::i486_bswap_esi,              &i386_device::i486_bswap_esi,          false},
	{ 0xCF,     OP_2BYTE|OP_I486,           &i386_device::i486_bswap_edi,              &i386_device::i486_bswap_edi,          false},
	{ 0xD1,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psrlw_r64_rm64,          &i386_device::mmx_psrlw_r64_rm64,      false},
	{ 0xD2,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psrld_r64_rm64,          &i386_device::mmx_psrld_r64_rm64,      false},
	{ 0xD3,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psrlq_r64_rm64,          &i386_device::mmx_psrlq_r64_rm64,      false},
	{ 0xD4,     OP_2BYTE|OP_MMX,            &i386_device::mmx_paddq_r64_rm64,          &i386_device::mmx_paddq_r64_rm64,      false},
	{ 0xD5,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pmullw_r64_rm64,         &i386_device::mmx_pmullw_r64_rm64,     false},
	{ 0xD7,     OP_2BYTE|OP_SSE,            &i386_device::sse_pmovmskb_r16_r64,        &i386_device::sse_pmovmskb_r32_r64,    false},
	{ 0xD8,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psubusb_r64_rm64,        &i386_device::mmx_psubusb_r64_rm64,    false},
	{ 0xD9,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psubusw_r64_rm64,        &i386_device::mmx_psubusw_r64_rm64,    false},
	{ 0xDA,     OP_2BYTE|OP_SSE,            &i386_device::sse_pminub_r64_rm64,         &i386_device::sse_pminub_r64_rm64,     false},
	{ 0xDB,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pand_r64_rm64,           &i386_device::mmx_pand_r64_rm64,       false},
	{ 0xDC,     OP_2BYTE|OP_MMX,            &i386_device::mmx_paddusb_r64_rm64,        &i386_device::mmx_paddusb_r64_rm64,    false},
	{ 0xDD,     OP_2BYTE|OP_MMX,            &i386_device::mmx_paddusw_r64_rm64,        &i386_device::mmx_paddusw_r64_rm64,    false},
	{ 0xDE,     OP_2BYTE|OP_SSE,            &i386_device::sse_pmaxub_r64_rm64,         &i386_device::sse_pmaxub_r64_rm64,     false},
	{ 0xDF,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pandn_r64_rm64,          &i386_device::mmx_pandn_r64_rm64,      false},
	{ 0xE0,     OP_2BYTE|OP_SSE,            &i386_device::sse_pavgb_r64_rm64,          &i386_device::sse_pavgb_r64_rm64,      false},
	{ 0xE1,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psraw_r64_rm64,          &i386_device::mmx_psraw_r64_rm64,      false},
	{ 0xE2,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psrad_r64_rm64,          &i386_device::mmx_psrad_r64_rm64,      false},
	{ 0xE3,     OP_2BYTE|OP_SSE,            &i386_device::sse_pavgw_r64_rm64,          &i386_device::sse_pavgw_r64_rm64,      false},
	{ 0xE4,     OP_2BYTE|OP_SSE,            &i386_device::sse_pmulhuw_r64_rm64,        &i386_device::sse_pmulhuw_r64_rm64,    false},
	{ 0xE5,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pmulhw_r64_rm64,         &i386_device::mmx_pmulhw_r64_rm64,     false},
	{ 0xE7,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_movntq_m64_r64,      &i386_device::pentium_movntq_m64_r64,  false},
	{ 0xE8,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psubsb_r64_rm64,         &i386_device::mmx_psubsb_r64_rm64,     false},
	{ 0xE9,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psubsw_r64_rm64,         &i386_device::mmx_psubsw_r64_rm64,     false},
	{ 0xEA,     OP_2BYTE|OP_SSE,            &i386_device::sse_pminsw_r64_rm64,         &i386_device::sse_pminsw_r64_rm64,     false},
	{ 0xEB,     OP_2BYTE|OP_MMX,            &i386_device::mmx_por_r64_rm64,            &i386_device::mmx_por_r64_rm64,        false},
	{ 0xEC,     OP_2BYTE|OP_MMX,            &i386_device::mmx_paddsb_r64_rm64,         &i386_device::mmx_paddsb_r64_rm64,     false},
	{ 0xED,     OP_2BYTE|OP_MMX,            &i386_device::mmx_paddsw_r64_rm64,         &i386_device::mmx_paddsw_r64_rm64,     false},
	{ 0xEE,     OP_2BYTE|OP_SSE,            &i386_device::sse_pmaxsw_r64_rm64,         &i386_device::sse_pmaxsw_r64_rm64,     false},
	{ 0xEF,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pxor_r64_rm64,           &i386_device::mmx_pxor_r64_rm64,       false},
	{ 0xF1,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psllw_r64_rm64,          &i386_device::mmx_psllw_r64_rm64,      false},
	{ 0xF2,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pslld_r64_rm64,          &i386_device::mmx_pslld_r64_rm64,      false},
	{ 0xF3,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psllq_r64_rm64,          &i386_device::mmx_psllq_r64_rm64,      false},
	{ 0xF4,     OP_2BYTE|OP_SSE,            &i386_device::sse_pmuludq_r64_rm64,        &i386_device::sse_pmuludq_r64_rm64,    false},
	{ 0xF5,     OP_2BYTE|OP_MMX,            &i386_device::mmx_pmaddwd_r64_rm64,        &i386_device::mmx_pmaddwd_r64_rm64,    false},
	{ 0xF6,     OP_2BYTE|OP_SSE,            &i386_device::sse_psadbw_r64_rm64,         &i386_device::sse_psadbw_r64_rm64,     false},
	{ 0xf7,     OP_2BYTE|OP_PENTIUM,        &i386_device::pentium_maskmovq_r64_r64,    &i386_device::pentium_maskmovq_r64_r64,false},
	{ 0xF8,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psubb_r64_rm64,          &i386_device::mmx_psubb_r64_rm64,      false},
	{ 0xF9,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psubw_r64_rm64,          &i386_device::mmx_psubw_r64_rm64,      false},
	{ 0xFA,     OP_2BYTE|OP_MMX,            &i386_device::mmx_psubd_r64_rm64,          &i386_device::mmx_psubd_r64_rm64,      false},
	{ 0xFB,     OP_2BYTE|OP_SSE,            &i386_device::sse_psubq_r64_rm64,          &i386_device::sse_psubq_r64_rm64,      false},
	{ 0xFC,     OP_2BYTE|OP_MMX,            &i386_device::mmx_paddb_r64_rm64,          &i386_device::mmx_paddb_r64_rm64,      false},
	{ 0xFD,     OP_2BYTE|OP_MMX,            &i386_device::mmx_paddw_r64_rm64,          &i386_device::mmx_paddw_r64_rm64,      false},
	{ 0xFE,     OP_2BYTE|OP_MMX,            &i386_device::mmx_paddd_r64_rm64,          &i386_device::mmx_paddd_r64_rm64,      false},
	/* F3 0F ?? */
	{ 0x10,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_movss_r128_rm128,        &i386_device::sse_movss_r128_rm128,    false},
	{ 0x11,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_movss_rm128_r128,        &i386_device::sse_movss_rm128_r128,    false},
	{ 0x12,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_movsldup_r128_rm128,     &i386_device::sse_movsldup_r128_rm128, false},
	{ 0x16,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_movshdup_r128_rm128,     &i386_device::sse_movshdup_r128_rm128, false},
	{ 0x2A,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_cvtsi2ss_r128_rm32,      &i386_device::sse_cvtsi2ss_r128_rm32,  false},
	{ 0x2C,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_cvttss2si_r32_r128m32,   &i386_device::sse_cvttss2si_r32_r128m32,false},
	{ 0x2D,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_cvtss2si_r32_r128m32,    &i386_device::sse_cvtss2si_r32_r128m32,false},
	{ 0x51,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_sqrtss_r128_r128m32,     &i386_device::sse_sqrtss_r128_r128m32, false},
	{ 0x52,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_rsqrtss_r128_r128m32,    &i386_device::sse_rsqrtss_r128_r128m32,false},
	{ 0x53,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_rcpss_r128_r128m32,      &i386_device::sse_rcpss_r128_r128m32,  false},
	{ 0x58,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_addss,                   &i386_device::sse_addss,               false},
	{ 0x59,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_mulss,                   &i386_device::sse_mulss,               false},
	{ 0x5A,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_cvtss2sd_r128_r128m32,   &i386_device::sse_cvtss2sd_r128_r128m32,false},
	{ 0x5B,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_cvttps2dq_r128_rm128,    &i386_device::sse_cvttps2dq_r128_rm128,false},
	{ 0x5C,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_subss,                   &i386_device::sse_subss,               false},
	{ 0x5D,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_minss_r128_r128m32,      &i386_device::sse_minss_r128_r128m32,  false},
	{ 0x5E,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_divss,                   &i386_device::sse_divss,               false},
	{ 0x5F,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_maxss_r128_r128m32,      &i386_device::sse_maxss_r128_r128m32,  false},
	{ 0x6F,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_movdqu_r128_rm128,       &i386_device::sse_movdqu_r128_rm128,   false},
	{ 0x70,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_pshufhw_r128_rm128_i8,   &i386_device::sse_pshufhw_r128_rm128_i8,false},
	{ 0x7E,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_movq_r128_r128m64,       &i386_device::sse_movq_r128_r128m64,   false},
	{ 0x7F,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_movdqu_rm128_r128,       &i386_device::sse_movdqu_rm128_r128,   false},
	{ 0xB8,     OP_3BYTEF3|OP_PENTIUM,      &i386_device::pentium_popcnt_r16_rm16,     &i386_device::pentium_popcnt_r32_rm32, false},
	{ 0xBC,     OP_3BYTEF3|OP_PENTIUM,      &i386_device::pentium_tzcnt_r16_rm16,      &i386_device::pentium_tzcnt_r32_rm32, false},
	{ 0xC2,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_cmpss_r128_r128m32_i8,   &i386_device::sse_cmpss_r128_r128m32_i8,false},
	{ 0xD6,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_movq2dq_r128_r64,        &i386_device::sse_movq2dq_r128_r64,    false},
	{ 0xE6,     OP_3BYTEF3|OP_SSE,          &i386_device::sse_cvtdq2pd_r128_r128m64,   &i386_device::sse_cvtdq2pd_r128_r128m64,false}
};
