/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ViewSwitcher;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.dynamic.c;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.ag;
import com.google.android.gms.internal.aq;
import com.google.android.gms.internal.au;
import com.google.android.gms.internal.aw;
import com.google.android.gms.internal.bf;
import com.google.android.gms.internal.bh;
import com.google.android.gms.internal.bi;
import com.google.android.gms.internal.bl;
import com.google.android.gms.internal.bp;
import com.google.android.gms.internal.bu;
import com.google.android.gms.internal.ce;
import com.google.android.gms.internal.cf;
import com.google.android.gms.internal.cg;
import com.google.android.gms.internal.ci;
import com.google.android.gms.internal.cm;
import com.google.android.gms.internal.cn;
import com.google.android.gms.internal.co;
import com.google.android.gms.internal.cq;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.g;
import com.google.android.gms.internal.h;
import com.google.android.gms.internal.q;
import com.google.android.gms.internal.s;
import com.google.android.gms.internal.v;
import com.google.android.gms.internal.x;

public final class r
extends ac.a
implements ag,
aq,
bi,
bl,
bp.a,
q {
    private final aw dZ;
    private final a ea;
    private final s eb;

    public r(Context context, x x2, String string2, aw aw2, co co2) {
        this.ea = new a(context, x2, string2, co2);
        this.dZ = aw2;
        this.eb = new s(this);
        cn.o("Use AdRequest.Builder.addTestDevice(\"" + cm.l(context) + "\") to get test ads on this device.");
        ci.i(context);
    }

    public void destroy() {
        dm.w("destroy must be called on the main UI thread.");
        this.ea.eh = null;
        this.ea.ek = null;
        this.eb.cancel();
        this.stopLoading();
        if (this.ea.ec != null) {
            this.ea.ec.removeAllViews();
        }
        if (this.ea.ej != null && this.ea.ej.fU != null) {
            this.ea.ej.fU.destroy();
        }
    }

    public b z() {
        dm.w("getAdFrame must be called on the main UI thread.");
        return c.g(this.ea.ec);
    }

    public boolean isReady() {
        dm.w("isReady must be called on the main UI thread.");
        return this.ea.ei == null && this.ea.ej != null;
    }

    public boolean a(v v2) {
        cq cq2;
        dm.w("loadAd must be called on the main UI thread.");
        if (this.ea.ei != null) {
            cn.q("An ad request is already in progress. Aborting.");
            return false;
        }
        if (this.ea.ed.ex && this.ea.ej != null) {
            cn.q("An interstitial is already loading. Aborting.");
            return false;
        }
        if (!this.M()) {
            return false;
        }
        cn.o("Starting ad request.");
        this.eb.cancel();
        bu.a a2 = this.c(v2);
        if (this.ea.ed.ex) {
            cq2 = cq.a(this.ea.ee, this.ea.ed, false, false, this.ea.ef, this.ea.eg);
            cq2.aw().a(this, null, this, this, true);
        } else {
            View view = this.ea.ec.getNextView();
            if (view instanceof cq) {
                cq2 = (cq)view;
                cq2.a(this.ea.ee, this.ea.ed);
            } else {
                if (view != null) {
                    this.ea.ec.removeView(view);
                }
                cq2 = cq.a(this.ea.ee, this.ea.ed, false, false, this.ea.ef, this.ea.eg);
                this.b((View)cq2);
            }
            cq2.aw().a(this, this, this, this, false);
        }
        this.ea.ei = bp.a(this.ea.ee, a2, this.ea.ef, cq2, this.dZ, this);
        return true;
    }

    public void a(ce ce2) {
        boolean bl2;
        this.ea.ei = null;
        if (ce2.errorCode == -1) {
            return;
        }
        boolean bl3 = bl2 = ce2.gB.extras != null ? ce2.gB.extras.getBoolean("_noRefresh", false) : false;
        if (this.ea.ed.ex) {
            ci.a(ce2.fU);
        } else if (!bl2) {
            if (ce2.fa > 0L) {
                this.eb.a(ce2.gB, ce2.fa);
            } else if (ce2.hA != null && ce2.hA.fa > 0L) {
                this.eb.a(ce2.gB, ce2.hA.fa);
            } else if (!ce2.gI && ce2.errorCode == 2) {
                this.eb.d(ce2.gB);
            }
        }
        if (ce2.errorCode == 3 && ce2.hA != null && ce2.hA.eY != null) {
            cn.m("Pinging no fill URLs.");
            au.a(this.ea.ee, this.ea.eg.hP, ce2, this.ea.adUnitId, false, ce2.hA.eY);
        }
        if (ce2.errorCode != -2) {
            this.a(ce2.errorCode);
            return;
        }
        if (!this.ea.ed.ex && !this.b(ce2)) {
            this.a(0);
            return;
        }
        if (this.ea.ej != null && this.ea.ej.fp != null) {
            this.ea.ej.fp.a((aq)null);
        }
        if (ce2.fp != null) {
            ce2.fp.a(this);
        }
        this.ea.ej = ce2;
        if (!this.ea.ed.ex) {
            this.b(false);
        }
        this.L();
    }

    public void y() {
        this.N();
    }

    public void A() {
        this.J();
    }

    public void B() {
        if (this.ea.ed.ex) {
            this.O();
        }
        this.I();
    }

    public void C() {
        if (this.ea.ed.ex) {
            this.b(false);
        }
        this.K();
    }

    public void a(String string2, String string3) {
        if (this.ea.ek != null) {
            try {
                this.ea.ek.a(string2, string3);
            }
            catch (RemoteException remoteException) {
                cn.b("Could not call the AppEventListener.", remoteException);
            }
        }
    }

    public void D() {
        this.y();
    }

    public void E() {
        this.B();
    }

    public void F() {
        this.A();
    }

    public void G() {
        this.C();
    }

    public void H() {
        if (this.ea.ej != null) {
            cn.q("Mediation adapter " + this.ea.ej.fo + " refreshed, but mediation adapters should never refresh.");
        }
        this.b(true);
        this.L();
    }

    public void pause() {
        dm.w("pause must be called on the main UI thread.");
        if (this.ea.ej != null) {
            ci.a(this.ea.ej.fU);
        }
    }

    public void resume() {
        dm.w("resume must be called on the main UI thread.");
        if (this.ea.ej != null) {
            ci.b(this.ea.ej.fU);
        }
    }

    public void b(v v2) {
        ViewParent viewParent = this.ea.ec.getParent();
        if (viewParent instanceof View && ((View)viewParent).isShown() && ci.am()) {
            this.a(v2);
        } else {
            cn.o("Ad is not visible. Not refreshing ad.");
            this.eb.d(v2);
        }
    }

    public void a(ab ab2) {
        dm.w("setAdListener must be called on the main UI thread.");
        this.ea.eh = ab2;
    }

    public void a(ae ae2) {
        dm.w("setAppEventListener must be called on the main UI thread.");
        this.ea.ek = ae2;
    }

    public void showInterstitial() {
        dm.w("showInterstitial must be called on the main UI thread.");
        if (!this.ea.ed.ex) {
            cn.q("Cannot call showInterstitial on a banner ad.");
            return;
        }
        if (this.ea.ej == null) {
            cn.q("The interstitial has not loaded.");
            return;
        }
        if (this.ea.ej.fU.az()) {
            cn.q("The interstitial is already showing.");
            return;
        }
        this.ea.ej.fU.i(true);
        if (this.ea.ej.gI) {
            try {
                this.ea.ej.fn.showInterstitial();
            }
            catch (RemoteException remoteException) {
                cn.b("Could not show interstitial.", remoteException);
                this.O();
            }
        } else {
            bh bh2 = new bh(this, this, this, this.ea.ej.fU, this.ea.ej.orientation, this.ea.eg);
            bf.a(this.ea.ee, bh2);
        }
    }

    public void stopLoading() {
        dm.w("stopLoading must be called on the main UI thread.");
        if (this.ea.ej != null) {
            this.ea.ej.fU.stopLoading();
            this.ea.ej = null;
        }
        if (this.ea.ei != null) {
            this.ea.ei.cancel();
        }
    }

    private void b(View view) {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        this.ea.ec.addView(view, layoutParams);
    }

    private void I() {
        cn.o("Ad closing.");
        if (this.ea.eh != null) {
            try {
                this.ea.eh.onAdClosed();
            }
            catch (RemoteException remoteException) {
                cn.b("Could not call AdListener.onAdClosed().", remoteException);
            }
        }
    }

    private void a(int n2) {
        cn.q("Failed to load ad: " + n2);
        if (this.ea.eh != null) {
            try {
                this.ea.eh.onAdFailedToLoad(n2);
            }
            catch (RemoteException remoteException) {
                cn.b("Could not call AdListener.onAdFailedToLoad().", remoteException);
            }
        }
    }

    private void J() {
        cn.o("Ad leaving application.");
        if (this.ea.eh != null) {
            try {
                this.ea.eh.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                cn.b("Could not call AdListener.onAdLeftApplication().", remoteException);
            }
        }
    }

    private void K() {
        cn.o("Ad opening.");
        if (this.ea.eh != null) {
            try {
                this.ea.eh.onAdOpened();
            }
            catch (RemoteException remoteException) {
                cn.b("Could not call AdListener.onAdOpened().", remoteException);
            }
        }
    }

    private void L() {
        cn.o("Ad finished loading.");
        if (this.ea.eh != null) {
            try {
                this.ea.eh.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                cn.b("Could not call AdListener.onAdLoaded().", remoteException);
            }
        }
    }

    private boolean M() {
        boolean bl2 = true;
        if (!ci.a(this.ea.ee.getPackageManager(), this.ea.ee.getPackageName(), "android.permission.INTERNET")) {
            if (!this.ea.ed.ex) {
                cm.a((ViewGroup)this.ea.ec, this.ea.ed, "Missing internet permission in AndroidManifest.xml.");
            }
            bl2 = false;
        }
        if (!ci.h(this.ea.ee)) {
            if (!this.ea.ed.ex) {
                cm.a((ViewGroup)this.ea.ec, this.ea.ed, "Missing AdActivity with android:configChanges in AndroidManifest.xml.");
            }
            bl2 = false;
        }
        if (!bl2) {
            this.ea.ec.setVisibility(0);
        }
        return bl2;
    }

    private bu.a c(v v2) {
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.ea.ee.getApplicationInfo();
        try {
            packageManager = this.ea.ee.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = null;
        if (!this.ea.ed.ex && this.ea.ec.getParent() != null) {
            int[] nArray = new int[2];
            this.ea.ec.getLocationOnScreen(nArray);
            int n2 = nArray[0];
            int n3 = nArray[1];
            DisplayMetrics displayMetrics = this.ea.ee.getResources().getDisplayMetrics();
            int n4 = this.ea.ec.getWidth();
            int n5 = this.ea.ec.getHeight();
            int n6 = 0;
            if (this.ea.ec.isShown() && n2 + n4 > 0 && n3 + n5 > 0 && n2 <= displayMetrics.widthPixels && n3 <= displayMetrics.heightPixels) {
                n6 = 1;
            }
            packageManager = new Bundle(5);
            packageManager.putInt("x", n2);
            packageManager.putInt("y", n3);
            packageManager.putInt("width", n4);
            packageManager.putInt("height", n5);
            packageManager.putInt("visible", n6);
        }
        return new bu.a((Bundle)packageManager, v2, this.ea.ed, this.ea.adUnitId, applicationInfo, packageInfo, cf.al(), cf.hB, this.ea.eg);
    }

    private void N() {
        if (this.ea.ej == null) {
            cn.q("Ad state was null when trying to ping click URLs.");
            return;
        }
        cn.m("Pinging click URLs.");
        if (this.ea.ej.eW != null) {
            ci.a(this.ea.ee, this.ea.eg.hP, this.ea.ej.eW);
        }
        if (this.ea.ej.hA != null && this.ea.ej.hA.eW != null) {
            au.a(this.ea.ee, this.ea.eg.hP, this.ea.ej, this.ea.adUnitId, false, this.ea.ej.hA.eW);
        }
    }

    private void b(boolean bl2) {
        if (this.ea.ej == null) {
            cn.q("Ad state was null when trying to ping impression URLs.");
            return;
        }
        cn.m("Pinging Impression URLs.");
        if (this.ea.ej.eX != null) {
            ci.a(this.ea.ee, this.ea.eg.hP, this.ea.ej.eX);
        }
        if (this.ea.ej.hA != null && this.ea.ej.hA.eX != null) {
            au.a(this.ea.ee, this.ea.eg.hP, this.ea.ej, this.ea.adUnitId, bl2, this.ea.ej.hA.eX);
        }
        if (this.ea.ej.fm != null && this.ea.ej.fm.eT != null) {
            au.a(this.ea.ee, this.ea.eg.hP, this.ea.ej, this.ea.adUnitId, bl2, this.ea.ej.fm.eT);
        }
    }

    private void O() {
        if (this.ea.ej != null) {
            this.ea.ej.fU.destroy();
            this.ea.ej = null;
        }
    }

    private boolean b(ce ce2) {
        View view;
        if (ce2.gI) {
            try {
                view = (View)c.b(ce2.fn.getView());
            }
            catch (RemoteException remoteException) {
                cn.b("Could not get View from mediation adapter.", remoteException);
                return false;
            }
            View view2 = this.ea.ec.getNextView();
            if (view2 != null) {
                this.ea.ec.removeView(view2);
            }
            try {
                this.b(view);
            }
            catch (Throwable throwable) {
                cn.b("Could not add mediation view to view hierarchy.", throwable);
                return false;
            }
        }
        if (this.ea.ec.getChildCount() > 1) {
            this.ea.ec.showNext();
        }
        if (this.ea.ej != null) {
            view = this.ea.ec.getNextView();
            if (view instanceof cq) {
                ((cq)view).a(this.ea.ee, this.ea.ed);
            } else if (view != null) {
                this.ea.ec.removeView(view);
            }
            if (this.ea.ej.fn != null) {
                try {
                    this.ea.ej.fn.destroy();
                }
                catch (RemoteException remoteException) {
                    cn.q("Could not destroy previous mediation adapter.");
                }
            }
        }
        this.ea.ec.setVisibility(0);
        return true;
    }

    private static final class a {
        public final ViewSwitcher ec;
        public final x ed;
        public final String adUnitId;
        public final Context ee;
        public final h ef;
        public final co eg;
        public ab eh;
        public cg ei;
        public ce ej;
        public ae ek;

        public a(Context context, x x2, String string2, co co2) {
            if (x2.ex) {
                this.ec = null;
            } else {
                this.ec = new ViewSwitcher(context);
                this.ec.setMinimumWidth(x2.widthPixels);
                this.ec.setMinimumHeight(x2.heightPixels);
                this.ec.setVisibility(4);
            }
            this.ed = x2;
            this.adUnitId = string2;
            this.ee = context;
            this.ef = new h(g.a(co2.hP, context));
            this.eg = co2;
        }
    }
}

