/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractDebugActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate,
ISelectionListener,
INullSelectionListener {
    private IAction fAction;
    private IViewPart fViewPart;
    private IStructuredSelection fSelection;
    private boolean fInitialized = false;
    protected IWorkbenchWindow fWindow;

    public void dispose() {
        if (this.getWindow() != null) {
            this.getWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        window.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        final Iterator itr = selection.iterator();
        String pluginId = DebugUIPlugin.getUniqueIdentifier();
        final MultiStatus ms = new MultiStatus(pluginId, 5012, this.getStatusMessage(), null);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                while (itr.hasNext()) {
                    Object element = itr.next();
                    try {
                        AbstractDebugActionDelegate.this.doAction(element);
                    }
                    catch (DebugException e) {
                        ms.merge(e.getStatus());
                    }
                }
            }
        });
        if (!ms.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), this.getErrorDialogTitle(), this.getErrorDialogMessage(), (IStatus)ms);
            } else {
                DebugUIPlugin.log((IStatus)ms);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection s) {
        boolean wasInitialized = this.initialize(action, s);
        if (!wasInitialized && this.getView() != null) {
            this.update(action, s);
        }
    }

    protected void update(IAction action, ISelection s) {
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            action.setEnabled(this.getEnableStateForSelection(ss));
            this.setSelection(ss);
        } else {
            action.setEnabled(false);
            this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected abstract void doAction(Object var1) throws DebugException;

    protected String getErrorDialogTitle() {
        return null;
    }

    protected String getErrorDialogMessage() {
        return null;
    }

    protected String getStatusMessage() {
        return "";
    }

    public void init(IViewPart view) {
        this.fViewPart = view;
    }

    protected IViewPart getView() {
        return this.fViewPart;
    }

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            IWorkbenchPage page;
            IWorkbenchWindow window;
            this.setAction(action);
            if (this.getView() == null && (window = this.getWindow()) != null && window.getShell() != null && !window.getShell().isDisposed() && (page = window.getActivePage()) != null) {
                selection = page.getSelection("org.eclipse.debug.ui.DebugView");
            }
            this.update(action, selection);
            this.setInitialized(true);
            return true;
        }
        return false;
    }

    protected IStructuredSelection getSelection() {
        if (this.getView() != null) {
            ISelection s = this.getView().getViewSite().getSelectionProvider().getSelection();
            if (s instanceof IStructuredSelection) {
                return (IStructuredSelection)s;
            }
            return StructuredSelection.EMPTY;
        }
        return this.fSelection;
    }

    private void setSelection(IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.update(this.getAction(), selection);
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setView(IViewPart viewPart) {
        this.fViewPart = viewPart;
    }

    protected boolean isInitialized() {
        return this.fInitialized;
    }

    protected void setInitialized(boolean initialized) {
        this.fInitialized = initialized;
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return false;
        }
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            Object element = itr.next();
            if (this.isEnabledFor(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEnabledFor(Object element) {
        return true;
    }
}

