/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    private static final String ENTRY_TIMESTAMP_FORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private static final String ENTRY_TIMESTAMP_TIME_ZONE = "GMT";
    private static final Locale ENTRY_TIMESTAMP_LOCALE = Locale.US;
    private static final String MODTIME_TIMESTAMP_FORMAT = "dd MMM yyyy HH:mm:ss zz";
    private static final Locale MODTIME_TIMESTAMP_LOCALE = Locale.US;
    private static final String LOG_TIMESTAMP_FORMAT = "yyyy/MM/dd HH:mm:ss zzz";
    private static final Locale LOG_TIMESTAMP_LOCALE = Locale.US;
    private static final String HISTORY_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm zzzz";
    private static final Locale HISTORY_TIMESTAMP_LOCALE = Locale.US;

    public static Date convertFromLogTime(String modTime) {
        SimpleDateFormat format = new SimpleDateFormat(LOG_TIMESTAMP_FORMAT, LOG_TIMESTAMP_LOCALE);
        try {
            return format.parse(modTime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date convertFromModTime(String modTime) {
        SimpleDateFormat format = new SimpleDateFormat(MODTIME_TIMESTAMP_FORMAT, MODTIME_TIMESTAMP_LOCALE);
        try {
            return format.parse(modTime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date convertFromHistoryTime(String historyTime) {
        SimpleDateFormat format = new SimpleDateFormat(HISTORY_TIMESTAMP_FORMAT, HISTORY_TIMESTAMP_LOCALE);
        try {
            return format.parse(historyTime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String toEntryFormat(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(ENTRY_TIMESTAMP_FORMAT, ENTRY_TIMESTAMP_LOCALE);
        format.setTimeZone(TimeZone.getTimeZone(ENTRY_TIMESTAMP_TIME_ZONE));
        return format.format(date);
    }
}

