/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;

class RemovedHandler
extends ResponseHandler {
    RemovedHandler() {
    }

    public String getResponseID() {
        return "Removed";
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        String repositoryFile = session.readLine();
        String fileName = repositoryFile.substring(repositoryFile.lastIndexOf("/") + 1);
        ICVSFolder mParent = session.getLocalRoot().getFolder(localDir);
        ICVSFile mFile = mParent.getFile(fileName);
        if (!mFile.isManaged()) {
            throw new CVSException(Policy.bind("RemovedHandler.invalid", new Path(localDir).append(fileName).toString()));
        }
        if (mFile.isReadOnly()) {
            mFile.setReadOnly(false);
        }
        mFile.delete();
        mFile.unmanage(null);
    }
}

