/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class IndexAllProject
extends IndexRequest {
    IProject project;

    public IndexAllProject(IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.project = project;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexAllProject) {
            return this.project.equals(((IndexAllProject)o).project);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        boolean bl;
        if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        Index index = this.manager.getIndexForUpdate(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterRead();
            String[] paths = index.queryDocumentNames("");
            int max = paths == null ? 0 : paths.length;
            final SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
            String OK = "OK";
            String DELETED = "DELETED";
            for (int i = 0; i < max; ++i) {
                indexedFileNames.put(paths[i], "DELETED");
            }
            final long indexLastModified = max == 0 ? 0L : index.getIndexFile().lastModified();
            JavaProject javaProject = (JavaProject)JavaCore.create(this.project);
            IClasspathEntry[] entries = javaProject.getRawClasspath(false, false);
            IWorkspaceRoot root = this.project.getWorkspace().getRoot();
            int length = entries.length;
            for (int i = 0; i < length; ++i) {
                IResource sourceFolder;
                if (this.isCancelled) {
                    boolean bl2 = false;
                    return bl2;
                }
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() != 3 || (sourceFolder = root.findMember(entry.getPath())) == null) continue;
                final HashSet<IPath> outputs = new HashSet<IPath>();
                if (sourceFolder.getType() == 4) {
                    outputs.add(javaProject.getOutputLocation(false, false));
                    for (int j = 0; j < length; ++j) {
                        IPath output = entries[j].getOutputLocation();
                        if (output == null) continue;
                        outputs.add(output);
                    }
                }
                final boolean hasOutputs = !outputs.isEmpty();
                final char[][] inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
                final char[][] exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                if (max == 0) {
                    sourceFolder.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            if (IndexAllProject.this.isCancelled) {
                                return false;
                            }
                            switch (proxy.getType()) {
                                case 1: {
                                    if (Util.isJavaFileName(proxy.getName())) {
                                        IFile file = (IFile)proxy.requestResource();
                                        if (file.getLocation() == null) {
                                            return false;
                                        }
                                        if ((exclusionPatterns != null || inclusionPatterns != null) && org.eclipse.jdt.internal.core.util.Util.isExcluded((IResource)file, inclusionPatterns, exclusionPatterns)) {
                                            return false;
                                        }
                                        indexedFileNames.put(file.getFullPath().toString(), file);
                                    }
                                    return false;
                                }
                                case 2: {
                                    if (exclusionPatterns != null && inclusionPatterns == null && org.eclipse.jdt.internal.core.util.Util.isExcluded(proxy.requestFullPath(), inclusionPatterns, exclusionPatterns, true)) {
                                        return false;
                                    }
                                    if (!hasOutputs || !outputs.contains(proxy.requestFullPath())) break;
                                    return false;
                                }
                            }
                            return true;
                        }
                    }, 0);
                    continue;
                }
                sourceFolder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) {
                        if (IndexAllProject.this.isCancelled) {
                            return false;
                        }
                        switch (proxy.getType()) {
                            case 1: {
                                if (Util.isJavaFileName(proxy.getName())) {
                                    String path;
                                    IFile file = (IFile)proxy.requestResource();
                                    IPath location = file.getLocation();
                                    if (location == null) {
                                        return false;
                                    }
                                    if ((exclusionPatterns != null || inclusionPatterns != null) && org.eclipse.jdt.internal.core.util.Util.isExcluded((IResource)file, inclusionPatterns, exclusionPatterns)) {
                                        return false;
                                    }
                                    indexedFileNames.put(path, indexedFileNames.get(path = file.getFullPath().toString()) == null || indexLastModified < location.toFile().lastModified() ? file : "OK");
                                }
                                return false;
                            }
                            case 2: {
                                if ((exclusionPatterns != null || inclusionPatterns != null) && org.eclipse.jdt.internal.core.util.Util.isExcluded(proxy.requestResource(), inclusionPatterns, exclusionPatterns)) {
                                    return false;
                                }
                                if (!hasOutputs || !outputs.contains(proxy.requestFullPath())) break;
                                return false;
                            }
                        }
                        return true;
                    }
                }, 0);
            }
            Object[] names = indexedFileNames.keyTable;
            Object[] values = indexedFileNames.valueTable;
            int length2 = names.length;
            for (int i = 0; i < length2; ++i) {
                String name = (String)names[i];
                if (name == null) continue;
                if (this.isCancelled) {
                    boolean hasOutputs = false;
                    return hasOutputs;
                }
                Object value = values[i];
                if (value == "OK") continue;
                if (value == "DELETED") {
                    this.manager.remove(name, this.containerPath);
                    continue;
                }
                this.manager.addSource((IFile)value, this.containerPath);
            }
            this.manager.request(new SaveIndex(this.containerPath, this.manager));
        }
        catch (CoreException e) {
            if (JobManager.VERBOSE) {
                org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + this.project + " because of the following exception:", System.err);
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            bl = false;
            return bl;
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + this.project + " because of the following exception:", System.err);
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            bl = false;
            return bl;
        }
        finally {
            monitor.exitRead();
        }
        return true;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing project " + this.project.getFullPath();
    }
}

