/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.XMLDefaultHandler;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.ChoiceRestriction;
import org.eclipse.pde.internal.core.schema.DocumentSection;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaCompositor;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.core.schema.SchemaEnumeration;
import org.eclipse.pde.internal.core.schema.SchemaInclude;
import org.eclipse.pde.internal.core.schema.SchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.core.schema.SchemaType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Schema
extends PlatformObject
implements ISchema {
    private URL url;
    private Vector listeners = new Vector();
    private Vector elements = new Vector();
    private Vector docSections = new Vector();
    private Vector includes;
    private String pointId;
    private String pluginId;
    private ISchemaDescriptor schemaDescriptor;
    private boolean loaded;
    private Vector references;
    private String description;
    private String name = "";
    private boolean notificationEnabled;
    public static final String INDENT = "   ";
    private boolean disposed = false;
    private Hashtable lineTable;
    private boolean valid;
    private int startLine;
    private int endLine;
    static /* synthetic */ Class class$org$eclipse$pde$internal$core$ischema$ISchemaElement;

    public Schema(String pluginId, String pointId, String name) {
        this.pluginId = pluginId;
        this.pointId = pointId;
        this.name = name;
    }

    public Schema(ISchemaDescriptor schemaDescriptor, URL url) {
        this.schemaDescriptor = schemaDescriptor;
        this.url = url;
    }

    public void addDocumentSection(IDocumentSection docSection) {
        this.docSections.addElement(docSection);
        this.fireModelChanged(new ModelChangedEvent(this, 1, new Object[]{docSection}, null));
    }

    public void addElement(ISchemaElement element) {
        this.addElement(element, null);
    }

    public void addElement(ISchemaElement element, ISchemaElement afterElement) {
        int index = -1;
        if (afterElement != null) {
            index = this.elements.indexOf(afterElement);
        }
        if (index != -1) {
            this.elements.add(index + 1, element);
        } else {
            this.elements.add(element);
        }
        this.fireModelChanged(new ModelChangedEvent(this, 1, new Object[]{element}, null));
    }

    public void addInclude(ISchemaInclude include) {
        if (this.includes == null) {
            this.includes = new Vector();
        }
        this.includes.add(include);
        this.fireModelChanged(new ModelChangedEvent(this, 1, new Object[]{include}, null));
    }

    public void removeInclude(ISchemaInclude include) {
        if (this.includes == null) {
            return;
        }
        this.includes.remove(include);
        this.fireModelChanged(new ModelChangedEvent(this, 2, new Object[]{include}, null));
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        this.listeners.addElement(listener);
    }

    private void collectElements(ISchemaCompositor compositor, Vector result) {
        ISchemaObject[] children = compositor.getChildren();
        for (int i = 0; i < children.length; ++i) {
            ISchemaObjectReference ref;
            ISchemaObject referenced;
            ISchemaObject child = children[i];
            if (child instanceof ISchemaCompositor) {
                this.collectElements((ISchemaCompositor)child, result);
                continue;
            }
            if (!(child instanceof ISchemaObjectReference) || !((referenced = (ref = (ISchemaObjectReference)((Object)child)).getReferencedObject()) instanceof ISchemaElement)) continue;
            result.addElement(referenced);
        }
    }

    public void dispose() {
        if (this.includes != null) {
            for (int i = 0; i < this.includes.size(); ++i) {
                ISchemaInclude include = (ISchemaInclude)this.includes.get(i);
                include.dispose();
            }
        }
        this.reset();
        this.disposed = true;
    }

    public ISchemaElement findElement(String name) {
        int i;
        if (!this.isLoaded()) {
            this.load();
        }
        for (i = 0; i < this.elements.size(); ++i) {
            ISchemaElement element = (ISchemaElement)this.elements.elementAt(i);
            if (!element.getName().equals(name)) continue;
            return element;
        }
        if (this.includes != null) {
            for (i = 0; i < this.includes.size(); ++i) {
                ISchemaElement element;
                ISchemaInclude include = (ISchemaInclude)this.includes.get(i);
                ISchema ischema = include.getIncludedSchema();
                if (ischema == null || (element = ischema.findElement(name)) == null) continue;
                return element;
            }
        }
        return null;
    }

    public void fireModelChanged(IModelChangedEvent event) {
        if (!this.notificationEnabled) {
            return;
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            IModelChangedListener listener = (IModelChangedListener)iter.next();
            listener.modelChanged(event);
        }
    }

    public void fireModelObjectChanged(Object object, String property, Object oldValue, Object newValue) {
        this.fireModelChanged(new ModelChangedEvent(this, object, property, oldValue, newValue));
    }

    private String getAttribute(Node node, String name) {
        String value;
        NamedNodeMap map = node.getAttributes();
        Node attNode = map.getNamedItem(name);
        if (attNode != null && (value = attNode.getNodeValue()).length() > 0) {
            return value;
        }
        return null;
    }

    public ISchemaElement[] getCandidateChildren(ISchemaElement element) {
        ISchemaCompositor compositor;
        Vector candidates = new Vector();
        ISchemaType type = element.getType();
        if (type instanceof ISchemaComplexType && (compositor = ((ISchemaComplexType)type).getCompositor()) != null) {
            this.collectElements(compositor, candidates);
        }
        Object[] result = new ISchemaElement[candidates.size()];
        candidates.copyInto(result);
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isValid() {
        return this.valid;
    }

    public IDocumentSection[] getDocumentSections() {
        Object[] result = new IDocumentSection[this.docSections.size()];
        this.docSections.copyInto(result);
        return result;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public int getResolvedElementCount() {
        int localCount = this.getElementCount();
        if (this.includes == null) {
            return localCount;
        }
        int totalCount = localCount;
        for (int i = 0; i < this.includes.size(); ++i) {
            ISchemaInclude include = (ISchemaInclude)this.includes.get(i);
            ISchema schema = include.getIncludedSchema();
            if (schema == null) continue;
            totalCount += schema.getResolvedElementCount();
        }
        return totalCount;
    }

    public ISchemaElement[] getElements() {
        if (!this.isLoaded()) {
            this.load();
        }
        Object[] result = new ISchemaElement[this.elements.size()];
        this.elements.copyInto(result);
        return result;
    }

    public ISchemaElement[] getResolvedElements() {
        if (this.includes == null) {
            return this.getElements();
        }
        if (!this.isLoaded()) {
            this.load();
        }
        Vector result = (Vector)this.elements.clone();
        for (int i = 0; i < this.includes.size(); ++i) {
            ISchemaInclude include = (ISchemaInclude)this.includes.get(i);
            ISchema schema = include.getIncludedSchema();
            if (schema == null) continue;
            ISchemaElement[] ielements = schema.getElements();
            for (int j = 0; j < ielements.length; ++j) {
                result.add(ielements[j]);
            }
        }
        return result.toArray(new ISchemaElement[result.size()]);
    }

    public ISchemaInclude[] getIncludes() {
        if (this.includes == null) {
            return new ISchemaInclude[0];
        }
        return this.includes.toArray(new ISchemaInclude[this.includes.size()]);
    }

    public String getName() {
        return this.name;
    }

    private String getNormalizedText(String source) {
        String result = source.replace('\t', ' ');
        result = result.trim();
        return result;
    }

    public ISchemaObject getParent() {
        return null;
    }

    public void setParent(ISchemaObject obj) {
    }

    public String getQualifiedPointId() {
        return this.pluginId + "." + this.pointId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPointId() {
        return this.pointId;
    }

    public ISchema getSchema() {
        return this;
    }

    public ISchemaDescriptor getSchemaDescriptor() {
        return this.schemaDescriptor;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public void load() {
        try {
            InputStream source = this.getURL().openStream();
            this.load(source);
            source.close();
        }
        catch (FileNotFoundException e) {
            this.loaded = false;
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    public void load(InputStream stream) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLDefaultHandler handler = new XMLDefaultHandler();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(stream, (DefaultHandler)handler);
            this.traverseDocumentTree(handler.getDocumentElement(), handler.getLineTable());
        }
        catch (SAXException e) {
        }
        catch (Exception e) {
            PDECore.logException(e);
        }
    }

    private ISchemaAttribute processAttribute(ISchemaElement element, Node elementNode) {
        String aname = this.getAttribute(elementNode, "name");
        String atype = this.getAttribute(elementNode, "type");
        String ause = this.getAttribute(elementNode, "use");
        String avalue = this.getAttribute(elementNode, "value");
        ISchemaSimpleType type = null;
        if (atype != null) {
            type = (ISchemaSimpleType)((Object)this.resolveTypeReference(atype));
        }
        SchemaAttribute attribute = new SchemaAttribute(element, aname);
        attribute.bindSourceLocation(elementNode, this.lineTable);
        attribute.addComments(elementNode);
        if (ause != null) {
            int use = 0;
            if (ause.equals("required")) {
                use = 1;
            } else if (ause.equals("optional")) {
                use = 0;
            } else if (ause.equals("default")) {
                use = 2;
            }
            attribute.setUse(use);
        }
        if (avalue != null) {
            attribute.setValue(avalue);
        }
        NodeList children = elementNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String tag = child.getNodeName();
            if (tag.equals("annotation")) {
                this.processAttributeAnnotation(attribute, child);
                continue;
            }
            if (!tag.equals("simpleType")) continue;
            this.processAttributeSimpleType(attribute, child);
        }
        if (type != null && attribute.getType() == null) {
            attribute.setType(type);
        }
        return attribute;
    }

    private void processAttributeAnnotation(SchemaAttribute element, Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("documentation")) {
                element.setDescription(this.getNormalizedText(child.getFirstChild().getNodeValue()));
                continue;
            }
            if (!child.getNodeName().equals("appInfo")) continue;
            NodeList infos = child.getChildNodes();
            for (int j = 0; j < infos.getLength(); ++j) {
                Node meta = infos.item(j);
                if (meta.getNodeType() != 1 || !meta.getNodeName().equals("meta.attribute")) continue;
                element.setKind(this.processKind(this.getAttribute(meta, "kind")));
                element.setBasedOn(this.getAttribute(meta, "basedOn"));
            }
        }
    }

    private SchemaSimpleType processAttributeRestriction(SchemaAttribute attribute, Node node) {
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return null;
        }
        String baseName = this.getAttribute(node, "base");
        if (!baseName.equals("string")) {
            return new SchemaSimpleType(attribute.getSchema(), "string");
        }
        SchemaSimpleType type = new SchemaSimpleType(attribute.getSchema(), baseName);
        Vector<ISchemaEnumeration> items = new Vector<ISchemaEnumeration>();
        for (int i = 0; i < children.getLength(); ++i) {
            ISchemaEnumeration iSchemaEnumeration;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals("enumeration") || (iSchemaEnumeration = this.processEnumeration(attribute.getSchema(), child)) == null) continue;
            items.addElement(iSchemaEnumeration);
        }
        ChoiceRestriction restriction = new ChoiceRestriction(attribute.getSchema());
        restriction.setChildren(items);
        type.setRestriction(restriction);
        return type;
    }

    private void processAttributeSimpleType(SchemaAttribute attribute, Node node) {
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return;
        }
        SchemaSimpleType type = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals("restriction")) continue;
            type = this.processAttributeRestriction(attribute, child);
        }
        if (type != null) {
            attribute.setType(type);
        }
    }

    private SchemaComplexType processComplexType(ISchemaElement owner, Node typeNode) {
        String aname = this.getAttribute(typeNode, "name");
        String amixed = this.getAttribute(typeNode, "mixed");
        SchemaComplexType complexType = new SchemaComplexType(this, aname);
        if (amixed != null && amixed.equals("true")) {
            complexType.setMixed(true);
        }
        NodeList children = typeNode.getChildNodes();
        ISchemaCompositor compositor = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("attribute")) {
                complexType.addAttribute(this.processAttribute(owner, child));
                continue;
            }
            ISchemaObject object = this.processCompositorChild(owner, child, -1);
            if (!(object instanceof ISchemaCompositor) || compositor != null) continue;
            compositor = (ISchemaCompositor)object;
        }
        complexType.setCompositor(compositor);
        return complexType;
    }

    private ISchemaCompositor processCompositor(ISchemaObject parent, Node node, int type) {
        SchemaCompositor compositor = new SchemaCompositor(parent, type);
        compositor.addComments(node);
        NodeList children = node.getChildNodes();
        int minOccurs = 1;
        int maxOccurs = 1;
        String aminOccurs = this.getAttribute(node, "minOccurs");
        String amaxOccurs = this.getAttribute(node, "maxOccurs");
        if (aminOccurs != null) {
            minOccurs = Integer.valueOf(aminOccurs);
        }
        if (amaxOccurs != null) {
            maxOccurs = amaxOccurs.equals("unbounded") ? Integer.MAX_VALUE : Integer.valueOf(amaxOccurs);
        }
        compositor.setMinOccurs(minOccurs);
        compositor.setMaxOccurs(maxOccurs);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            ISchemaObject object = this.processCompositorChild(compositor, child, type);
            if (object == null) continue;
            compositor.addChild(object);
        }
        return compositor;
    }

    private ISchemaObject processCompositorChild(ISchemaObject parent, Node child, int parentKind) {
        String tag = child.getNodeName();
        if (tag.equals("element")) {
            return this.processElement(parent, child);
        }
        if (tag.equals("sequence") && parentKind != 0) {
            return this.processCompositor(parent, child, 2);
        }
        if (tag.equals("choice") && parentKind != 0) {
            return this.processCompositor(parent, child, 1);
        }
        if (tag.equals("all") && (parentKind == -1 || parentKind == 3)) {
            return this.processCompositor(parent, child, 0);
        }
        if (tag.equals("group") && (parentKind == 1 || parentKind == 2)) {
            return this.processCompositor(parent, child, 3);
        }
        return null;
    }

    private ISchemaElement processElement(ISchemaObject parent, Node elementNode) {
        String aname = this.getAttribute(elementNode, "name");
        String atype = this.getAttribute(elementNode, "type");
        String aref = this.getAttribute(elementNode, "ref");
        int minOccurs = 1;
        int maxOccurs = 1;
        String aminOccurs = this.getAttribute(elementNode, "minOccurs");
        String amaxOccurs = this.getAttribute(elementNode, "maxOccurs");
        if (aminOccurs != null) {
            minOccurs = Integer.valueOf(aminOccurs);
        }
        if (amaxOccurs != null) {
            maxOccurs = amaxOccurs.equals("unbounded") ? Integer.MAX_VALUE : Integer.valueOf(amaxOccurs);
        }
        if (aref != null) {
            SchemaElementReference reference = new SchemaElementReference((ISchemaCompositor)parent, aref);
            reference.addComments(elementNode);
            reference.setMinOccurs(minOccurs);
            reference.setMaxOccurs(maxOccurs);
            this.references.addElement(reference);
            reference.bindSourceLocation(elementNode, this.lineTable);
            return reference;
        }
        SchemaType type = null;
        if (atype != null) {
            type = this.resolveTypeReference(atype);
        }
        SchemaElement element = new SchemaElement(parent, aname);
        element.bindSourceLocation(elementNode, this.lineTable);
        element.addComments(elementNode);
        element.setMinOccurs(minOccurs);
        element.setMaxOccurs(maxOccurs);
        NodeList children = elementNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String tag = child.getNodeName();
            if (type == null && tag.equals("complexType")) {
                type = this.processComplexType(element, child);
            }
            if (!tag.equals("annotation")) continue;
            this.processElementAnnotation(element, child);
        }
        element.setType(type);
        return element;
    }

    private void processElementAnnotation(SchemaElement element, Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("documentation")) {
                element.setDescription(this.getNormalizedText(child.getFirstChild().getNodeValue()));
                continue;
            }
            if (!child.getNodeName().equals("appInfo")) continue;
            NodeList infos = child.getChildNodes();
            for (int j = 0; j < infos.getLength(); ++j) {
                Node meta = infos.item(j);
                if (meta.getNodeType() != 1 || !meta.getNodeName().equals("meta.element")) continue;
                element.setLabelProperty(this.getAttribute(meta, "labelAttribute"));
                element.setIconProperty(this.getAttribute(meta, "icon"));
                if (element.getIconProperty() != null) continue;
                element.setIconProperty(this.getAttribute(meta, "iconName"));
            }
        }
    }

    private ISchemaEnumeration processEnumeration(ISchema schema, Node node) {
        String name = this.getAttribute(node, "value");
        SchemaEnumeration schemaEnumeration = new SchemaEnumeration(schema, name);
        schemaEnumeration.bindSourceLocation(node, this.lineTable);
        schemaEnumeration.addComments(node);
        return schemaEnumeration;
    }

    private int processKind(String name) {
        if (name != null) {
            if (name.equals("java")) {
                return 1;
            }
            if (name.equals("resource")) {
                return 2;
            }
        }
        return 0;
    }

    void setSourceLocation(Node node) {
        if (this.lineTable == null) {
            return;
        }
        Integer[] lines = (Integer[])this.lineTable.get(node);
        if (lines != null) {
            this.startLine = lines[0];
            this.endLine = lines[1];
        } else {
            this.startLine = -1;
            this.endLine = -1;
        }
    }

    public int getOverviewStartLine() {
        return this.startLine;
    }

    public int getOverviewEndLine() {
        return this.endLine;
    }

    private void processSchemaAnnotation(Node node) {
        NodeList children = node.getChildNodes();
        String section = "overview";
        String sectionName = "Overview";
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("documentation")) {
                String text = this.getNormalizedText(child.getFirstChild().getNodeValue());
                if (section == null) continue;
                if (section.equals("overview")) {
                    this.setDescription(text);
                    this.setSourceLocation(child);
                    continue;
                }
                DocumentSection sec = new DocumentSection(this, section, sectionName);
                sec.bindSourceLocation(child, this.lineTable);
                sec.setDescription(text);
                this.docSections.addElement(sec);
                continue;
            }
            if (!child.getNodeName().equals("appInfo")) continue;
            NodeList infos = child.getChildNodes();
            for (int j = 0; j < infos.getLength(); ++j) {
                Node meta = infos.item(j);
                if (meta.getNodeType() != 1) continue;
                if (meta.getNodeName().equals("meta.schema")) {
                    section = "overview";
                    this.setName(this.getAttribute(meta, "name"));
                    this.pluginId = this.getAttribute(meta, "plugin");
                    this.pointId = this.getAttribute(meta, "id");
                    this.valid = true;
                    continue;
                }
                if (!meta.getNodeName().equals("meta.section")) continue;
                section = this.getAttribute(meta, "type");
                sectionName = this.getAttribute(meta, "name");
                if (sectionName != null) continue;
                sectionName = section;
            }
        }
    }

    private void processInclude(Node node) {
        String location = this.getAttribute(node, "schemaLocation");
        SchemaInclude include = new SchemaInclude(this, location);
        if (this.includes == null) {
            this.includes = new Vector();
        }
        this.includes.add(include);
    }

    public void reload() {
        this.reload(null);
    }

    public void reload(InputStream is) {
        this.setNotificationEnabled(false);
        this.reset();
        if (is != null) {
            this.load(is);
        } else {
            this.load();
        }
        this.setNotificationEnabled(true);
        if (this.isLoaded()) {
            this.fireModelChanged(new ModelChangedEvent(this, 99, new Object[0], null));
        }
    }

    public void removeDocumentSection(IDocumentSection docSection) {
        this.docSections.removeElement(docSection);
        this.fireModelChanged(new ModelChangedEvent(this, 2, new Object[]{docSection}, null));
    }

    public void removeElement(ISchemaElement element) {
        this.elements.removeElement(element);
        this.fireModelChanged(new ModelChangedEvent(this, 2, new Object[]{element}, null));
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        this.listeners.removeElement(listener);
    }

    private void reset() {
        this.lineTable = null;
        this.elements = new Vector();
        this.docSections = new Vector();
        this.includes = null;
        this.pointId = null;
        this.pluginId = null;
        this.references = null;
        this.description = null;
        this.name = null;
        this.valid = false;
    }

    private void resolveElementReference(ISchemaObjectReference reference) {
        ISchemaElement[] elementList = this.getResolvedElements();
        for (int i = 0; i < elementList.length; ++i) {
            ISchemaElement element = elementList[i];
            if (element instanceof ISchemaObjectReference || !element.getName().equals(reference.getName())) continue;
            reference.setReferencedObject(element);
            break;
        }
    }

    private void resolveReference(ISchemaObjectReference reference) {
        Class clazz = reference.getReferencedObjectClass();
        if (clazz.equals(class$org$eclipse$pde$internal$core$ischema$ISchemaElement == null ? (class$org$eclipse$pde$internal$core$ischema$ISchemaElement = Schema.class$("org.eclipse.pde.internal.core.ischema.ISchemaElement")) : class$org$eclipse$pde$internal$core$ischema$ISchemaElement)) {
            this.resolveElementReference(reference);
        }
    }

    private void resolveReferences(Vector references) {
        for (int i = 0; i < references.size(); ++i) {
            ISchemaObjectReference reference = (ISchemaObjectReference)references.elementAt(i);
            this.resolveReference(reference);
        }
    }

    private SchemaType resolveTypeReference(String typeName) {
        return new SchemaSimpleType(this, typeName);
    }

    public void setDescription(String newDescription) {
        String oldValue = this.description;
        this.description = newDescription;
        this.fireModelObjectChanged(this, "description", oldValue, this.description);
    }

    public void setName(String newName) {
        if (newName == null) {
            newName = "";
        }
        String oldValue = this.name;
        this.name = newName;
        this.fireModelObjectChanged(this, "name", oldValue, this.name);
    }

    public void setPluginId(String newId) {
        String oldValue = this.pluginId;
        this.pluginId = newId;
        this.fireModelObjectChanged(this, "pluginId", oldValue, newId);
    }

    public void setPointId(String newId) {
        String oldValue = this.pointId;
        this.pointId = newId;
        this.fireModelObjectChanged(this, "pointId", oldValue, newId);
    }

    public void setNotificationEnabled(boolean newNotificationEnabled) {
        this.notificationEnabled = newNotificationEnabled;
    }

    public String toString() {
        return this.name;
    }

    public void traverseDocumentTree(Node root, Hashtable lineTable) {
        this.lineTable = lineTable;
        NodeList children = root.getChildNodes();
        this.references = new Vector();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName().toLowerCase();
            if (nodeName.equals("element")) {
                ISchemaElement element = this.processElement(this, child);
                this.elements.addElement(element);
                continue;
            }
            if (nodeName.equals("annotation")) {
                this.processSchemaAnnotation(child);
                continue;
            }
            if (!nodeName.equals("include")) continue;
            this.processInclude(child);
        }
        this.loaded = true;
        if (this.references.size() > 0) {
            this.resolveReferences(this.references);
        }
        this.references = null;
        this.lineTable = null;
    }

    public void updateReferencesFor(ISchemaElement element) {
        this.updateReferencesFor(element, 3);
    }

    public void updateReferencesFor(ISchemaElement element, int kind) {
        for (int i = 0; i < this.elements.size(); ++i) {
            SchemaCompositor compositor;
            ISchemaType type;
            ISchemaElement el = (ISchemaElement)this.elements.elementAt(i);
            if (el.equals(element) || !((type = el.getType()) instanceof ISchemaComplexType) || (compositor = (SchemaCompositor)((ISchemaComplexType)type).getCompositor()) == null) continue;
            compositor.updateReferencesFor(element, kind);
        }
    }

    public void write(String indent, PrintWriter writer) {
        int i;
        String pointId = this.getQualifiedPointId();
        int loc = pointId.lastIndexOf(46);
        String pluginId = "";
        if (loc != -1) {
            pluginId = pointId.substring(0, loc);
            pointId = pointId.substring(loc + 1);
        }
        writer.println("<?xml version='1.0' encoding='UTF-8'?>");
        writer.println("<!-- Schema file written by PDE -->");
        writer.println("<schema targetNamespace=\"" + pluginId + "\">");
        String indent2 = "      ";
        String indent3 = indent2 + INDENT;
        writer.println(indent + "<annotation>");
        writer.println(indent2 + "<appInfo>");
        writer.print(indent3 + "<meta.schema plugin=\"" + pluginId + "\"");
        writer.print(" id=\"" + pointId + "\"");
        writer.println(" name=\"" + this.getName() + "\"/>");
        writer.println(indent2 + "</appInfo>");
        writer.println(indent2 + "<documentation>");
        writer.println(indent3 + SchemaObject.getWritableDescription(this.getDescription()));
        writer.println(indent2 + "</documentation>");
        writer.println("   </annotation>");
        writer.println();
        if (this.includes != null) {
            for (i = 0; i < this.includes.size(); ++i) {
                ISchemaInclude include = (ISchemaInclude)this.includes.get(i);
                include.write(INDENT, writer);
                writer.println();
            }
        }
        for (i = 0; i < this.elements.size(); ++i) {
            ISchemaElement element = (ISchemaElement)this.elements.elementAt(i);
            element.write(INDENT, writer);
            writer.println();
        }
        for (i = 0; i < this.docSections.size(); ++i) {
            IDocumentSection section = (IDocumentSection)this.docSections.elementAt(i);
            section.write(INDENT, writer);
            writer.println();
        }
        writer.println("</schema>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

