/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaCompositor;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.PropertiesAction;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.schema.NewCompositorAction;
import org.eclipse.pde.internal.ui.editor.schema.NewReferenceAction;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class GrammarSection
extends PDESection
implements IPartSelectionListener {
    private TreeViewer treeViewer;
    private Text dtdLabel;
    public static final String SECTION_TITLE = "SchemaEditor.GrammarSection.title";
    public static final String SECTION_COMPOSITOR = "SchemaEditor.GrammarSection.compositor";
    public static final String SECTION_REFERENCE = "SchemaEditor.GrammarSection.reference";
    public static final String POPUP_NEW = "Menus.new.label";
    public static final String POPUP_DELETE = "Actions.delete.label";
    public static final String SECTION_DESC = "SchemaEditor.GrammarSection.desc";
    public static final String KEY_DTD = "SchemaEditor.GrammarSection.dtd";

    public GrammarSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = toolkit.getBorderStyle() == 2048 ? 0 : 1;
        container.setLayout((Layout)layout);
        Control tree = this.createTree(container, toolkit);
        GridData gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        this.dtdLabel = toolkit.createText(container, "", 578);
        this.dtdLabel.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.dtdLabel.setEditable(false);
        this.dtdLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        gd = new GridData(1808);
        this.dtdLabel.setLayoutData((Object)gd);
        this.updateDTDLabel(null);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private Control createTree(Composite parent, FormToolkit toolkit) {
        Tree tree = toolkit.createTree(parent, 4);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new GrammarLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new GrammarContentProvider());
        this.treeViewer.setAutoExpandLevel(999);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                GrammarSection.this.getPage().getPDEEditor().setSelection(e.getSelection());
            }
        });
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                GrammarSection.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.setRemoveAllWhenShown(true);
        popupMenuManager.addMenuListener(listener);
        Menu menu = popupMenuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
        return tree;
    }

    public void dispose() {
        ISchema schema = (ISchema)this.getPage().getModel();
        schema.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            ISelection sel = this.treeViewer.getSelection();
            Object obj = ((IStructuredSelection)sel).getFirstElement();
            if (obj != null) {
                this.handleDelete(obj);
            }
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.treeViewer.getSelection();
        final Object object = ((IStructuredSelection)selection).getFirstElement();
        ISchemaElement sourceElement = (ISchemaElement)this.treeViewer.getInput();
        if (sourceElement != null) {
            ISchema schema = sourceElement.getSchema();
            MenuManager submenu = new MenuManager(PDEPlugin.getResourceString(POPUP_NEW));
            MenuManager cmenu = new MenuManager(PDEPlugin.getResourceString(SECTION_COMPOSITOR));
            cmenu.add((IAction)new NewCompositorAction(sourceElement, object, 0));
            cmenu.add((IAction)new NewCompositorAction(sourceElement, object, 1));
            cmenu.add((IAction)new NewCompositorAction(sourceElement, object, 2));
            cmenu.add((IAction)new NewCompositorAction(sourceElement, object, 3));
            submenu.add((IContributionItem)cmenu);
            if (schema.getResolvedElementCount() > 1 && object != null && object instanceof SchemaCompositor) {
                MenuManager refMenu = new MenuManager(PDEPlugin.getResourceString(SECTION_REFERENCE));
                ISchemaElement[] elements = schema.getResolvedElements();
                for (int i = 0; i < elements.length; ++i) {
                    ISchemaElement element = elements[i];
                    refMenu.add((IAction)new NewReferenceAction(sourceElement, object, element));
                }
                submenu.add((IContributionItem)refMenu);
            }
            if (object == null || object instanceof SchemaCompositor) {
                manager.add((IContributionItem)submenu);
            }
            if (object != null) {
                manager.add((IContributionItem)new Separator());
                Action deleteAction = new Action(){

                    public void run() {
                        GrammarSection.this.handleDelete(object);
                    }
                };
                deleteAction.setText(PDEPlugin.getResourceString(POPUP_DELETE));
                deleteAction.setEnabled(schema.isEditable());
                manager.add((IAction)deleteAction);
            }
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new PropertiesAction(this.getPage().getPDEEditor()));
    }

    private void handleDelete(Object object) {
        if (object instanceof SchemaCompositor) {
            SchemaCompositor compositor = (SchemaCompositor)object;
            ISchemaObject parent = compositor.getParent();
            if (parent instanceof ISchemaElement) {
                SchemaElement element = (SchemaElement)parent;
                SchemaComplexType complexType = (SchemaComplexType)element.getType();
                if (complexType.getAttributeCount() == 0) {
                    element.setType((ISchemaType)new SchemaSimpleType(element.getSchema(), "string"));
                } else {
                    complexType.setCompositor(null);
                }
            } else if (parent instanceof SchemaCompositor) {
                ((SchemaCompositor)parent).removeChild((ISchemaObject)compositor);
            }
        } else if (object instanceof SchemaElementReference) {
            SchemaCompositor compositor = (SchemaCompositor)((SchemaElementReference)object).getCompositor();
            compositor.removeChild((ISchemaObject)((SchemaElementReference)object));
        }
    }

    public void initialize() {
        ISchema schema = (ISchema)this.getPage().getModel();
        schema.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object obj = e.getChangedObjects()[0];
        if (obj instanceof ISchemaCompositor || obj instanceof ISchemaObjectReference) {
            final ISchemaObject sobj = (ISchemaObject)obj;
            ISchemaObject parent = sobj.getParent();
            if (e.getChangeType() == 3) {
                this.treeViewer.update((Object)sobj, null);
            } else if (e.getChangeType() == 1) {
                this.treeViewer.add((Object)parent, (Object)sobj);
                this.treeViewer.getTree().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        GrammarSection.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)sobj), true);
                    }
                });
            } else if (e.getChangeType() == 2) {
                this.treeViewer.remove((Object)sobj);
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)parent), true);
            }
        } else if (obj instanceof ISchemaComplexType) {
            this.treeViewer.refresh();
            if (e.getChangeType() == 1) {
                ISchemaComplexType type = (ISchemaComplexType)obj;
                final ISchemaCompositor compositor = type.getCompositor();
                this.treeViewer.getTree().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        GrammarSection.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)compositor), true);
                    }
                });
            }
        } else if (obj instanceof ISchemaElement && e.getChangeType() == 3 && e.getChangedProperty() == "type") {
            this.treeViewer.refresh();
        }
        this.updateDTDLabel((ISchemaObject)this.treeViewer.getInput());
    }

    public void refresh() {
        this.treeViewer.refresh();
        super.refresh();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (!(part instanceof ElementSection)) {
            return;
        }
        Object changeObject = ((IStructuredSelection)selection).getFirstElement();
        if (changeObject instanceof ISchemaAttribute) {
            changeObject = ((ISchemaAttribute)changeObject).getParent();
        }
        if (changeObject == this.treeViewer.getInput()) {
            return;
        }
        ISchemaObject element = (ISchemaObject)changeObject;
        this.updateDTDLabel(element);
        this.treeViewer.setInput(changeObject);
    }

    private void updateDTDLabel(ISchemaObject object) {
        String prefix = PDEPlugin.getResourceString(KEY_DTD) + "\n";
        String text = "";
        if (object != null) {
            ISchemaElement element = (ISchemaElement)object;
            text = element.getDTDRepresentation(false);
        }
        this.dtdLabel.setText(prefix + text);
    }

    class GrammarLabelProvider
    extends LabelProvider {
        GrammarLabelProvider() {
        }

        public String getText(Object o) {
            return PDEPlugin.getDefault().getLabelProvider().getText(o);
        }

        public Image getImage(Object o) {
            if (o instanceof ISchemaObjectReference) {
                ISchemaObjectReference ref = (ISchemaObjectReference)o;
                int flags = ref.getReferencedObject() == null ? 1 : 0;
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_ELREF_SC_OBJ, flags);
            }
            return PDEPlugin.getDefault().getLabelProvider().getImage(o);
        }
    }

    class GrammarContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        GrammarContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            Object[] children = null;
            if (parent instanceof ISchemaElement && !(parent instanceof SchemaElementReference)) {
                ISchemaCompositor compositor;
                ISchemaType type = ((ISchemaElement)parent).getType();
                if (type instanceof ISchemaComplexType && (compositor = ((ISchemaComplexType)type).getCompositor()) != null) {
                    children = new Object[]{compositor};
                }
            } else if (parent instanceof ISchemaCompositor) {
                children = ((ISchemaCompositor)parent).getChildren();
            }
            if (children == null) {
                children = new Object[]{};
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }
    }
}

