/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.infoviews.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.infoviews.GotoInputAction;
import org.eclipse.jdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.jdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

abstract class AbstractInfoView
extends ViewPart
implements ISelectionListener,
IMenuListener {
    private static final int TITLE_LABEL_FLAGS = 1386656;
    private static final int TOOLTIP_LABEL_FLAGS = 202713775;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                IWorkbenchPart activePart = ref.getPage().getActivePart();
                if (activePart != null) {
                    AbstractInfoView.this.selectionChanged(activePart, ref.getPage().getSelection());
                }
                AbstractInfoView.this.startListeningForSelectionChanges();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.stopListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (!ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.computeAndSetInput(ref.getPart(false));
            }
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    };
    protected IJavaElement fCurrentViewInput;
    private SelectionDispatchAction fCopyToClipboardAction;
    private GotoInputAction fGotoInputAction;
    private volatile int fComputeCount;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    AbstractInfoView() {
    }

    protected abstract void setInput(Object var1);

    protected abstract Object computeInput(Object var1);

    protected abstract void internalCreatePartControl(Composite var1);

    protected abstract void setForeground(Color var1);

    protected abstract void setBackground(Color var1);

    abstract Control getControl();

    public final void createPartControl(Composite parent) {
        this.internalCreatePartControl(parent);
        this.setInfoColor();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
        this.createContextMenu();
        this.createActions();
        this.fillActionBars(this.getViewSite().getActionBars());
    }

    protected void createActions() {
        this.fGotoInputAction = new GotoInputAction(this);
        this.fGotoInputAction.setEnabled(false);
        this.fCopyToClipboardAction = new CopyToClipboardAction((IWorkbenchSite)this.getViewSite());
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, this.getSelectionProvider());
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("additions"));
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            menu.appendToGroup("group.edit", action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            menu.appendToGroup("group.edit", action);
        }
        menu.appendToGroup("group.open", (IAction)this.fGotoInputAction);
    }

    protected IAction getSelectAllAction() {
        return null;
    }

    protected IAction getCopyToClipboardAction() {
        return this.fCopyToClipboardAction;
    }

    protected IJavaElement getInput() {
        return this.fCurrentViewInput;
    }

    ISelectionProvider getSelectionProvider() {
        return this.getViewSite().getSelectionProvider();
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), action);
        }
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.fGotoInputAction);
    }

    private void setInfoColor() {
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        this.setForeground(display.getSystemColor(28));
        this.setBackground(display.getSystemColor(29));
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.equals((Object)this)) {
            return;
        }
        this.computeAndSetInput(part);
    }

    protected boolean isIgnoringEqualInput() {
        return true;
    }

    protected IJavaElement findSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        Object element;
        try {
            if (part instanceof JavaEditor && selection instanceof ITextSelection) {
                IJavaElement[] elements = TextSelectionConverter.codeResolve((JavaEditor)part, (ITextSelection)selection);
                if (elements != null && elements.length > 0) {
                    return elements[0];
                }
                return null;
            }
            if (!(selection instanceof IStructuredSelection)) {
                return null;
            }
            element = SelectionUtil.getSingleElement(selection);
        }
        catch (JavaModelException e) {
            return null;
        }
        return this.findJavaElement(element);
    }

    private IJavaElement findJavaElement(Object element) {
        IJavaElement je;
        if (element == null) {
            return null;
        }
        if (SearchUtil.isISearchResultViewEntry(element)) {
            je = SearchUtil.getJavaElement(element);
            if (je != null) {
                return je;
            }
            element = SearchUtil.getResource(element);
        }
        je = null;
        if (element instanceof IAdaptable) {
            je = (IJavaElement)((IAdaptable)element).getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = AbstractInfoView.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        }
        return je;
    }

    protected IType getTypeForCU(ICompilationUnit cu) {
        if (cu == null || !cu.exists()) {
            return null;
        }
        IType primaryType = cu.findPrimaryType();
        if (primaryType != null) {
            return primaryType;
        }
        try {
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                return types[0];
            }
            return null;
        }
        catch (JavaModelException ex) {
            return null;
        }
    }

    public final void dispose() {
        ++this.fComputeCount;
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
        this.internalDispose();
    }

    protected void internalDispose() {
    }

    private void computeAndSetInput(final IWorkbenchPart part) {
        final int currentCount = ++this.fComputeCount;
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider == null) {
            return;
        }
        final ISelection selection = provider.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Thread thread = new Thread("Info view input computer"){

            public void run() {
                if (currentCount != AbstractInfoView.this.fComputeCount) {
                    return;
                }
                IJavaElement je = AbstractInfoView.this.findSelectedJavaElement(part, selection);
                if (AbstractInfoView.this.isIgnoringEqualInput() && AbstractInfoView.this.fCurrentViewInput != null && AbstractInfoView.this.fCurrentViewInput.equals(je)) {
                    return;
                }
                Object input = AbstractInfoView.this.computeInput(je);
                if (input == null) {
                    return;
                }
                Shell shell = AbstractInfoView.this.getSite().getShell();
                if (shell.isDisposed()) {
                    return;
                }
                Display display = shell.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(this, je, input){
                    private final /* synthetic */ IJavaElement val$je;
                    private final /* synthetic */ Object val$input;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$je = val$je;
                        this.val$input = val$input;
                    }

                    public void run() {
                        if (AbstractInfoView.access$100(2.access$200(this.this$1)) != 2.access$300(this.this$1) || 2.access$200(this.this$1).getViewSite().getShell().isDisposed()) {
                            return;
                        }
                        2.access$200(this.this$1).fCurrentViewInput = this.val$je;
                        AbstractInfoView.access$400(2.access$200(this.this$1), this.val$input);
                    }
                });
            }

            static /* synthetic */ AbstractInfoView access$200(2 x0) {
                return x0.AbstractInfoView.this;
            }

            static /* synthetic */ int access$300(2 x0) {
                return x0.currentCount;
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    private void doSetInput(Object input) {
        this.setInput(input);
        this.fGotoInputAction.setEnabled(true);
        String title = InfoViewMessages.getFormattedString("AbstractInfoView.compoundTitle", this.getSite().getRegisteredName(), JavaElementLabels.getElementLabel(this.fCurrentViewInput, 1386656));
        this.setTitle(title);
        this.setTitleToolTip(JavaElementLabels.getElementLabel(this.fCurrentViewInput, 202713775));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$400(AbstractInfoView x0, Object x1) {
        x0.doSetInput(x1);
    }
}

