/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.internal.ui.views.console.ProcessConsolePage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;

public class ProcessConsole
extends AbstractConsole
implements IDebugEventSetListener {
    private IProcess fProcess = null;

    public IPageBookViewPage createPage(IConsoleView view) {
        return new ProcessConsolePage(view, this);
    }

    protected ImageDescriptor computeImageDescriptor() {
        ILaunchConfiguration configuration = this.getProcess().getLaunch().getLaunchConfiguration();
        if (configuration != null) {
            try {
                ILaunchConfigurationType type = configuration.getType();
                return DebugPluginImages.getImageDescriptor(type.getIdentifier());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    protected String computeName() {
        String label = null;
        IProcess process = this.getProcess();
        ILaunchConfiguration config = process.getLaunch().getLaunchConfiguration();
        label = process.getAttribute(IProcess.ATTR_PROCESS_LABEL);
        if (label == null) {
            if (config == null) {
                label = process.getLabel();
            } else if (DebugUITools.isPrivate(config)) {
                label = process.getLabel();
            } else {
                String type = null;
                try {
                    type = config.getType().getName();
                }
                catch (CoreException e) {
                    // empty catch block
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(config.getName());
                if (type != null) {
                    buffer.append(" [");
                    buffer.append(type);
                    buffer.append("] ");
                }
                buffer.append(process.getLabel());
                label = buffer.toString();
            }
        }
        if (process.isTerminated()) {
            return MessageFormat.format(ConsoleMessages.getString("ProcessConsole.0"), label);
        }
        return label;
    }

    public ProcessConsole(IProcess process) {
        super("", null);
        this.fProcess = process;
        this.setName(this.computeName());
        this.setImageDescriptor(this.computeImageDescriptor());
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    protected void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    protected void init() {
        super.init();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            DebugEvent event = events[i];
            if (!event.getSource().equals(this.getProcess())) continue;
            Runnable r = new Runnable(){

                public void run() {
                    ProcessConsole.this.setName(ProcessConsole.this.computeName());
                    ProcessConsole.this.warnOfContentChange();
                }
            };
            DebugUIPlugin.getStandardDisplay().asyncExec(r);
        }
    }

    private void warnOfContentChange() {
        ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange(DebugUITools.getConsole(this.fProcess));
    }
}

