/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.presentations.ISelfUpdatingAction;

public class SystemMenuPinEditor
extends Action
implements ISelfUpdatingAction {
    private EditorPane editorPane;

    public SystemMenuPinEditor(EditorPane pane) {
        this.setText(WorkbenchMessages.getString("EditorPane.pinEditor"));
        this.setPane(pane);
    }

    public void dispose() {
        this.editorPane = null;
    }

    public void setPane(EditorPane pane) {
        this.editorPane = pane;
        this.update();
    }

    public void run() {
        IWorkbenchPart part = this.editorPane.getPartReference().getPart(true);
        ((EditorSite)part.getSite()).setReuseEditor(this.isChecked());
    }

    public void update() {
        if (this.editorPane == null) {
            this.setEnabled(false);
            return;
        }
        IWorkbenchPart part = this.editorPane.getPartReference().getPart(false);
        if (part == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        this.setChecked(!((EditorSite)part.getSite()).getReuseEditor());
    }

    public boolean shouldBeVisible() {
        if (this.editorPane == null) {
            return false;
        }
        boolean reuseEditor = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
        return reuseEditor;
    }
}

