/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import groovy.lang.Closure;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.jvm.JvmApiSpec;
import org.gradle.jvm.internal.JvmPackageName;
import org.gradle.platform.base.DependencySpecContainer;
import org.gradle.platform.base.internal.DefaultDependencySpecContainer;
import org.gradle.util.ConfigureUtil;

public class DefaultJvmApiSpec
implements JvmApiSpec {
    private final Set<String> exports = new HashSet<String>();
    private final DefaultDependencySpecContainer dependencies = new DefaultDependencySpecContainer();

    @Override
    public void exports(String value) {
        this.validatePackageName(value);
        if (!this.exports.add(value)) {
            throw new InvalidUserDataException(String.format("Invalid public API specification: package '%s' has already been exported", value));
        }
    }

    private void validatePackageName(String value) {
        try {
            JvmPackageName.of(value);
        }
        catch (IllegalArgumentException cause) {
            throw new InvalidUserDataException(String.format("Invalid public API specification: %s", cause.getMessage()), (Throwable)cause);
        }
    }

    @Override
    public Set<String> getExports() {
        return this.exports;
    }

    @Override
    public DependencySpecContainer getDependencies() {
        return this.dependencies;
    }

    @Override
    public void dependencies(Closure<?> configureAction) {
        ConfigureUtil.configure(configureAction, (Object)this.dependencies);
    }
}

