/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.functions.BuiltInFictitiousFunctionClassFactory;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationsImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.BuiltInAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionTypesKt {
    public static final boolean isFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassDescriptor.Kind.Function;
    }

    public static final boolean isSuspendFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassDescriptor.Kind.SuspendFunction;
    }

    public static final boolean isBuiltinFunctionalType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        FunctionClassDescriptor.Kind kind = classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null;
        return kind == FunctionClassDescriptor.Kind.Function || kind == FunctionClassDescriptor.Kind.SuspendFunction;
    }

    public static final boolean isBuiltinExtensionFunctionalType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FunctionTypesKt.isBuiltinFunctionalType($receiver) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(@NotNull KotlinType $receiver) {
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        return annotations2.findAnnotation(fqName2) != null;
    }

    @Nullable
    public static final FunctionClassDescriptor.Kind getFunctionalClassKind(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!($receiver instanceof ClassDescriptor)) {
            return null;
        }
        if (!KotlinBuiltIns.isUnderKotlinPackage($receiver)) {
            return null;
        }
        return FunctionTypesKt.getFunctionalClassKind(DescriptorUtilsKt.getFqNameUnsafe($receiver));
    }

    private static final FunctionClassDescriptor.Kind getFunctionalClassKind(@NotNull FqNameUnsafe $receiver) {
        if (!$receiver.isSafe() || $receiver.isRoot()) {
            return null;
        }
        String string = $receiver.shortName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"shortName().asString()");
        FqName fqName2 = $receiver.toSafe().parent();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"toSafe().parent()");
        return BuiltInFictitiousFunctionClassFactory.Companion.getFunctionalClassKind(string, fqName2);
    }

    @Nullable
    public static final KotlinType getReceiverTypeFromFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($receiver);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver) ? ((TypeProjection)CollectionsKt.first($receiver.getArguments())).getType() : null;
    }

    @NotNull
    public static final KotlinType getReturnTypeFromFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($receiver);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinType kotlinType = ((TypeProjection)CollectionsKt.last($receiver.getArguments())).getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"arguments.last().type");
        return kotlinType;
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(@NotNull KotlinType $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl2 = FunctionTypesKt.isBuiltinFunctionalType($receiver);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Not a function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<TypeProjection> arguments2 = $receiver.getArguments();
        int first = FunctionTypesKt.isBuiltinExtensionFunctionalType($receiver) ? 1 : 0;
        int last = arguments2.size() - 1;
        boolean bl3 = bl = first <= last;
        if (_Assertions.ENABLED && !bl) {
            String string = "Not an exact function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return arguments2.subList(first, last);
    }

    @Nullable
    public static final Name extractParameterNameFromFunctionTypeArgument(@NotNull KotlinType $receiver) {
        Object object;
        Object it;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.parameterName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.parameterName");
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor annotation = annotationDescriptor;
        Object object3 = CollectionsKt.singleOrNull((Iterable)annotation.getAllValueArguments().values());
        if (!(object3 instanceof StringValue)) {
            object3 = null;
        }
        if ((object2 = (StringValue)object3) == null || (object2 = (String)((ConstantValue)object2).getValue()) == null || (object2 = Name.isValidIdentifier((String)(it = (object = object2))) ? object : null) == null) {
            return null;
        }
        Object name = object2;
        return Name.identifier((String)name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkParameterIsNotNull((Object)returnType, (String)"returnType");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>(parameterTypes.size() + (receiverType != null ? 1 : 0) + 1);
        KotlinType kotlinType = receiverType;
        kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull((Collection)arguments2, kotlinType != null ? TypeUtilsKt.asTypeProjection(kotlinType) : null);
        Iterable $receiver$iv = parameterTypes;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            KotlinType kotlinType2;
            void type2;
            List<Name> name;
            List<Name> list;
            List<Name> it;
            void index;
            int n = index$iv++;
            KotlinType kotlinType3 = (KotlinType)item$iv;
            int n2 = n;
            Collection collection = arguments2;
            List<Name> list2 = parameterNames;
            List<Name> list3 = list2 != null && (list2 = list2.get((int)index)) != null ? (!((Name)((Object)(it = (list = list2)))).isSpecial() ? list : null) : (name = null);
            if (name != null) {
                FqName fqName2 = KotlinBuiltIns.FQ_NAMES.parameterName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.parameterName");
                Name name2 = Name.identifier("name");
                String string = ((Name)((Object)name)).asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
                BuiltInAnnotationDescriptor parameterNameAnnotation = new BuiltInAnnotationDescriptor(builtIns, fqName2, MapsKt.mapOf((Pair)TuplesKt.to((Object)name2, (Object)new StringValue(string))));
                kotlinType2 = TypeUtilsKt.replaceAnnotations((KotlinType)type2, new AnnotationsImpl(CollectionsKt.plus((Iterable)type2.getAnnotations(), (Object)parameterNameAnnotation)));
            } else {
                kotlinType2 = type2;
            }
            void typeToUse = kotlinType2;
            TypeProjection typeProjection = TypeUtilsKt.asTypeProjection((KotlinType)typeToUse);
            collection.add(typeProjection);
        }
        arguments2.add(TypeUtilsKt.asTypeProjection(returnType));
        return arguments2;
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    @NotNull
    public static final SimpleType createFunctionType(@NotNull KotlinBuiltIns builtIns, @NotNull Annotations annotations, @Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType, boolean suspendFunction) {
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        Intrinsics.checkParameterIsNotNull((Object)annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkParameterIsNotNull((Object)returnType, (String)"returnType");
        arguments = FunctionTypesKt.getFunctionTypeArgumentProjections(receiverType, parameterTypes, parameterNames, returnType, builtIns);
        size = parameterTypes.size();
        parameterCount = receiverType == null ? size : size + 1;
        v0 = classDescriptor = suspendFunction != false ? builtIns.getSuspendFunction(parameterCount) : builtIns.getFunction(parameterCount);
        if (receiverType == null) ** GOTO lbl-1000
        v1 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        if (annotations.findAnnotation(v1) != null) lbl-1000:
        // 2 sources

        {
            v2 = annotations;
        } else {
            v3 = annotations;
            v4 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
            v2 = new AnnotationsImpl(CollectionsKt.plus((Iterable)v3, (Object)new BuiltInAnnotationDescriptor(builtIns, v4, MapsKt.emptyMap())));
        }
        typeAnnotations = v2;
        v5 = classDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"classDescriptor");
        return KotlinTypeFactory.simpleNotNullType(typeAnnotations, v5, arguments);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ SimpleType createFunctionType$default(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType kotlinType, List list, List list2, KotlinType kotlinType2, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list, list2, kotlinType2, bl);
    }
}

