/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.work.ConditionalExecution;

public class AbstractConditionalExecution<T>
implements ConditionalExecution<T> {
    private final CountDownLatch finished = new CountDownLatch(1);
    private final Runnable runnable;
    private final ResourceLock resourceLock;
    private T result;
    private Throwable failure;

    public AbstractConditionalExecution(final Callable<T> callable, ResourceLock resourceLock) {
        this.runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractConditionalExecution.this.result = callable.call();
                }
                catch (Throwable t) {
                    AbstractConditionalExecution.this.registerFailure(t);
                }
            }
        };
        this.resourceLock = resourceLock;
    }

    @Override
    public ResourceLock getResourceLock() {
        return this.resourceLock;
    }

    @Override
    public Runnable getExecution() {
        return this.runnable;
    }

    @Override
    public T await() {
        try {
            this.finished.await();
            if (this.failure != null) {
                throw UncheckedException.throwAsUncheckedException(this.failure);
            }
            return this.result;
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    @Override
    public void complete() {
        this.finished.countDown();
    }

    @Override
    public boolean isComplete() {
        return this.finished.getCount() == 0L;
    }

    @Override
    public void registerFailure(Throwable t) {
        this.failure = t;
    }
}

