/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.gradle.api.Transformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.serialize.CausePlaceholder;
import org.gradle.internal.serialize.ExceptionReplacingObjectInputStream;
import org.gradle.internal.serialize.ExceptionReplacingObjectOutputStream;
import org.gradle.internal.serialize.PlaceholderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExceptionPlaceholder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionPlaceholder.class);
    private final String type;
    private byte[] serializedException;
    private String message;
    private String toString;
    private ExceptionPlaceholder cause;
    private StackTraceElement[] stackTrace;
    private Throwable toStringRuntimeExec;
    private Throwable getMessageExec;

    public ExceptionPlaceholder(Throwable throwable, Transformer<ExceptionReplacingObjectOutputStream, OutputStream> objectOutputStreamCreator) throws IOException {
        Throwable causeTmp;
        this.type = throwable.getClass().getName();
        try {
            this.stackTrace = throwable.getStackTrace() == null ? new StackTraceElement[]{} : throwable.getStackTrace();
        }
        catch (Throwable ignored) {
            this.stackTrace = new StackTraceElement[0];
        }
        try {
            this.message = throwable.getMessage();
        }
        catch (Throwable failure) {
            this.getMessageExec = failure;
        }
        try {
            this.toString = throwable.toString();
        }
        catch (Throwable failure) {
            this.toStringRuntimeExec = failure;
        }
        try {
            causeTmp = throwable.getCause();
        }
        catch (Throwable ignored) {
            causeTmp = null;
        }
        final Throwable causeFinal = causeTmp;
        StreamByteBuffer buffer = new StreamByteBuffer();
        ExceptionReplacingObjectOutputStream oos = (ExceptionReplacingObjectOutputStream)objectOutputStreamCreator.transform((Object)buffer.getOutputStream());
        oos.setObjectTransformer(new Transformer<Object, Object>(){
            boolean seenFirst;

            public Object transform(Object obj) {
                if (!this.seenFirst) {
                    this.seenFirst = true;
                    return obj;
                }
                if (obj == causeFinal) {
                    return new CausePlaceholder();
                }
                return obj;
            }
        });
        try {
            oos.writeObject(throwable);
            oos.close();
            this.serializedException = buffer.readAsByteArray();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        if (causeFinal != null) {
            this.cause = new ExceptionPlaceholder(causeFinal, objectOutputStreamCreator);
        }
    }

    public Throwable read(Transformer<Class<?>, String> classNameTransformer, Transformer<ExceptionReplacingObjectInputStream, InputStream> objectInputStreamCreator) throws IOException {
        final Throwable causeThrowable = this.getCause(classNameTransformer, objectInputStreamCreator);
        if (this.serializedException != null) {
            ExceptionReplacingObjectInputStream ois = (ExceptionReplacingObjectInputStream)((Object)objectInputStreamCreator.transform((Object)new ByteArrayInputStream(this.serializedException)));
            ois.setObjectTransformer(new Transformer<Object, Object>(){

                public Object transform(Object obj) {
                    if (obj instanceof CausePlaceholder) {
                        return causeThrowable;
                    }
                    return obj;
                }
            });
            try {
                return (Throwable)ois.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable failure) {
                LOGGER.debug("Ignoring failure to de-serialize throwable.", failure);
            }
        }
        try {
            Class clazz = (Class)classNameTransformer.transform((Object)this.type);
            if (clazz != null) {
                Constructor constructor = clazz.getConstructor(String.class);
                Throwable reconstructed = (Throwable)constructor.newInstance(this.message);
                reconstructed.initCause(causeThrowable);
                reconstructed.setStackTrace(this.stackTrace);
                return reconstructed;
            }
        }
        catch (UncheckedException clazz) {
        }
        catch (NoSuchMethodException clazz) {
        }
        catch (Throwable ignored) {
            LOGGER.debug("Ignoring failure to recreate throwable.", ignored);
        }
        PlaceholderException placeholder = new PlaceholderException(this.type, this.message, this.getMessageExec, this.toString, this.toStringRuntimeExec, causeThrowable);
        try {
            placeholder.setStackTrace(this.stackTrace);
        }
        catch (NullPointerException e) {
            this.diagnoseNullPointerException(e);
            throw e;
        }
        return placeholder;
    }

    private void diagnoseNullPointerException(NullPointerException e) {
        StringBuilder sb = new StringBuilder("Malicious stack traces\n");
        for (StackTraceElement element : this.stackTrace) {
            sb.append(element).append("\n");
        }
        LOGGER.error(sb.toString(), (Throwable)e);
    }

    private Throwable getCause(Transformer<Class<?>, String> classNameTransformer, Transformer<ExceptionReplacingObjectInputStream, InputStream> objectInputStreamCreator) throws IOException {
        return this.cause != null ? this.cause.read(classNameTransformer, objectInputStreamCreator) : null;
    }
}

