/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import megamek.client.Client;
import megamek.client.ui.Messages;
import megamek.common.Player;

public class PlayerListDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = 4047664349320678833L;
    private Button butClose = new Button(Messages.getString("PlayerListDialog.Close"));
    private List playerList = new List();
    private Client client;

    public PlayerListDialog(Frame frame, Client client) {
        super(frame, Messages.getString("PlayerListDialog.title"), false);
        this.client = client;
        this.butClose.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.playerList, "North");
        this.add((Component)this.butClose, "South");
        this.refreshPlayerList();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlayerListDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocation(frame.getLocation().x + frame.getSize().width / 2 - this.getSize().width / 2, frame.getLocation().y + frame.getSize().height / 2 - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public static void refreshPlayerList(List list, Client client) {
        list.removeAll();
        Enumeration<Player> enumeration = client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            StringBuffer stringBuffer = new StringBuffer(player.getName());
            if (player.isGhost()) {
                stringBuffer.append(" [");
                stringBuffer.append(Messages.getString("PlayerListDialog.player_ghost"));
                stringBuffer.append("]");
            } else if (player.isObserver()) {
                stringBuffer.append(" [");
                stringBuffer.append(Messages.getString("PlayerListDialog.player_observer"));
                stringBuffer.append("]");
            } else if (player.isDone()) {
                stringBuffer.append(" (");
                stringBuffer.append(Messages.getString("PlayerListDialog.player_done"));
                stringBuffer.append(")");
            }
            list.add(stringBuffer.toString());
        }
    }

    public void refreshPlayerList() {
        PlayerListDialog.refreshPlayerList(this.playerList, this.client);
    }
}

