/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.services;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.DefaultProblemsSummaryProgressDetails;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemEmitter;
import org.gradle.api.problems.internal.ProblemReportCreator;
import org.gradle.api.problems.internal.ProblemSummarizer;
import org.gradle.api.problems.internal.ProblemSummaryData;
import org.gradle.internal.buildoption.IntegerInternalOption;
import org.gradle.internal.buildoption.InternalOption;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.problems.buildtree.ProblemReporter;

public class DefaultProblemSummarizer
implements ProblemSummarizer {
    private final BuildOperationProgressEventEmitter eventEmitter;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final Collection<ProblemEmitter> problemEmitters;
    private final Integer threshold;
    private final ProblemReportCreator problemReportCreator;
    private final ConcurrentMap<ProblemId, Integer> seenProblemsWithCounts = new ConcurrentHashMap<ProblemId, Integer>();
    public static final InternalOption<Integer> THRESHOLD_OPTION = new IntegerInternalOption("org.gradle.internal.problem.summary.threshold", 15);
    public static final int THRESHOLD_DEFAULT_VALUE = (Integer)THRESHOLD_OPTION.getDefaultValue();

    public DefaultProblemSummarizer(BuildOperationProgressEventEmitter eventEmitter, CurrentBuildOperationRef currentBuildOperationRef, Collection<ProblemEmitter> problemEmitters, InternalOptions internalOptions, ProblemReportCreator problemReportCreator) {
        this.eventEmitter = eventEmitter;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.problemEmitters = problemEmitters;
        this.threshold = (Integer)internalOptions.getOption(THRESHOLD_OPTION).get();
        this.problemReportCreator = problemReportCreator;
    }

    public String getId() {
        return "problem summarizer";
    }

    public void report(File reportDir, ProblemReporter.ProblemConsumer validationFailures) {
        List<ProblemSummaryData> cutOffProblems = this.getCutOffProblems();
        this.problemReportCreator.createReportFile(reportDir, cutOffProblems);
        this.eventEmitter.emitNow(this.currentBuildOperationRef.getId(), (Object)new DefaultProblemsSummaryProgressDetails(cutOffProblems));
    }

    private List<ProblemSummaryData> getCutOffProblems() {
        return (List)this.seenProblemsWithCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() > this.threshold).map(entry -> new ProblemSummaryData((ProblemId)entry.getKey(), (Integer)entry.getValue() - this.threshold)).collect(ImmutableList.toImmutableList());
    }

    public void emit(Problem problem, @Nullable OperationIdentifier id) {
        if (this.exceededThreshold(problem)) {
            return;
        }
        this.problemReportCreator.addProblem(problem);
        for (ProblemEmitter problemEmitter : this.problemEmitters) {
            problemEmitter.emit(problem, id);
        }
    }

    private boolean exceededThreshold(Problem problem) {
        int count = this.seenProblemsWithCounts.merge(problem.getDefinition().getId(), 1, Integer::sum);
        return count > this.threshold;
    }
}

