/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content.factset;

import pcgen.base.util.FormatManager;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.GroupDefinition;
import pcgen.cdom.content.factset.FactSetGroup;
import pcgen.cdom.content.factset.FactSetInfo;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.rules.context.LoadContext;

public class FactSetGroupDefinition<T extends CDOMObject, F>
implements GroupDefinition<T> {
    private final FactSetInfo<T, F> def;

    public FactSetGroupDefinition(FactSetInfo<T, F> fsi) {
        if (fsi == null) {
            throw new IllegalArgumentException("Fact Definition cannot be null");
        }
        this.def = fsi;
    }

    @Override
    public String getPrimitiveName() {
        return this.def.getFactSetName();
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    @Override
    public Class<T> getReferenceClass() {
        return this.def.getUsableLocation();
    }

    @Override
    public FormatManager<F> getFormatManager() {
        return this.def.getFormatManager();
    }

    @Override
    public ObjectContainer<T> getPrimitive(LoadContext context, String value) {
        return new FactSetGroup<T, F>(context, this.def, value);
    }
}

