/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.SetFacet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.EquipmentFacet;
import pcgen.cdom.facet.base.AbstractDataFacet;
import pcgen.core.Equipment;
import pcgen.output.publish.OutputDB;

public class EquippedEquipmentFacet
extends AbstractDataFacet<CharID, Equipment>
implements SetFacet<CharID, Equipment> {
    private EquipmentFacet equipmentFacet;

    public void reset(CharID id) {
        Set oldEquipped = (Set)this.removeCache(id);
        Set currentEquipment = this.equipmentFacet.getSet(id);
        WrappedMapSet newEquipped = new WrappedMapSet(IdentityHashMap.class);
        this.setCache(id, newEquipped);
        if (oldEquipped != null) {
            for (Equipment e : oldEquipped) {
                if (currentEquipment.contains(e)) continue;
                this.fireDataFacetChangeEvent(id, e, 1);
            }
        }
        for (Equipment e : currentEquipment) {
            if (e.isEquipped()) {
                newEquipped.add(e);
                if (oldEquipped != null && oldEquipped.contains(e)) continue;
                this.fireDataFacetChangeEvent(id, e, 0);
                continue;
            }
            if (oldEquipped == null || !oldEquipped.contains(e)) continue;
            this.fireDataFacetChangeEvent(id, e, 1);
        }
    }

    @Override
    public Set<Equipment> getSet(CharID id) {
        Set set = (Set)this.getCache(id);
        if (set == null) {
            return Collections.emptySet();
        }
        WrappedMapSet returnEquipped = new WrappedMapSet(IdentityHashMap.class);
        returnEquipped.addAll(set);
        return returnEquipped;
    }

    @Override
    public int getCount(CharID id) {
        Set set = (Set)this.getCache(id);
        return set == null ? 0 : set.size();
    }

    public void setEquipmentFacet(EquipmentFacet equipmentFacet) {
        this.equipmentFacet = equipmentFacet;
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        Set set = (Set)this.getCache(source);
        if (set != null) {
            WrappedMapSet newEquipped = new WrappedMapSet(IdentityHashMap.class);
            newEquipped.addAll(set);
            this.setCache(copy, newEquipped);
        }
    }

    public void removeAll(CharID id) {
        this.removeCache(id);
    }

    public void init() {
        OutputDB.register("equipment.equipped", this);
    }
}

