/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.core.PCClass;
import pcgen.core.Skill;

public class SkillRankFacet
extends AbstractStorageFacet<CharID> {
    private SkillRankChangeSupport support = new SkillRankChangeSupport();

    private Map<Skill, Map<PCClass, Double>> getConstructingInfo(CharID id) {
        Map<Skill, Map<PCClass, Double>> map = this.getInfo(id);
        if (map == null) {
            map = new HashMap<Skill, Map<PCClass, Double>>();
            this.setCache(id, map);
        }
        return map;
    }

    private Map<Skill, Map<PCClass, Double>> getInfo(CharID id) {
        return (Map)this.getCache(id);
    }

    public void set(CharID id, Skill skill, PCClass pcc, double value) {
        if (skill == null) {
            throw new IllegalArgumentException("Skill cannot be null in add");
        }
        Float oldRank = Float.valueOf(this.getRank(id, skill));
        Map<Skill, Map<PCClass, Double>> map = this.getConstructingInfo(id);
        Map<PCClass, Double> clMap = map.get(skill);
        if (clMap == null) {
            clMap = new IdentityHashMap<PCClass, Double>();
            map.put(skill, clMap);
        }
        clMap.put(pcc, value);
        Float newRank = Float.valueOf(this.getRank(id, skill));
        this.support.fireSkillRankChangeEvent(id, skill, oldRank.floatValue(), newRank.floatValue());
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        Map<Skill, Map<PCClass, Double>> map = this.getInfo(source);
        if (map != null) {
            for (Map.Entry<Skill, Map<PCClass, Double>> fme : map.entrySet()) {
                Skill sk = fme.getKey();
                for (Map.Entry<PCClass, Double> clEntry : fme.getValue().entrySet()) {
                    this.set(copy, sk, clEntry.getKey(), clEntry.getValue());
                }
            }
        }
    }

    public Collection<PCClass> getClasses(CharID id, Skill sk) {
        Map<Skill, Map<PCClass, Double>> map = this.getInfo(id);
        if (map == null) {
            return Collections.emptyList();
        }
        Map<PCClass, Double> clMap = map.get(sk);
        if (clMap == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableSet(clMap.keySet());
    }

    public Double get(CharID id, Skill sk, PCClass pcc) {
        Map<Skill, Map<PCClass, Double>> map = this.getInfo(id);
        if (map == null) {
            return null;
        }
        Map<PCClass, Double> clMap = map.get(sk);
        if (clMap == null) {
            return null;
        }
        return clMap.get(pcc);
    }

    public void remove(CharID id, Skill sk, PCClass pcc) {
        Map<PCClass, Double> clMap;
        if (sk == null) {
            throw new IllegalArgumentException("Skill cannot be null in remove");
        }
        Map<Skill, Map<PCClass, Double>> map = this.getInfo(id);
        if (map != null && (clMap = map.get(sk)) != null) {
            Float oldRank = Float.valueOf(this.getRank(id, sk));
            clMap.remove(pcc);
            Float newRank = Float.valueOf(this.getRank(id, sk));
            this.support.fireSkillRankChangeEvent(id, sk, oldRank.floatValue(), newRank.floatValue());
        }
    }

    public float getRank(CharID id, Skill sk) {
        Map<PCClass, Double> clMap;
        double rank = 0.0;
        Map<Skill, Map<PCClass, Double>> map = this.getInfo(id);
        if (map != null && (clMap = map.get(sk)) != null) {
            for (Double d : clMap.values()) {
                rank += d.doubleValue();
            }
        }
        return (float)rank;
    }

    public void addSkillRankChangeListener(SkillRankChangeListener listener) {
        this.support.addLevelChangeListener(listener);
    }

    public static class SkillRankChangeSupport {
        private final EventListenerList listenerList = new EventListenerList();

        public void addLevelChangeListener(SkillRankChangeListener listener) {
            this.listenerList.add(SkillRankChangeListener.class, listener);
        }

        public synchronized SkillRankChangeListener[] getLevelChangeListeners() {
            return (SkillRankChangeListener[])this.listenerList.getListeners(SkillRankChangeListener.class);
        }

        public void removeLevelChangeListener(SkillRankChangeListener listener) {
            this.listenerList.remove(SkillRankChangeListener.class, listener);
        }

        protected void fireSkillRankChangeEvent(CharID id, Skill sk, float oldRank, float newRank) {
            if (oldRank == newRank) {
                return;
            }
            SkillRankChangeListener[] listeners = (SkillRankChangeListener[])this.listenerList.getListeners(SkillRankChangeListener.class);
            SkillRankChangeEvent ccEvent = null;
            for (int i = listeners.length - 1; i >= 0; --i) {
                if (ccEvent == null) {
                    ccEvent = new SkillRankChangeEvent(id, sk, oldRank, newRank);
                }
                listeners[i].rankChanged(ccEvent);
            }
        }
    }

    public static class SkillRankChangeEvent
    extends EventObject {
        private final CharID charID;
        private final Skill skill;
        private final float oldRnk;
        private final float newRnk;

        public SkillRankChangeEvent(CharID source, Skill sk, float oldRank, float newRank) {
            super(source);
            if (source == null) {
                throw new IllegalArgumentException("CharID cannot be null");
            }
            if (sk == null) {
                throw new IllegalArgumentException("PCClass cannot be null");
            }
            this.charID = source;
            this.skill = sk;
            this.oldRnk = oldRank;
            this.newRnk = newRank;
        }

        public CharID getCharID() {
            return this.charID;
        }

        public Skill getSkill() {
            return this.skill;
        }

        public float getOldRank() {
            return this.oldRnk;
        }

        public float getNewRank() {
            return this.newRnk;
        }
    }

    public static interface SkillRankChangeListener
    extends EventListener {
        public void rankChanged(SkillRankChangeEvent var1);
    }
}

