/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.Map;
import java.util.Set;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.SpellResistance;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;

public class CharacterSpellResistanceFacet
extends AbstractSourcedListFacet<CharID, Formula>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private FormulaResolvingFacet formulaResolvingFacet;
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        SpellResistance sr = cdo.get(ObjectKey.SR);
        if (sr != null) {
            this.add(dfce.getCharID(), sr.getReduction(), cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public int getSR(CharID id) {
        Map componentMap = this.getCachedMap(id);
        int sr = 0;
        if (componentMap != null) {
            for (Map.Entry me : componentMap.entrySet()) {
                Formula f = (Formula)me.getKey();
                Set<Object> sourceSet = me.getValue();
                for (Object source : sourceSet) {
                    String sourceString = source instanceof CDOMObject ? ((CDOMObject)source).getQualifiedKey() : "";
                    sr = Math.max(sr, this.formulaResolvingFacet.resolve(id, f, sourceString).intValue());
                }
            }
        }
        return sr;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }
}

