/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import pcgen.base.lang.UnreachableError;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.reference.CDOMAllRef;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSimpleSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CDOMTypeRef;
import pcgen.cdom.reference.ManufacturableFactory;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.util.Logging;

public class CDOMFactory<T extends Loadable>
implements ManufacturableFactory<T> {
    private final Class<T> refClass;

    public CDOMFactory(Class<T> objClass) {
        if (objClass == null) {
            throw new IllegalArgumentException("Reference Class for " + this.getClass().getName() + " cannot be null");
        }
        try {
            objClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Class for " + this.getClass().getName() + " must possess a zero-argument constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class for " + this.getClass().getName() + " must possess a public zero-argument constructor", e);
        }
        this.refClass = objClass;
    }

    @Override
    public CDOMGroupRef<T> getAllReference() {
        return new CDOMAllRef<T>(this.refClass);
    }

    @Override
    public CDOMGroupRef<T> getTypeReference(String ... types) {
        return new CDOMTypeRef<T>(this.refClass, types);
    }

    @Override
    public CDOMSingleRef<T> getReference(String key) {
        return new CDOMSimpleSingleRef<T>(this.refClass, key);
    }

    @Override
    public T newInstance() {
        try {
            return (T)((Loadable)this.refClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new UnreachableError("Class was tested at construction to ensure it had a public, zero-argument constructor");
        }
        catch (IllegalAccessException e) {
            throw new UnreachableError("Class was tested at construction to ensure it had a public, zero-argument constructor");
        }
    }

    @Override
    public boolean isMember(T item) {
        return this.refClass.equals(item.getClass());
    }

    @Override
    public Class<T> getReferenceClass() {
        return this.refClass;
    }

    @Override
    public String getReferenceDescription() {
        return this.refClass.getSimpleName();
    }

    @Override
    public boolean resolve(ReferenceManufacturer<T> rm, String name, CDOMSingleRef<T> value, UnconstructedValidator validator) {
        boolean returnGood = true;
        T activeObj = rm.getObject(name);
        if (activeObj == null) {
            if (name.charAt(0) != '*' && !this.report(validator, name)) {
                Logging.errorPrint("Unconstructed Reference: " + this.getReferenceDescription() + " " + name);
                rm.fireUnconstuctedEvent(value);
                returnGood = false;
            }
            activeObj = rm.buildObject(name);
        }
        value.addResolution(activeObj);
        return returnGood;
    }

    private boolean report(UnconstructedValidator validator, String key) {
        return validator != null && validator.allow(this.getReferenceClass(), key);
    }

    @Override
    public boolean populate(ReferenceManufacturer<T> parentCrm, ReferenceManufacturer<T> rm, UnconstructedValidator validator) {
        return true;
    }

    @Override
    public ManufacturableFactory<T> getParent() {
        return null;
    }
}

