/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.rules.context.LoadContext;

public class PCClassKeyChange {
    public static void changeReferences(String oldClass, PCClass pcc) {
        String newClass = pcc.getKeyName();
        if (oldClass.equals(newClass)) {
            return;
        }
        PCClassKeyChange.renameVariables(oldClass, pcc, newClass);
        PCClassKeyChange.renameBonusTarget(pcc, oldClass, newClass);
        for (PCClassLevel pcl : pcc.getOriginalClassLevelCollection()) {
            PCClassKeyChange.renameVariables(oldClass, pcl, newClass);
            PCClassKeyChange.renameBonusTarget(pcl, oldClass, newClass);
        }
    }

    private static void renameVariables(String oldClass, CDOMObject pcc, String newClass) {
        for (VariableKey vk : pcc.getVariableKeys()) {
            pcc.put(vk, FormulaFactory.getFormulaFor(pcc.get(vk).toString().replaceAll("=" + oldClass, "=" + newClass)));
        }
    }

    private static void renameBonusTarget(CDOMObject cdo, String oldClass, String newClass) {
        List<BonusObj> bonusList = cdo.getListFor(ListKey.BONUS);
        if (bonusList != null) {
            for (BonusObj bonusObj : bonusList) {
                String bonus = bonusObj.toString();
                int offs = -1;
                while ((offs = bonus.indexOf('=' + oldClass, offs + 1)) >= 0) {
                    LoadContext context = Globals.getContext();
                    BonusObj aBonus = Bonus.newBonus(context, bonus.substring(0, offs + 1) + newClass + bonus.substring(offs + oldClass.length() + 1));
                    if (aBonus != null) {
                        cdo.addToListFor(ListKey.BONUS, aBonus);
                    }
                    cdo.removeFromListFor(ListKey.BONUS, bonusObj);
                }
            }
        }
    }
}

