/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.display;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusPair;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Delta;

public class SkillCostDisplay {
    public static String getModifierExplanation(Skill sk, PlayerCharacter aPC, boolean shortForm) {
        double bonusObjTotal = 0.0;
        ArrayList<String> explanation = new ArrayList<String>();
        String keyName = sk.getKeyName();
        String bonusKey = ("SKILL." + keyName).toUpperCase();
        for (BonusObj bonus : aPC.getActiveBonusList()) {
            if (!aPC.isApplied(bonus) || !"SKILL".equals(bonus.getBonusName())) continue;
            boolean include = SkillCostDisplay.bonusForThisSkill(bonus, keyName);
            if (!include) {
                for (BonusPair bp : aPC.getStringListFromBonus(bonus)) {
                    String bpKey = bp.fullyQualifiedBonusType.toUpperCase();
                    if (!bpKey.equals(bonusKey)) continue;
                    include = true;
                    break;
                }
            }
            if (!include) continue;
            double iBonus = 0.0;
            for (BonusPair bp : aPC.getStringListFromBonus(bonus)) {
                String bpKey = bp.fullyQualifiedBonusType.toUpperCase();
                if (!bpKey.startsWith(bonusKey)) continue;
                iBonus += bp.resolve(aPC).doubleValue();
            }
            if (CoreUtility.doublesEqual(iBonus, 0.0)) continue;
            explanation.add(Delta.toString((int)iBonus) + aPC.getBonusContext(bonus, shortForm));
            bonusObjTotal += iBonus;
        }
        StringBuilder bonusDetails = new StringBuilder();
        bonusDetails.append((CharSequence)StringUtil.joinToStringBuilder(explanation, (String)" "));
        CDOMSingleRef<PCStat> statref = sk.get(ObjectKey.KEY_STAT);
        if (statref != null) {
            PCStat stat = statref.resolvesTo();
            double bonus = aPC.getStatModFor(stat);
            SkillCostDisplay.appendBonusDesc(bonusDetails, bonus += aPC.getTotalBonusTo("SKILL", "STAT." + stat.getKeyName()), "STAT");
        }
        double bonus = aPC.getTotalBonusTo("SKILL", keyName) - bonusObjTotal;
        SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "OTHER");
        for (Type singleType : sk.getTrueTypeList(false)) {
            bonus = aPC.getTotalBonusTo("SKILL", "TYPE." + singleType);
            SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "TYPE." + singleType);
        }
        bonus = aPC.getTotalBonusTo("SKILL", "LIST");
        SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "LIST");
        bonus = aPC.getTotalBonusTo("SKILL", "ALL");
        SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "ALL");
        if (aPC.isClassSkill(sk)) {
            bonus = aPC.getTotalBonusTo("CSKILL", keyName);
            SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "CSKILL");
            for (Type singleType : sk.getTrueTypeList(false)) {
                bonus = aPC.getTotalBonusTo("CSKILL", "TYPE." + singleType);
                SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "CSKILL");
            }
            bonus = aPC.getTotalBonusTo("CSKILL", "LIST");
            SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "CSKILL");
        }
        if (!aPC.isClassSkill(sk) && !sk.getSafe(ObjectKey.EXCLUSIVE).booleanValue()) {
            bonus = aPC.getTotalBonusTo("CCSKILL", keyName);
            SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "CCSKILL");
            for (Type singleType : sk.getTrueTypeList(false)) {
                bonus = aPC.getTotalBonusTo("CCSKILL", "TYPE." + singleType);
                SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "CCSKILL");
            }
            bonus = aPC.getTotalBonusTo("CCSKILL", "LIST");
            SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "CCSKILL");
        }
        int aCheckMod = sk.getSafe(ObjectKey.ARMOR_CHECK).calculateBonus(aPC);
        SkillCostDisplay.appendBonusDesc(bonusDetails, aCheckMod, "ARMOR");
        String aString = SettingsHandler.getGame().getRankModFormula();
        if (aString.length() != 0) {
            aString = aString.replaceAll(Pattern.quote("$$RANK$$"), SkillRankControl.getTotalRank(aPC, sk).toString());
            bonus = aPC.getVariableValue(aString, "").intValue();
            SkillCostDisplay.appendBonusDesc(bonusDetails, bonus, "RANKS");
        }
        return bonusDetails.toString();
    }

    private static boolean bonusForThisSkill(BonusObj bonus, String keyName) {
        for (Object target : bonus.getBonusInfoList()) {
            if (!String.valueOf(target).equalsIgnoreCase(keyName)) continue;
            return true;
        }
        return false;
    }

    public static String getSituationModifierExplanation(Skill sk, String situation, PlayerCharacter aPC, boolean shortForm) {
        ArrayList<String> explanation = new ArrayList<String>();
        String keyName = sk.getKeyName();
        String bonusKey = ("SITUATION." + keyName + "=" + situation).toUpperCase();
        for (BonusObj bonus : aPC.getActiveBonusList()) {
            if (!aPC.isApplied(bonus) || !"SITUATION".equals(bonus.getBonusName())) continue;
            boolean include = SkillCostDisplay.bonusForThisSkill(bonus, keyName);
            if (!include) {
                for (BonusPair bp : aPC.getStringListFromBonus(bonus)) {
                    String bpKey = bp.fullyQualifiedBonusType.toUpperCase();
                    if (!bpKey.equals(bonusKey)) continue;
                    include = true;
                    break;
                }
            }
            if (!include) continue;
            double iBonus = 0.0;
            for (BonusPair bp : aPC.getStringListFromBonus(bonus)) {
                String bpKey = bp.fullyQualifiedBonusType.toUpperCase();
                if (!bpKey.startsWith(bonusKey)) continue;
                iBonus += bp.resolve(aPC).doubleValue();
            }
            if (CoreUtility.doublesEqual(iBonus, 0.0)) continue;
            explanation.add(Delta.toString((int)iBonus) + aPC.getBonusContext(bonus, shortForm));
        }
        return StringUtil.join(explanation, (String)" ");
    }

    public static void appendBonusDesc(StringBuilder bonusDetails, double bonus, String description) {
        String value;
        if (CoreUtility.doublesEqual(bonus, 0.0)) {
            return;
        }
        if (bonusDetails.length() > 0) {
            bonusDetails.append(' ');
        }
        if ((value = Delta.toString((float)bonus)).endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        bonusDetails.append(value);
        bonusDetails.append('[').append(description).append(']');
    }

    public static String getRanksExplanation(PlayerCharacter pc, Skill sk) {
        StringBuilder sb = new StringBuilder(100);
        boolean needComma = false;
        for (PCClass pcc : pc.getSkillRankClasses(sk)) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append(pcc == null ? "None" : pcc.getKeyName());
            sb.append(':');
            Double rank = pc.getSkillRankForClass(sk, pcc);
            sb.append(rank == null ? 0.0 : rank);
            needComma = true;
        }
        double bonus = SkillRankControl.getSkillRankBonusTo(pc, sk);
        if (bonus != 0.0) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append("Skillrank bonus ");
            sb.append(NumberFormat.getNumberInstance().format(bonus));
        }
        return sb.toString();
    }
}

