/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public abstract class AbstractPrerequisiteTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, PlayerCharacter character, CDOMObject source) throws PrerequisiteException {
        String name = this.getClass().getName();
        String eString = LanguageBundle.getFormattedString("prereq.error.does_not_support_characters", name);
        throw new PrerequisiteException(eString);
    }

    @Override
    public int passes(Prerequisite prereq, Equipment equipment, PlayerCharacter character) throws PrerequisiteException {
        if (character == null) {
            String name = this.getClass().getName();
            String eString = LanguageBundle.getFormattedString("prereq.error.does_not_support_equipment", name);
            throw new PrerequisiteException(eString);
        }
        return this.passes(prereq, character, equipment);
    }

    protected int countedTotal(Prerequisite prereq, int runningTotal) {
        if (prereq.isCountMultiples() || prereq.isTotalValues()) {
            return runningTotal;
        }
        return runningTotal > 0 ? 1 : 0;
    }

    @Override
    public String toHtmlString(Prerequisite prereq) {
        return LanguageBundle.getFormattedString("AbstractPrerequisiteTest.toHtml", prereq.getKind(), prereq.getKey(), prereq.getOperator().toDisplayString(), prereq.getOperand());
    }
}

