/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.reference.CDOMFactory;
import pcgen.cdom.reference.ManufacturableFactory;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.SimpleReferenceManufacturer;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class RuntimeReferenceContext
extends AbstractReferenceContext {
    private final Map<Class<?>, ReferenceManufacturer<?>> map = new HashMap();
    private final Map<ManufacturableFactory<?>, ReferenceManufacturer<?>> mfgmap = new HashMap();

    @Override
    public <T extends Loadable> ReferenceManufacturer<T> getManufacturer(Class<T> cl) {
        if (Categorized.class.isAssignableFrom(cl)) {
            throw new InternalError(cl + " is categorized but was fetched without a category");
        }
        ReferenceManufacturer<?> mfg = this.map.get(cl);
        if (mfg == null) {
            mfg = new SimpleReferenceManufacturer(new CDOMFactory<T>(cl));
            this.map.put(cl, mfg);
        }
        return mfg;
    }

    public Collection<ReferenceManufacturer<?>> getAllManufacturers() {
        ArrayList returnList = new ArrayList(this.map.values());
        returnList.addAll(this.mfgmap.values());
        return returnList;
    }

    @Override
    public <T extends Categorized<T>> ReferenceManufacturer<T> getManufacturer(Class<T> cl, Category<T> cat) {
        if (cat == null) {
            ReferenceManufacturer<?> mfg = this.map.get(cl);
            if (mfg == null) {
                mfg = new SimpleReferenceManufacturer(new CDOMFactory<T>(cl));
                this.map.put(cl, mfg);
            }
            return mfg;
        }
        return this.getManufacturer(cat);
    }

    @Override
    public <T extends Loadable> ReferenceManufacturer<T> getManufacturer(ManufacturableFactory<T> factory) {
        ReferenceManufacturer<?> rm = this.mfgmap.get(factory);
        if (rm == null) {
            rm = new SimpleReferenceManufacturer(factory);
            this.mfgmap.put(factory, rm);
        }
        return rm;
    }

    @Override
    public <T extends Categorized<T>> ReferenceManufacturer<T> getManufacturer(Class<T> cl, Class<? extends Category<T>> catClass, String category) {
        Category<T> cat = this.silentlyGetConstructedCDOMObject(catClass, category);
        if (cat == null) {
            Logging.errorPrint("Cannot find " + cl.getSimpleName() + " Category " + category);
            return null;
        }
        return this.getManufacturer(cl, cat);
    }

    @Override
    <T extends CDOMObject> T performCopy(T object, String copyName) {
        try {
            CDOMObject clone = object.clone();
            clone.setName(copyName);
            clone.put(StringKey.KEY_NAME, copyName);
            this.importObject(clone);
            return (T)clone;
        }
        catch (CloneNotSupportedException e) {
            String message = LanguageBundle.getFormattedString("Errors.LstFileLoader.CopyNotSupported", object.getClass().getName(), object.getKeyName(), copyName);
            Logging.errorPrint(message);
            return null;
        }
    }

    @Override
    public <T extends CDOMObject> T performMod(T obj) {
        return obj;
    }

    @Override
    public <T extends Loadable> boolean hasManufacturer(Class<T> cl) {
        return this.map.containsKey(cl);
    }

    @Override
    protected <T extends Categorized<T>> boolean hasManufacturer(Class<T> cl, Category<T> cat) {
        if (cat == null) {
            return this.map.containsKey(cl);
        }
        return this.mfgmap.containsKey(cat);
    }
}

