/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import pcgen.base.lang.CaseInsensitiveString;
import pcgen.base.lang.UnreachableError;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.TripleKeyMap;
import pcgen.cdom.base.GroupDefinition;
import pcgen.cdom.base.Loadable;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.CDOMSubToken;
import pcgen.rules.persistence.token.CDOMToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.util.Revision;
import pcgen.util.Logging;

public final class TokenFamily
implements Comparable<TokenFamily> {
    public static final TokenFamily CURRENT = new TokenFamily(new Revision(Integer.MAX_VALUE, 0, 0));
    public static final TokenFamily REV514 = new TokenFamily(new Revision(5, 14, Integer.MIN_VALUE));
    private static SortedMap<Revision, TokenFamily> typeMap;
    private final Revision rev;
    private final DoubleKeyMap<Class<?>, String, CDOMToken<?>> tokenMap = new DoubleKeyMap();
    private final TripleKeyMap<Class<?>, String, String, CDOMSecondaryToken<?>> subTokenMap = new TripleKeyMap(HashMap.class, CaseInsensitiveMap.class, CaseInsensitiveMap.class);
    private final Map<CaseInsensitiveString, PrerequisiteParserInterface> preTokenMap = new HashMap<CaseInsensitiveString, PrerequisiteParserInterface>();
    private final List<DeferredToken<? extends Loadable>> deferredTokenList = new ArrayList<DeferredToken<? extends Loadable>>();
    private final DoubleKeyMap<Class<?>, String, GroupDefinition<?>> groupDefinitionMap = new DoubleKeyMap(HashMap.class, CaseInsensitiveMap.class);

    public TokenFamily(Revision r) {
        this.rev = r;
    }

    public <T> CDOMToken<T> putToken(CDOMToken<T> tok) {
        if (tok.getTokenClass() == null) {
            Logging.errorPrint("Cannot load token " + tok.getClass().getSimpleName() + " with no token class");
        }
        return (CDOMToken)this.tokenMap.put(tok.getTokenClass(), (Object)tok.getTokenName(), tok);
    }

    public CDOMToken<?> getToken(Class<?> cl, String name) {
        return (CDOMToken)this.tokenMap.get(cl, (Object)name);
    }

    public Set<CDOMToken<?>> getTokens(Class<?> cl) {
        return this.tokenMap.values(cl);
    }

    public <U, T extends CDOMSecondaryToken<U>> CDOMSecondaryToken<U> putSubToken(T tok) {
        if (tok.getTokenClass() == null) {
            Logging.errorPrint("Cannot load token " + tok.getClass().getSimpleName() + " with no token class");
        }
        return (CDOMSecondaryToken)this.subTokenMap.put(tok.getTokenClass(), (Object)tok.getParentToken(), (Object)tok.getTokenName(), tok);
    }

    public <T> CDOMSubToken<? super T> getSubToken(Class<? extends T> cl, String token, String key) {
        return (CDOMSubToken)this.subTokenMap.get(cl, (Object)token, (Object)key);
    }

    public <T> Set<CDOMSecondaryToken<? super T>> getSubTokens(Class<? super T> cl, String token) {
        return this.subTokenMap.values(cl, (Object)token);
    }

    public void putPrerequisiteToken(PrerequisiteParserInterface token) {
        for (String s : token.kindsHandled()) {
            this.preTokenMap.put(new CaseInsensitiveString(s), token);
        }
    }

    public PrerequisiteParserInterface getPrerequisiteToken(String key) {
        return this.preTokenMap.get(new CaseInsensitiveString(key));
    }

    public static TokenFamily getConstant(int primary, int secondary, int tertiary) {
        Revision r;
        TokenFamily o;
        if (typeMap == null) {
            TokenFamily.buildMap();
        }
        if ((o = (TokenFamily)typeMap.get(r = new Revision(primary, secondary, tertiary))) == null) {
            o = new TokenFamily(r);
            typeMap.put(r, o);
        }
        return o;
    }

    private static void buildMap() {
        typeMap = new TreeMap<Revision, TokenFamily>();
        Class<TokenFamily> cl = TokenFamily.class;
        Field[] fields = cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod) || !Modifier.isPublic(mod)) continue;
            try {
                Object o = fields[i].get(null);
                if (!cl.equals(o.getClass())) continue;
                TokenFamily tObj = (TokenFamily)cl.cast(o);
                if (typeMap.containsKey(tObj.rev)) {
                    throw new UnreachableError("Attempt to redefine constant value " + tObj.rev + " to " + fields[i].getName() + ", value was " + typeMap.get(tObj.rev));
                }
                typeMap.put(tObj.rev, tObj);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new UnreachableError("Attempt to fetch field failed: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new UnreachableError("Attempt to fetch field failed for access: " + e.getMessage());
            }
        }
    }

    public static void clearConstants() {
        TokenFamily.buildMap();
    }

    public static Collection<TokenFamily> getAllConstants() {
        return Collections.unmodifiableCollection(typeMap.values());
    }

    @Override
    public int compareTo(TokenFamily tf) {
        return this.rev.compareTo(tf.rev);
    }

    public String toString() {
        return "Token Family: " + this.rev.toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TokenFamily && this.compareTo((TokenFamily)obj) == 0;
    }

    public int hashCode() {
        return this.rev.hashCode();
    }

    public void clearTokens() {
        this.tokenMap.clear();
        this.subTokenMap.clear();
        this.deferredTokenList.clear();
        this.preTokenMap.clear();
    }

    public List<DeferredToken<? extends Loadable>> getDeferredTokens() {
        return new ArrayList<DeferredToken<? extends Loadable>>(this.deferredTokenList);
    }

    public void addDeferredToken(DeferredToken<?> newToken) {
        this.deferredTokenList.add(newToken);
    }

    public void addGroupDefinition(GroupDefinition<?> def) {
        GroupDefinition existingDef = (GroupDefinition)this.groupDefinitionMap.put(def.getReferenceClass(), (Object)def.getPrimitiveName(), def);
        if (existingDef != null) {
            Logging.errorPrint("Duplicate Group Definition in " + def.getReferenceClass().getSimpleName() + ": " + def.getPrimitiveName() + ". Classes were " + existingDef.getClass().getName() + " and " + def.getClass().getName());
        }
    }

    public <T> GroupDefinition<T> getGroup(Class<T> cl, String name) {
        return (GroupDefinition)this.groupDefinitionMap.get(cl, (Object)name);
    }
}

