/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.equipment;

import java.util.Collection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.enumeration.EqWield;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.PrimitiveToken;
import pcgen.util.Logging;

public class WieldCategoryToken
implements PrimitiveToken<Equipment>,
PrimitiveFilter<Equipment> {
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;
    private EqWield category;
    private CDOMReference<Equipment> allEquipment;

    public boolean initialize(LoadContext context, Class<Equipment> cl, String value, String args) {
        if (args != null) {
            return false;
        }
        if ("Light".equalsIgnoreCase(value)) {
            this.category = EqWield.Light;
        } else if ("1 handed".equalsIgnoreCase(value)) {
            this.category = EqWield.OneHanded;
        } else if ("2 handed".equalsIgnoreCase(value)) {
            this.category = EqWield.TwoHanded;
        } else if ("onehanded".equalsIgnoreCase(value)) {
            this.category = EqWield.OneHanded;
        } else if ("twohanded".equalsIgnoreCase(value)) {
            this.category = EqWield.TwoHanded;
        } else {
            Logging.errorPrint((String)("Unable to understand Wield Category: " + value));
            return false;
        }
        this.allEquipment = context.getReferenceContext().getCDOMAllReference(EQUIPMENT_CLASS);
        return true;
    }

    public String getTokenName() {
        return "WIELD";
    }

    public Class<Equipment> getReferenceClass() {
        return EQUIPMENT_CLASS;
    }

    public String getLSTformat(boolean useAny) {
        return "WIELD=" + this.category;
    }

    public boolean allow(PlayerCharacter pc, Equipment eq) {
        return this.category.checkWield(pc, eq);
    }

    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WieldCategoryToken) {
            WieldCategoryToken other = (WieldCategoryToken)obj;
            return this.category.equals((Object)other.category);
        }
        return false;
    }

    public int hashCode() {
        return this.category == null ? -13 : this.category.hashCode();
    }

    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Equipment, R> c) {
        return c.convert(this.allEquipment, (PrimitiveFilter)this);
    }
}

