/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildconfiguration.tasks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.internal.buildconfiguration.tasks.UpdateDaemonJvmModifier;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.util.internal.IncubationLogger;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
@Incubating
public abstract class UpdateDaemonJvm
extends DefaultTask {
    @Inject
    public UpdateDaemonJvm() {
    }

    @TaskAction
    void generate() {
        IncubationLogger.incubatingFeatureUsed((String)"Daemon JVM criteria");
        String jvmVendor = this.getJvmVendor().isPresent() ? (String)this.getJvmVendor().get() : null;
        UpdateDaemonJvmModifier.updateJvmCriteria(((RegularFile)this.getPropertiesFile().get()).getAsFile(), (JavaVersion)this.getJvmVersion().get(), jvmVendor, null);
    }

    @OutputFile
    @Incubating
    public abstract RegularFileProperty getPropertiesFile();

    @Input
    @Optional
    @Option(option="jvm-version", description="The version of the JVM required to run the Gradle Daemon.")
    @Incubating
    public abstract Property<JavaVersion> getJvmVersion();

    @Input
    @Optional
    @Incubating
    @Option(option="jvm-vendor", description="The vendor of the JVM required to run the Gradle Daemon.")
    public abstract Property<String> getJvmVendor();

    @OptionValues(value={"jvm-vendor"})
    public List<String> getAvailableVendors() {
        return Arrays.stream(JvmVendor.KnownJvmVendor.values()).filter(e -> e != JvmVendor.KnownJvmVendor.UNKNOWN).map(Enum::name).collect(Collectors.toList());
    }
}

