/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl.messages;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.messages.DiagnosticMessageHolder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016R6\u0010\u0004\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/messages/IdeDiagnosticMessageHolder;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/messages/DiagnosticMessageHolder;", "<init>", "()V", "diagnostics", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "", "Lkotlin/collections/ArrayList;", "report", "", "diagnostic", "file", "Lcom/intellij/psi/PsiFile;", "render", "renderMessage", "kotlin-scripting-compiler"})
public final class IdeDiagnosticMessageHolder
implements DiagnosticMessageHolder {
    @NotNull
    private final ArrayList<Pair<Diagnostic, String>> diagnostics = new ArrayList();

    public void report(@NotNull Diagnostic diagnostic, @NotNull PsiFile file, @NotNull String render) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)render, (String)"render");
        this.diagnostics.add((Pair<Diagnostic, String>)new Pair((Object)diagnostic, (Object)render));
    }

    @Override
    @NotNull
    public String renderMessage() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document errorReport = docBuilder.newDocument();
        Element rootElement = errorReport.createElement("report");
        errorReport.appendChild(rootElement);
        Iterator<Pair<Diagnostic, String>> iterator = this.diagnostics.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Pair<Diagnostic, String>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            TextRange errorRange;
            Pair<Diagnostic, String> pair;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
            Diagnostic diagnostic = (Diagnostic)pair.component1();
            String message = (String)pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)DiagnosticUtils.firstRange((List)diagnostic.getTextRanges()), (String)"firstRange(...)");
            Element reportEntry = errorReport.createElement("reportEntry");
            reportEntry.setAttribute("severity", diagnostic.getSeverity().toString());
            reportEntry.setAttribute("rangeStart", String.valueOf(errorRange.getStartOffset()));
            reportEntry.setAttribute("rangeEnd", String.valueOf(errorRange.getEndOffset()));
            reportEntry.appendChild(errorReport.createTextNode(StringUtil.escapeXmlEntities((String)message)));
            rootElement.appendChild(reportEntry);
        }
        DOMImplementation dOMImplementation = errorReport.getImplementation();
        Intrinsics.checkNotNull((Object)dOMImplementation, (String)"null cannot be cast to non-null type org.w3c.dom.ls.DOMImplementationLS");
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)dOMImplementation);
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        String string = lsSerializer.writeToString(errorReport);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeToString(...)");
        return string;
    }
}

