/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.inject.Inject;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.coverage.CoverageAccumulator;
import com.google.jstestdriver.coverage.CoverageWriter;
import com.google.jstestdriver.model.RunData;
import com.google.jstestdriver.output.TestResultHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverageReporterAction
implements Action {
    private static final Logger logger = LoggerFactory.getLogger(CoverageReporterAction.class);
    private final CoverageAccumulator accumulator;
    private final CoverageWriter writer;
    private final TestResultHolder holder;

    @Inject
    public CoverageReporterAction(CoverageAccumulator accumulator, CoverageWriter writer, TestResultHolder holder) {
        this.accumulator = accumulator;
        this.writer = writer;
        this.holder = holder;
    }

    public RunData run(RunData runData) {
        if (!this.holder.getResults().isEmpty()) {
            logger.debug("Writing coverage to {}", (Object)this.writer);
            this.accumulator.write(this.writer);
            this.writer.flush();
        }
        return runData;
    }
}

