/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.runner.RunnerType;
import com.google.jstestdriver.server.handlers.pages.Page;
import com.google.jstestdriver.server.handlers.pages.PageType;
import com.google.jstestdriver.server.handlers.pages.SlavePageRequest;
import com.google.jstestdriver.util.HtmlWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserControlledRunnerHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(BrowserControlledRunnerHandler.class);
    private final Gson gson = new Gson();
    private final SlavePageRequest request;
    private final HttpServletResponse response;
    private final FilesCache cache;
    private final HandlerPathPrefix prefix;
    private final Map<PageType, Page> pages;

    @Inject
    public BrowserControlledRunnerHandler(SlavePageRequest request, HttpServletResponse response, FilesCache cache, HandlerPathPrefix prefix, Map<PageType, Page> pages) {
        this.request = request;
        this.response = response;
        this.cache = cache;
        this.prefix = prefix;
        this.pages = pages;
    }

    @Override
    public void handleIt() throws IOException {
        SlaveBrowser browser = this.request.getBrowser();
        if (browser == null) {
            this.response.sendRedirect(this.prefix.prefixPath("/capture/rt/" + (Object)((Object)RunnerType.BROWSER) + "/timeout/-1"));
        } else {
            browser.heartBeat();
            this.response.setContentType("text/html; charset=utf-8");
            HtmlWriter writer = new HtmlWriter(this.response.getWriter(), this.prefix);
            this.request.writeDTD(writer);
            this.pages.get((Object)this.request.getPageType()).render(writer, this.request);
            this.service(browser);
        }
    }

    public void service(SlaveBrowser slaveBrowser) {
        logger.debug("Adding noop command.");
        slaveBrowser.createCommand(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.NOOP, null)));
        Set<String> filesToload = this.cache.getAllFileNames();
        LinkedList<FileSource> filesSources = new LinkedList<FileSource>();
        for (String f : filesToload) {
            filesSources.add(new FileSource(this.prefix.prefixPath("/test/" + f), f, -1L));
        }
        int size = filesSources.size();
        for (int i = 0; i < size; i += 50) {
            LinkedList<String> loadFilesParameters = new LinkedList<String>();
            List chunkedFileSources = filesSources.subList(i, Math.min(i + 50, size));
            loadFilesParameters.add(this.gson.toJson(chunkedFileSources));
            loadFilesParameters.add("true");
            logger.debug("adding chunked upload command: {}", i);
            slaveBrowser.createCommand(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.LOADTEST, loadFilesParameters)));
        }
        LinkedList<String> runAllTestsParameters = new LinkedList<String>();
        runAllTestsParameters.add("false");
        runAllTestsParameters.add("false");
        runAllTestsParameters.add("0");
        logger.debug("adding run all tests command.");
        slaveBrowser.createCommand(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.RUNALLTESTS, runAllTestsParameters)));
        slaveBrowser.createCommand(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.STOP, null)));
    }
}

