/* ld.h was originally generated by the autoSql program, which also 
 * generated ld.c and ld.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef LD_H
#define LD_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define LD_NUM_COLS 8

struct ld
/* Linkage Disequilibrium values from SNP genotypes */
    {
    struct ld *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* chromStart for reference marker */
    unsigned chromEnd;	/* chromEnd for last marker in list */
    char *name;	/* rsId at chromStart */
    unsigned score;	/* Number of markers with LD values */
    char *dprime;	/* Encoded lists of D' values */
    char *rsquared;	/* Encoded lists of r^2 values */
    char *lod;	/* Encoded lists of LOD values */
    };

void ldStaticLoad(char **row, struct ld *ret);
/* Load a row from ld table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ld *ldLoad(char **row);
/* Load a ld from row fetched with select * from ld
 * from database.  Dispose of this with ldFree(). */

struct ld *ldLoadAll(char *fileName);
/* Load all ld from whitespace-separated file.
 * Dispose of this with ldFreeList(). */

struct ld *ldLoadAllByChar(char *fileName, char chopper);
/* Load all ld from chopper separated file.
 * Dispose of this with ldFreeList(). */

#define ldLoadAllByTab(a) ldLoadAllByChar(a, '\t');
/* Load all ld from tab separated file.
 * Dispose of this with ldFreeList(). */

struct ld *ldLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all ld from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with ldFreeList(). */

void ldSaveToDb(struct sqlConnection *conn, struct ld *el, char *tableName, int updateSize);
/* Save ld as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use ldSaveToDbEscaped() */

void ldSaveToDbEscaped(struct sqlConnection *conn, struct ld *el, char *tableName, int updateSize);
/* Save ld as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than ldSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct ld *ldCommaIn(char **pS, struct ld *ret);
/* Create a ld out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ld */

void ldFree(struct ld **pEl);
/* Free a single dynamically allocated ld such as created
 * with ldLoad(). */

void ldFreeList(struct ld **pList);
/* Free a list of dynamically allocated ld's */

void ldOutput(struct ld *el, FILE *f, char sep, char lastSep);
/* Print out ld.  Separate fields with sep. Follow last field with lastSep. */

#define ldTabOut(el,f) ldOutput(el,f,'\t','\n');
/* Print out ld as a line in a tab-separated file. */

#define ldCommaOut(el,f) ldOutput(el,f,',',',');
/* Print out ld as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* LD_H */

