/* mammalPsg.h was originally generated by the autoSql program, which also 
 * generated mammalPsg.c and mammalPsg.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef MAMMALPSG_H
#define MAMMALPSG_H

#define MAMMALPSG_NUM_COLS 34

struct mammalPsg
/* Browser extensible data (12 fields) plus the information on mammalian positive selection. */
    {
    struct mammalPsg *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome (or contig, scaffold, etc.) */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* 400 for P<0.05 on any test; 700 fdr significant under any test; 1000 fdr significant under test A */
    char strand[2];	/* + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* Used as itemRgb as of 2004-11-22 */
    int blockCount;	/* Number of blocks */
    int *blockSizes;	/* Comma separated list of block sizes */
    int *chromStarts;	/* Start positions relative to chromStart */
    float lrtAllPValue;	/* A: LRT P-value  on all branches */
    unsigned char lrtAllIsFdr;	/* A: true if FDR significant */
    float lrtPrimateBrPValue;	/* B: LRT P-value  on branch leading to primates */
    unsigned char lrtPrimateBrIsFdr;	/* B: true if FDR significant */
    float lrtPrimateClPValue;	/* C: LRT P-value  on primate clade */
    unsigned char lrtPrimateClIsFdr;	/* C: true if FDR significant */
    float lrtRodentBrPValue;	/* D: LRT P-value  on branch leading to rodents */
    unsigned char lrtRodentBrIsFdr;	/* D: true if FDR significant */
    float lrtRodentClPValue;	/* E: LRT P-value  on rodent clade */
    unsigned char lrtRodentClIsFdr;	/* E: true if FDR significant */
    float lrtHumanPValue;	/* F: LRT P-value  on human lineage */
    unsigned char lrtHumanIsFdr;	/* F: true if FDR significant */
    float lrtChimpPValue;	/* G: LRT P-value  on chimp lineage */
    unsigned char lrtChimpIsFdr;	/* G: true if FDR significant */
    float lrtHominidPValue;	/* H: LRT P-value  on branch leading to hominids */
    unsigned char lrtHominidIsFdr;	/* H: true if FDR significant */
    float lrtMacaquePValue;	/* I: LRT P-value  on human lineage */
    unsigned char lrtMacaqueIsFdr;	/* I: true if FDR significant */
    unsigned bestHist;	/* Most likely history (Bayesian analysis) */
    float bestHistPP;	/* Probability of the most likely history */
    unsigned nextBestHist;	/* 2nd most likely history (Bayesian analysis) */
    float nextBestHistPP;	/* Probability of the 2nd most likely history */
    };

struct mammalPsg *mammalPsgLoad(char **row);
/* Load a mammalPsg from row fetched with select * from mammalPsg
 * from database.  Dispose of this with mammalPsgFree(). */

struct mammalPsg *mammalPsgLoadAll(char *fileName);
/* Load all mammalPsg from whitespace-separated file.
 * Dispose of this with mammalPsgFreeList(). */

struct mammalPsg *mammalPsgLoadAllByChar(char *fileName, char chopper);
/* Load all mammalPsg from chopper separated file.
 * Dispose of this with mammalPsgFreeList(). */

#define mammalPsgLoadAllByTab(a) mammalPsgLoadAllByChar(a, '\t');
/* Load all mammalPsg from tab separated file.
 * Dispose of this with mammalPsgFreeList(). */

struct mammalPsg *mammalPsgCommaIn(char **pS, struct mammalPsg *ret);
/* Create a mammalPsg out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new mammalPsg */

void mammalPsgFree(struct mammalPsg **pEl);
/* Free a single dynamically allocated mammalPsg such as created
 * with mammalPsgLoad(). */

void mammalPsgFreeList(struct mammalPsg **pList);
/* Free a list of dynamically allocated mammalPsg's */

void mammalPsgOutput(struct mammalPsg *el, FILE *f, char sep, char lastSep);
/* Print out mammalPsg.  Separate fields with sep. Follow last field with lastSep. */

#define mammalPsgTabOut(el,f) mammalPsgOutput(el,f,'\t','\n');
/* Print out mammalPsg as a line in a tab-separated file. */

#define mammalPsgCommaOut(el,f) mammalPsgOutput(el,f,',',',');
/* Print out mammalPsg as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* MAMMALPSG_H */

