/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;
import org.bouncycastle.pqc.math.linearalgebra.GFElement;
import org.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;

public class GF2nPolynomialElement
extends GF2nElement {
    private static final int[] bitMask;
    private GF2Polynomial polynomial;

    static {
        int[] nArray = new int[33];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 8;
        nArray[4] = 16;
        nArray[5] = 32;
        nArray[6] = 64;
        nArray[7] = 128;
        nArray[8] = 256;
        nArray[9] = 512;
        nArray[10] = 1024;
        nArray[11] = 2048;
        nArray[12] = 4096;
        nArray[13] = 8192;
        nArray[14] = 16384;
        nArray[15] = 32768;
        nArray[16] = 65536;
        nArray[17] = 131072;
        nArray[18] = 262144;
        nArray[19] = 524288;
        nArray[20] = 0x100000;
        nArray[21] = 0x200000;
        nArray[22] = 0x400000;
        nArray[23] = 0x800000;
        nArray[24] = 0x1000000;
        nArray[25] = 0x2000000;
        nArray[26] = 0x4000000;
        nArray[27] = 0x8000000;
        nArray[28] = 0x10000000;
        nArray[29] = 0x20000000;
        nArray[30] = 0x40000000;
        nArray[31] = Integer.MIN_VALUE;
        bitMask = nArray;
    }

    public GF2nPolynomialElement(GF2nPolynomialField f, Random rand) {
        this.mField = f;
        this.mDegree = this.mField.getDegree();
        this.polynomial = new GF2Polynomial(this.mDegree);
        this.randomize(rand);
    }

    public GF2nPolynomialElement(GF2nPolynomialField f, GF2Polynomial bs) {
        this.mField = f;
        this.mDegree = this.mField.getDegree();
        this.polynomial = new GF2Polynomial(bs);
        this.polynomial.expandN(this.mDegree);
    }

    public GF2nPolynomialElement(GF2nPolynomialField f, byte[] os) {
        this.mField = f;
        this.mDegree = this.mField.getDegree();
        this.polynomial = new GF2Polynomial(this.mDegree, os);
        this.polynomial.expandN(this.mDegree);
    }

    public GF2nPolynomialElement(GF2nPolynomialField f, int[] is) {
        this.mField = f;
        this.mDegree = this.mField.getDegree();
        this.polynomial = new GF2Polynomial(this.mDegree, is);
        this.polynomial.expandN(f.mDegree);
    }

    public GF2nPolynomialElement(GF2nPolynomialElement other) {
        this.mField = other.mField;
        this.mDegree = other.mDegree;
        this.polynomial = new GF2Polynomial(other.polynomial);
    }

    public Object clone() {
        return new GF2nPolynomialElement(this);
    }

    void assignZero() {
        this.polynomial.assignZero();
    }

    public static GF2nPolynomialElement ZERO(GF2nPolynomialField f) {
        GF2Polynomial polynomial = new GF2Polynomial(f.getDegree());
        return new GF2nPolynomialElement(f, polynomial);
    }

    public static GF2nPolynomialElement ONE(GF2nPolynomialField f) {
        GF2Polynomial polynomial = new GF2Polynomial(f.getDegree(), new int[]{1});
        return new GF2nPolynomialElement(f, polynomial);
    }

    void assignOne() {
        this.polynomial.assignOne();
    }

    private void randomize(Random rand) {
        this.polynomial.expandN(this.mDegree);
        this.polynomial.randomize(rand);
    }

    public boolean isZero() {
        return this.polynomial.isZero();
    }

    public boolean isOne() {
        return this.polynomial.isOne();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nPolynomialElement)) {
            return false;
        }
        GF2nPolynomialElement otherElem = (GF2nPolynomialElement)other;
        if (this.mField != otherElem.mField && !this.mField.getFieldPolynomial().equals(otherElem.mField.getFieldPolynomial())) {
            return false;
        }
        return this.polynomial.equals(otherElem.polynomial);
    }

    public int hashCode() {
        return this.mField.hashCode() + this.polynomial.hashCode();
    }

    private GF2Polynomial getGF2Polynomial() {
        return new GF2Polynomial(this.polynomial);
    }

    boolean testBit(int index) {
        return this.polynomial.testBit(index);
    }

    public boolean testRightmostBit() {
        return this.polynomial.testBit(0);
    }

    public GFElement add(GFElement addend) throws RuntimeException {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.addToThis(addend);
        return result;
    }

    public void addToThis(GFElement addend) throws RuntimeException {
        if (!(addend instanceof GF2nPolynomialElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nPolynomialElement)addend).mField)) {
            throw new RuntimeException();
        }
        this.polynomial.addToThis(((GF2nPolynomialElement)addend).polynomial);
    }

    public GF2nElement increase() {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.increaseThis();
        return result;
    }

    public void increaseThis() {
        this.polynomial.increaseThis();
    }

    public GFElement multiply(GFElement factor) throws RuntimeException {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.multiplyThisBy(factor);
        return result;
    }

    public void multiplyThisBy(GFElement factor) throws RuntimeException {
        if (!(factor instanceof GF2nPolynomialElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nPolynomialElement)factor).mField)) {
            throw new RuntimeException();
        }
        if (this.equals(factor)) {
            this.squareThis();
            return;
        }
        this.polynomial = this.polynomial.multiply(((GF2nPolynomialElement)factor).polynomial);
        this.reduceThis();
    }

    public GFElement invert() throws ArithmeticException {
        return this.invertMAIA();
    }

    public GF2nPolynomialElement invertEEA() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        GF2Polynomial b = new GF2Polynomial(this.mDegree + 32, "ONE");
        b.reduceN();
        GF2Polynomial c = new GF2Polynomial(this.mDegree + 32);
        c.reduceN();
        GF2Polynomial u = this.getGF2Polynomial();
        GF2Polynomial v = this.mField.getFieldPolynomial();
        u.reduceN();
        while (!u.isOne()) {
            u.reduceN();
            v.reduceN();
            int j = u.getLength() - v.getLength();
            if (j < 0) {
                GF2Polynomial h = u;
                u = v;
                v = h;
                h = b;
                b = c;
                c = h;
                j = -j;
                c.reduceN();
            }
            u.shiftLeftAddThis(v, j);
            b.shiftLeftAddThis(c, j);
        }
        b.reduceN();
        return new GF2nPolynomialElement((GF2nPolynomialField)this.mField, b);
    }

    public GF2nPolynomialElement invertSquare() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        int b = this.mField.getDegree() - 1;
        GF2nPolynomialElement n = new GF2nPolynomialElement(this);
        n.polynomial.expandN((this.mDegree << 1) + 32);
        n.polynomial.reduceN();
        int k = 1;
        int i = IntegerFunctions.floorLog(b) - 1;
        while (i >= 0) {
            GF2nPolynomialElement u = new GF2nPolynomialElement(n);
            int j = 1;
            while (j <= k) {
                u.squareThisPreCalc();
                ++j;
            }
            n.multiplyThisBy(u);
            k <<= 1;
            if ((b & bitMask[i]) != 0) {
                n.squareThisPreCalc();
                n.multiplyThisBy(this);
                ++k;
            }
            --i;
        }
        n.squareThisPreCalc();
        return n;
    }

    public GF2nPolynomialElement invertMAIA() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        GF2Polynomial b = new GF2Polynomial(this.mDegree, "ONE");
        GF2Polynomial c = new GF2Polynomial(this.mDegree);
        GF2Polynomial u = this.getGF2Polynomial();
        GF2Polynomial v = this.mField.getFieldPolynomial();
        while (true) {
            if (!u.testBit(0)) {
                u.shiftRightThis();
                if (!b.testBit(0)) {
                    b.shiftRightThis();
                    continue;
                }
                b.addToThis(this.mField.getFieldPolynomial());
                b.shiftRightThis();
                continue;
            }
            if (u.isOne()) {
                return new GF2nPolynomialElement((GF2nPolynomialField)this.mField, b);
            }
            u.reduceN();
            v.reduceN();
            if (u.getLength() < v.getLength()) {
                GF2Polynomial h = u;
                u = v;
                v = h;
                h = b;
                b = c;
                c = h;
            }
            u.addToThis(v);
            b.addToThis(c);
        }
    }

    public GF2nElement square() {
        return this.squarePreCalc();
    }

    public void squareThis() {
        this.squareThisPreCalc();
    }

    public GF2nPolynomialElement squareMatrix() {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.squareThisMatrix();
        result.reduceThis();
        return result;
    }

    public void squareThisMatrix() {
        GF2Polynomial result = new GF2Polynomial(this.mDegree);
        int i = 0;
        while (i < this.mDegree) {
            if (this.polynomial.vectorMult(((GF2nPolynomialField)this.mField).squaringMatrix[this.mDegree - i - 1])) {
                result.setBit(i);
            }
            ++i;
        }
        this.polynomial = result;
    }

    public GF2nPolynomialElement squareBitwise() {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.squareThisBitwise();
        result.reduceThis();
        return result;
    }

    public void squareThisBitwise() {
        this.polynomial.squareThisBitwise();
        this.reduceThis();
    }

    public GF2nPolynomialElement squarePreCalc() {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.squareThisPreCalc();
        result.reduceThis();
        return result;
    }

    public void squareThisPreCalc() {
        this.polynomial.squareThisPreCalc();
        this.reduceThis();
    }

    public GF2nPolynomialElement power(int k) {
        if (k == 1) {
            return new GF2nPolynomialElement(this);
        }
        GF2nPolynomialElement result = GF2nPolynomialElement.ONE((GF2nPolynomialField)this.mField);
        if (k == 0) {
            return result;
        }
        GF2nPolynomialElement x = new GF2nPolynomialElement(this);
        x.polynomial.expandN((x.mDegree << 1) + 32);
        x.polynomial.reduceN();
        int i = 0;
        while (i < this.mDegree) {
            if ((k & 1 << i) != 0) {
                result.multiplyThisBy(x);
            }
            x.square();
            ++i;
        }
        return result;
    }

    public GF2nElement squareRoot() {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.squareRootThis();
        return result;
    }

    public void squareRootThis() {
        this.polynomial.expandN((this.mDegree << 1) + 32);
        this.polynomial.reduceN();
        int i = 0;
        while (i < this.mField.getDegree() - 1) {
            this.squareThis();
            ++i;
        }
    }

    public GF2nElement solveQuadraticEquation() throws RuntimeException {
        GF2nPolynomialElement z;
        GF2nPolynomialElement w;
        if (this.isZero()) {
            return GF2nPolynomialElement.ZERO((GF2nPolynomialField)this.mField);
        }
        if ((this.mDegree & 1) == 1) {
            return this.halfTrace();
        }
        do {
            GF2nPolynomialElement p = new GF2nPolynomialElement((GF2nPolynomialField)this.mField, new Random());
            z = GF2nPolynomialElement.ZERO((GF2nPolynomialField)this.mField);
            w = (GF2nPolynomialElement)p.clone();
            int i = 1;
            while (i < this.mDegree) {
                z.squareThis();
                w.squareThis();
                z.addToThis(w.multiply(this));
                w.addToThis(p);
                ++i;
            }
        } while (w.isZero());
        if (!this.equals(z.square().add(z))) {
            throw new RuntimeException();
        }
        return z;
    }

    public int trace() {
        GF2nPolynomialElement t = new GF2nPolynomialElement(this);
        int i = 1;
        while (i < this.mDegree) {
            t.squareThis();
            t.addToThis(this);
            ++i;
        }
        if (t.isOne()) {
            return 1;
        }
        return 0;
    }

    private GF2nPolynomialElement halfTrace() throws RuntimeException {
        if ((this.mDegree & 1) == 0) {
            throw new RuntimeException();
        }
        GF2nPolynomialElement h = new GF2nPolynomialElement(this);
        int i = 1;
        while (i <= this.mDegree - 1 >> 1) {
            h.squareThis();
            h.squareThis();
            h.addToThis(this);
            ++i;
        }
        return h;
    }

    private void reduceThis() {
        if (this.polynomial.getLength() > this.mDegree) {
            if (((GF2nPolynomialField)this.mField).isTrinomial()) {
                int tc;
                try {
                    tc = ((GF2nPolynomialField)this.mField).getTc();
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("GF2nPolynomialElement.reduce: the field polynomial is not a trinomial");
                }
                if (this.mDegree - tc <= 32 || this.polynomial.getLength() > this.mDegree << 1) {
                    this.reduceTrinomialBitwise(tc);
                    return;
                }
                this.polynomial.reduceTrinomial(this.mDegree, tc);
                return;
            }
            if (((GF2nPolynomialField)this.mField).isPentanomial()) {
                int[] pc;
                try {
                    pc = ((GF2nPolynomialField)this.mField).getPc();
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("GF2nPolynomialElement.reduce: the field polynomial is not a pentanomial");
                }
                if (this.mDegree - pc[2] <= 32 || this.polynomial.getLength() > this.mDegree << 1) {
                    this.reducePentanomialBitwise(pc);
                    return;
                }
                this.polynomial.reducePentanomial(this.mDegree, pc);
                return;
            }
            this.polynomial = this.polynomial.remainder(this.mField.getFieldPolynomial());
            this.polynomial.expandN(this.mDegree);
            return;
        }
        if (this.polynomial.getLength() < this.mDegree) {
            this.polynomial.expandN(this.mDegree);
        }
    }

    private void reduceTrinomialBitwise(int tc) {
        int k = this.mDegree - tc;
        int i = this.polynomial.getLength() - 1;
        while (i >= this.mDegree) {
            if (this.polynomial.testBit(i)) {
                this.polynomial.xorBit(i);
                this.polynomial.xorBit(i - k);
                this.polynomial.xorBit(i - this.mDegree);
            }
            --i;
        }
        this.polynomial.reduceN();
        this.polynomial.expandN(this.mDegree);
    }

    private void reducePentanomialBitwise(int[] pc) {
        int k = this.mDegree - pc[2];
        int l = this.mDegree - pc[1];
        int m = this.mDegree - pc[0];
        int i = this.polynomial.getLength() - 1;
        while (i >= this.mDegree) {
            if (this.polynomial.testBit(i)) {
                this.polynomial.xorBit(i);
                this.polynomial.xorBit(i - k);
                this.polynomial.xorBit(i - l);
                this.polynomial.xorBit(i - m);
                this.polynomial.xorBit(i - this.mDegree);
            }
            --i;
        }
        this.polynomial.reduceN();
        this.polynomial.expandN(this.mDegree);
    }

    public String toString() {
        return this.polynomial.toString(16);
    }

    public String toString(int radix) {
        return this.polynomial.toString(radix);
    }

    public byte[] toByteArray() {
        return this.polynomial.toByteArray();
    }

    public BigInteger toFlexiBigInt() {
        return this.polynomial.toFlexiBigInt();
    }
}

