/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.meggy;

import java.lang.reflect.Field;
import java.util.HashSet;
import net.xmind.verify.IValidity;
import net.xmind.verify.IVerifyListener;
import net.xmind.verify.VerifyEngine20161018;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.dialogs.AboutDialog;
import org.eclipse.ui.part.PageBook;
import org.xmind.ui.internal.meggy.Messages;
import org.xmind.ui.resources.ColorUtils;

public class UpgradePrefPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IVerifyListener,
IActivityManagerListener {
    private IWorkbench workbench;
    private IWorkbenchActivitySupport activitySupport;
    private IActivityManager activityManager;
    private PageBook pageBook;
    private Control controlForVerifying;
    private Control controlForUnactivated;
    private Control controlForActivated;
    private Label licenseTypeLabel;
    private Hyperlink licenseInfoLink;
    private ResourceManager resources;
    private Button hideProFeaturesCheckBox;

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
        this.activitySupport = workbench.getActivitySupport();
        IActivityManager iActivityManager = this.activityManager = this.activitySupport == null ? null : this.activitySupport.getActivityManager();
        if (this.activityManager != null) {
            this.activityManager.addActivityManagerListener((IActivityManagerListener)this);
        }
        VerifyEngine20161018.addVerifyListener((IVerifyListener)this);
    }

    protected Control createContents(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.initializeDialogUnits((Control)parent);
        this.pageBook = new PageBook(parent, 0);
        this.pageBook.setBackground(parent.getBackground());
        this.pageBook.showPage(this.getControlForVerifying((Composite)this.pageBook));
        VerifyEngine20161018.verify20161018(null, null, (int)255, (IVerifyListener)new IVerifyListener(){

            public void notifyValidity(IValidity validity) {
                UpgradePrefPage.this.updateControls(validity);
            }
        }, (int)2);
        return this.pageBook;
    }

    private Control getControlForVerifying(Composite parent) {
        if (this.controlForVerifying != null && !this.controlForVerifying.isDisposed()) {
            return this.controlForVerifying;
        }
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.marginWidth = 0;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginTop = 0;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setBackground(composite.getBackground());
        label.setText(Messages.UpgradePrefPage_Verifying_text);
        label.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        return composite;
    }

    private Control getControlForActivated(Composite parent) {
        if (this.controlForActivated != null && !this.controlForActivated.isDisposed()) {
            return this.controlForActivated;
        }
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.marginWidth = 0;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginTop = 0;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.licenseTypeLabel = new Label(composite, 64);
        this.licenseTypeLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.licenseTypeLabel.setText("...");
        this.licenseInfoLink = new Hyperlink(composite, 0);
        try {
            Field fPaintFocus = AbstractHyperlink.class.getDeclaredField("paintFocus");
            fPaintFocus.setAccessible(true);
            fPaintFocus.set(this.licenseInfoLink, false);
        }
        catch (Throwable throwable) {}
        this.licenseInfoLink.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        String licensee = System.getProperty("org.xmind.product.license.licensee");
        if (licensee != null) {
            this.licenseInfoLink.setText(licensee.trim());
        }
        this.licenseInfoLink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
        this.licenseInfoLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                UpgradePrefPage.this.showLicenseInfo();
            }
        });
        return composite;
    }

    private Control getControlForUnactivated(Composite parent) {
        if (this.controlForUnactivated != null && !this.controlForUnactivated.isDisposed()) {
            return this.controlForUnactivated;
        }
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.marginWidth = 0;
        compositeLayout.marginHeight = 0;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label descriptionLabel = new Label(composite, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        descriptionLabel.setText(Messages.UpgradePrefPage_description_label);
        Composite form = new Composite(composite, 0);
        form.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout formLayout = new GridLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        formLayout.verticalSpacing = 15;
        formLayout.horizontalSpacing = 5;
        form.setLayout((Layout)formLayout);
        this.hideProFeaturesCheckBox = new Button(form, 32);
        this.hideProFeaturesCheckBox.setText(Messages.UpgradePrefPage_hideButton_text);
        this.hideProFeaturesCheckBox.setSelection(!this.isProFeaturesEnabled());
        Button upgrade = new Button(form, 0);
        upgrade.setText(Messages.UpgradePrefPage_upgradeButton_text);
        upgrade.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        upgrade.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UpgradePrefPage.this.upgrade();
            }
        });
        return composite;
    }

    private void showLicenseInfo() {
        VerifyEngine20161018.verify20161018((String)"ShowLicenseInPrefPage", null, (int)7, null, (int)9);
    }

    private void upgrade() {
        VerifyEngine20161018.verify20161018((String)"UpgradeInPrefPage", null, (int)7, (IVerifyListener)new IVerifyListener(){

            public void notifyValidity(IValidity validity) {
                if ((validity.getCode() & 2) != 0 && "C".equals(validity.getLicenseKeyHeader().getLicenseType())) {
                    IWorkbenchWindow window = UpgradePrefPage.this.workbench.getActiveWorkbenchWindow();
                    Shell shell = window == null ? null : window.getShell();
                    new AboutDialog(shell).open();
                }
            }
        }, (int)0);
    }

    protected void performDefaults() {
        if (this.hideProFeaturesCheckBox != null && !this.hideProFeaturesCheckBox.isDisposed()) {
            this.hideProFeaturesCheckBox.setSelection(false);
            this.setProFeaturesEnabled(true);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.hideProFeaturesCheckBox != null && !this.hideProFeaturesCheckBox.isDisposed()) {
            this.setProFeaturesEnabled(!this.hideProFeaturesCheckBox.getSelection());
        }
        return super.performOk();
    }

    public void dispose() {
        if (this.activityManager != null) {
            this.activityManager.removeActivityManagerListener((IActivityManagerListener)this);
            this.activityManager = null;
        }
        VerifyEngine20161018.removeVerifyListener((IVerifyListener)this);
        super.dispose();
    }

    private String getLicenseTypeContent(int currentStatus) {
        String brandingVersion = System.getProperty("org.xmind.product.brandingVersion", "");
        String licenseTypeContent = null;
        if ((currentStatus & 2) != 0) {
            licenseTypeContent = NLS.bind((String)Messages.UpgradePrefPage_contentType_XMindPro, (Object)brandingVersion);
        } else if ((currentStatus & 1) != 0) {
            licenseTypeContent = Messages.UpgradePrefPage_contentType_XMindProSubscription;
        } else if ((currentStatus & 4) != 0) {
            licenseTypeContent = NLS.bind((String)Messages.UpgradePrefPage_contentType_XMindPlus, (Object)brandingVersion);
        }
        return licenseTypeContent;
    }

    public void notifyValidity(IValidity validity) {
        this.updateControls(validity);
    }

    private void updateControls(final IValidity validity) {
        if (this.pageBook == null || this.pageBook.isDisposed()) {
            return;
        }
        this.pageBook.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (UpgradePrefPage.this.pageBook == null || UpgradePrefPage.this.pageBook.isDisposed()) {
                    return;
                }
                int currentStatus = validity.getCode();
                String licenseTypeContent = UpgradePrefPage.this.getLicenseTypeContent(currentStatus);
                if (licenseTypeContent != null) {
                    UpgradePrefPage.this.pageBook.showPage(UpgradePrefPage.this.getControlForActivated((Composite)UpgradePrefPage.this.pageBook));
                    if (UpgradePrefPage.this.licenseTypeLabel != null && !UpgradePrefPage.this.licenseTypeLabel.isDisposed()) {
                        UpgradePrefPage.this.licenseTypeLabel.setText(NLS.bind((String)Messages.UpgradePrefPage_licenseType_activatedAs_label, (Object)licenseTypeContent));
                    }
                    if (UpgradePrefPage.this.licenseInfoLink != null && !UpgradePrefPage.this.licenseInfoLink.isDisposed()) {
                        UpgradePrefPage.this.licenseInfoLink.setText(NLS.bind((String)Messages.UpgradePrefPage_licenseType_licenseTo_text, (Object)validity.getLicensedTo()));
                    }
                } else {
                    UpgradePrefPage.this.pageBook.showPage(UpgradePrefPage.this.getControlForUnactivated((Composite)UpgradePrefPage.this.pageBook));
                }
                UpgradePrefPage.this.pageBook.layout(true, true);
            }
        });
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (this.hideProFeaturesCheckBox == null || this.hideProFeaturesCheckBox.isDisposed()) {
            return;
        }
        this.hideProFeaturesCheckBox.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (UpgradePrefPage.this.hideProFeaturesCheckBox == null || UpgradePrefPage.this.hideProFeaturesCheckBox.isDisposed()) {
                    return;
                }
                UpgradePrefPage.this.hideProFeaturesCheckBox.setSelection(!UpgradePrefPage.this.isProFeaturesEnabled());
            }
        });
    }

    private boolean isProFeaturesEnabled() {
        if (this.activityManager == null) {
            return true;
        }
        return this.activityManager.getEnabledActivityIds().contains("org.xmind.ui.activities.proFeatures");
    }

    private void setProFeaturesEnabled(boolean enabled) {
        if (this.activityManager == null || this.activitySupport == null) {
            return;
        }
        HashSet<String> enabledActivityIds = new HashSet<String>(this.activityManager.getEnabledActivityIds());
        if (enabled) {
            enabledActivityIds.add("org.xmind.ui.activities.proFeatures");
        } else {
            enabledActivityIds.remove("org.xmind.ui.activities.proFeatures");
        }
        this.activitySupport.setEnabledActivityIds(enabledActivityIds);
    }
}

