/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.brainstorm.Activator;
import org.xmind.ui.dialogs.PopupFilteredList;
import org.xmind.ui.internal.brainstorm.BrainstormMessages;
import org.xmind.ui.internal.ideafactory.FontSizeConstants;
import org.xmind.ui.internal.ideafactory.IdeaFactoryBody;
import org.xmind.ui.internal.ideafactory.ModifyIdeaFontSizeCommand;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.NumberUtils;

public class IdeaFactoryWrapper
implements ICoreEventListener {
    private static final String BUTTON_TYPE = "buttonType";
    private static final org.eclipse.swt.graphics.Rectangle CLIENT_AREA = PlatformUI.getWorkbench().getDisplay().getPrimaryMonitor().getClientArea();
    private static final int MIN_WIDTH = IdeaFactoryWrapper.CLIENT_AREA.width * 25 / 100;
    private static final int MIN_HEIGHT = IdeaFactoryWrapper.CLIENT_AREA.height * 60 / 100;
    private final String DATA_FONT_SIZE = "font-size";
    private final String DATA_SIZE_UP = "font-size-up";
    private final String DATA_SIZE_DOWN = "font-size-down";
    private final String DATA_ADD_GROUP = "add-group";
    private IGraphicalEditor sourceEditor = null;
    private IdeaFactoryBody ideaFactoryBody;
    private IPageChangedListener pageChangedListener;
    private Composite control;
    private boolean isVisible;
    private Composite titleComposite;
    private int ideaFontSize;
    private PopupFilteredList popupList;
    private Control fontSizeControl;
    private Properties properties;
    private ICoreEventRegister register;
    private ResourceManager resources;

    public IdeaFactoryWrapper(Composite parent, Properties properties) {
        this.properties = properties;
        IEditorPart targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (targetEditor instanceof IGraphicalEditor) {
            this.sourceEditor = (IGraphicalEditor)targetEditor;
            this.pageChangedListener = new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (IdeaFactoryWrapper.this.ideaFactoryBody != null && !IdeaFactoryWrapper.this.ideaFactoryBody.getControl().isDisposed()) {
                        IdeaFactoryWrapper.this.ideaFactoryBody.setInput(IdeaFactoryWrapper.this.findMindMap());
                    }
                }
            };
            this.sourceEditor.addPageChangedListener(this.pageChangedListener);
        } else {
            this.sourceEditor = null;
        }
        this.createControl(parent);
        this.insallListenerForFocus(this.control);
        this.initProperties();
        this.registerCoreEvent();
    }

    private void insallListenerForFocus(Composite control) {
        final Listener mouseDownListener = new Listener(){

            public void handleEvent(Event event) {
                IdeaFactoryWrapper.this.setTitleControlColor(event);
            }
        };
        control.getDisplay().addFilter(3, mouseDownListener);
        final Listener focusedListener = new Listener(){

            public void handleEvent(Event event) {
                IdeaFactoryWrapper.this.setTitleControlColor(event);
            }
        };
        control.getDisplay().addFilter(15, focusedListener);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                e.display.removeFilter(3, mouseDownListener);
                e.display.removeFilter(15, focusedListener);
                if (IdeaFactoryWrapper.this.sourceEditor != null && IdeaFactoryWrapper.this.pageChangedListener != null) {
                    IdeaFactoryWrapper.this.sourceEditor.removePageChangedListener(IdeaFactoryWrapper.this.pageChangedListener);
                }
            }
        });
    }

    private void initProperties() {
        this.properties.set("ideaFactoryWrapperControl", (Object)this.control);
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IdeaFactoryWrapper.this.properties.set("ideaFactoryWrapperControl", null);
            }
        });
    }

    private void setTitleControlColor(Event event) {
        if (this.contains((Widget)this.control, (Control)event.widget)) {
            if (this.titleComposite != null && !this.titleComposite.isDisposed()) {
                Color color = ColorUtils.getColor((int)107, (int)106, (int)107);
                this.titleComposite.setBackground(color);
                this.applyColorForChildren(this.titleComposite, color);
            }
        } else if (this.titleComposite != null && !this.titleComposite.isDisposed()) {
            Color color = ColorUtils.getColor((int)139, (int)139, (int)141);
            this.titleComposite.setBackground(color);
            this.applyColorForChildren(this.titleComposite, color);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean contains(Widget parent, Control child) {
        result = false;
        if (parent != child) ** GOTO lbl6
        return true;
lbl-1000:
        // 1 sources

        {
            child = child.getParent();
            result |= this.contains(parent, child);
lbl6:
            // 2 sources

            ** while (!result && !(child instanceof Shell) && child != null)
        }
lbl7:
        // 1 sources

        return result;
    }

    private void applyColorForChildren(Composite parent, Color color) {
        Control[] children = parent.getChildren();
        if (children != null && children.length > 0) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite) {
                    child.setBackground(color);
                    this.applyColorForChildren((Composite)child, color);
                } else {
                    child.setBackground(color);
                }
                ++n2;
            }
        }
    }

    public void createControl(Composite parent) {
        int style = 0x100000;
        int majorMargin = 1;
        if (Util.isWindows()) {
            style |= 0x40000000;
            majorMargin = 10;
        }
        Composite composite = new Composite(parent, style);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        this.control = composite;
        GridLayout layout = new GridLayout();
        layout.marginWidth = majorMargin;
        layout.marginHeight = majorMargin;
        composite.setLayout((Layout)layout);
        org.eclipse.swt.graphics.Rectangle bounds = PlatformUI.getWorkbench().getDisplay().getPrimaryMonitor().getBounds();
        composite.setBounds(bounds.x - (majorMargin - 1), bounds.y - (majorMargin - 1), bounds.width / 3 + (majorMargin - 1) * 2, bounds.height + (majorMargin - 1) * 2);
        this.installListener((Control)this.control);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(ColorUtils.getColor((String)"#d7d7d7"));
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout layout2 = new GridLayout();
        layout2.marginWidth = 1;
        layout2.marginHeight = 1;
        composite2.setLayout((Layout)layout2);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setBackground(ColorUtils.getColor((String)"#f2f2f2"));
        composite3.setLayoutData((Object)new GridData(1808));
        GridLayout layout3 = new GridLayout();
        layout3.marginWidth = 0;
        layout3.marginHeight = 0;
        layout3.verticalSpacing = 0;
        composite3.setLayout((Layout)layout3);
        this.createHeaderSection(composite3);
        this.createDescriptionSection(composite3);
        this.createIdeaFactoryBody(composite3);
        this.setVisible(true);
        composite.moveAbove(null);
        parent.layout(true, true);
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IdeaFactoryWrapper.this.unregisterCoreEvent();
            }
        });
    }

    private void installListener(Control control) {
        Listener controlResizedListener = this.createControlResizedListener();
        control.addListener(6, controlResizedListener);
        control.addListener(3, controlResizedListener);
        control.addListener(5, controlResizedListener);
        control.addListener(4, controlResizedListener);
        control.addListener(7, controlResizedListener);
    }

    private void createHeaderSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.heightHint = 34;
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(ColorUtils.getColor((int)107, (int)106, (int)107));
        this.titleComposite = composite;
        this.createTitleSection(composite);
        this.createCloseSection(composite);
    }

    private Listener createControlResizedListener() {
        Listener listener = new Listener(){
            private int position = 0;
            private org.eclipse.swt.graphics.Point startLocation;
            private org.eclipse.swt.graphics.Rectangle startBounds;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 6: {
                        this.handleMouseEnter(event);
                        break;
                    }
                    case 3: {
                        this.handleMouseDown(event);
                        break;
                    }
                    case 5: {
                        this.handleMouseMove(event);
                        break;
                    }
                    case 4: {
                        this.handleMouseUp(event);
                        break;
                    }
                    case 7: {
                        this.handleMouseExit(event);
                    }
                }
            }

            private void handleMouseExit(Event event) {
                IdeaFactoryWrapper.this.control.setCursor(Cursors.ARROW);
            }

            private void handleMouseUp(Event event) {
                this.startLocation = null;
                this.position = 0;
            }

            private void handleMouseMove(Event event) {
                if (this.startLocation == null || this.startBounds == null) {
                    return;
                }
                if (this.position == 0) {
                    return;
                }
                org.eclipse.swt.graphics.Rectangle rect = new org.eclipse.swt.graphics.Rectangle(this.startBounds.x, this.startBounds.y, this.startBounds.width, this.startBounds.height);
                org.eclipse.swt.graphics.Point targetPoint = IdeaFactoryWrapper.this.control.toDisplay(event.x, event.y);
                int deltaX = targetPoint.x - this.startLocation.x;
                int deltaY = targetPoint.y - this.startLocation.y;
                if ((this.position & 1) == 1) {
                    rect.y += deltaY;
                    rect.height -= deltaY;
                    if (rect.height < MIN_HEIGHT) {
                        rect.y -= MIN_HEIGHT - rect.height;
                        rect.height = MIN_HEIGHT;
                    }
                }
                if ((this.position & 8) == 8) {
                    rect.x += deltaX;
                    rect.width -= deltaX;
                    if (rect.width < MIN_WIDTH) {
                        rect.x -= MIN_WIDTH - rect.width;
                        rect.width = MIN_WIDTH;
                    }
                }
                if ((this.position & 0x10) == 16) {
                    rect.width += deltaX;
                    int n = rect.width = rect.width < MIN_WIDTH ? MIN_WIDTH : rect.width;
                }
                if ((this.position & 4) == 4) {
                    rect.height += deltaY;
                    rect.height = rect.height < MIN_HEIGHT ? MIN_HEIGHT : rect.height;
                }
                IdeaFactoryWrapper.this.control.setRedraw(false);
                IdeaFactoryWrapper.this.control.setBounds(rect);
                IdeaFactoryWrapper.this.control.setRedraw(true);
            }

            private void handleMouseDown(Event event) {
                this.startLocation = IdeaFactoryWrapper.this.control.toDisplay(event.x, event.y);
                this.startBounds = IdeaFactoryWrapper.this.control.getBounds();
            }

            private void handleMouseEnter(Event event) {
                this.position = this.getPosition(event);
                this.updateCursor(this.position);
            }

            private int getPosition(Event event) {
                org.eclipse.swt.graphics.Rectangle rect = IdeaFactoryWrapper.this.control.getBounds();
                Rectangle rectShrinked = new Rectangle(rect.x, rect.y, rect.width, rect.height).shrink(10, 10);
                org.eclipse.swt.graphics.Point point = IdeaFactoryWrapper.this.control.toDisplay(event.x, event.y);
                int position = rectShrinked.getPosition(new Point(point.x, point.y));
                return position;
            }

            private void updateCursor(int position) {
                Cursor newCursor = null;
                switch (position) {
                    case 0: {
                        break;
                    }
                    case 16: {
                        newCursor = Cursors.SIZEE;
                        break;
                    }
                    case 4: {
                        newCursor = Cursors.SIZES;
                        break;
                    }
                    case 8: {
                        newCursor = Cursors.SIZEW;
                        break;
                    }
                    case 1: {
                        newCursor = Cursors.SIZEN;
                        break;
                    }
                    case 9: {
                        newCursor = Cursors.SIZENW;
                        break;
                    }
                    case 17: {
                        newCursor = Cursors.SIZENE;
                        break;
                    }
                    case 20: {
                        newCursor = Cursors.SIZESE;
                        break;
                    }
                    case 12: {
                        newCursor = Cursors.SIZESW;
                    }
                }
                IdeaFactoryWrapper.this.control.setCursor(newCursor);
            }
        };
        return listener;
    }

    private void createCloseSection(Composite composite) {
        Label close = new Label(composite, 131072);
        close.setImage((Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("idea-factory-close.png")));
        close.setToolTipText(BrainstormMessages.IdeaFactoryWrapper_Close_tooltip);
        close.setBackground(composite.getBackground());
        close.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                IdeaFactoryWrapper.this.setVisible(false);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void createTitleSection(Composite composite) {
        Label title = new Label(composite, 16448);
        title.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        final Font newFont = new Font((Device)composite.getDisplay(), "Arial", 13, 1);
        title.setFont(newFont);
        title.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
        title.setForeground(ColorConstants.white);
        title.setText(BrainstormMessages.IdeaFactoryWrapper_Ideafactory_title);
        title.setBackground(composite.getBackground());
        Listener controlMovedListener = this.createControlMovedListener((Control)title);
        title.addListener(3, controlMovedListener);
        title.addListener(5, controlMovedListener);
        title.addListener(4, controlMovedListener);
    }

    private Listener createControlMovedListener(final Control title) {
        Listener listener = new Listener(){
            org.eclipse.swt.graphics.Point point = null;
            org.eclipse.swt.graphics.Point startLocation = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        this.point = title.toDisplay(event.x, event.y);
                        this.startLocation = IdeaFactoryWrapper.this.control.getLocation();
                        break;
                    }
                    case 5: {
                        if (this.point == null) {
                            return;
                        }
                        org.eclipse.swt.graphics.Point p2 = title.toDisplay(event.x, event.y);
                        int deltaX = p2.x - this.point.x;
                        int deltaY = p2.y - this.point.y;
                        org.eclipse.swt.graphics.Rectangle rect = IdeaFactoryWrapper.this.control.getBounds();
                        rect.x = this.startLocation.x + deltaX;
                        rect.y = this.startLocation.y + deltaY;
                        IdeaFactoryWrapper.this.control.setLocation(rect.x, rect.y);
                        break;
                    }
                    case 4: {
                        this.point = null;
                    }
                }
            }
        };
        return listener;
    }

    private void createDescriptionSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 5;
        layout.marginWidth = 8;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.verticalIndent = 15;
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(parent.getBackground());
        this.createDescriptionLabel(composite);
        this.createButtonsSection(composite);
    }

    private void createDescriptionLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label description = new Label(composite, 16384);
        description.setBackground(composite.getBackground());
        description.setForeground(ColorUtils.getColor((String)"#323232"));
        final Font newFont = new Font((Device)composite.getDisplay(), "Arial", 11, 0);
        description.setFont(newFont);
        description.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
        description.setText(BrainstormMessages.IdeaFactoryWrapper_Ideafactory_description);
        description.setForeground(ColorUtils.getColor((String)"#4a4a4a"));
        description.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
    }

    private void createButtonsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginRight = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        this.createFontSizeButton(composite);
        this.createAddGroupButton(composite);
    }

    private void createFontSizeButton(Composite parent) {
        Label fontSizeButton = new Label(parent, 8);
        fontSizeButton.setBackground(parent.getBackground());
        fontSizeButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("font-size-button.png")));
        fontSizeButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        fontSizeButton.setToolTipText(BrainstormMessages.IdeaFactoryWrapper_Tip_Open_Font_Dialog);
        fontSizeButton.setData(BUTTON_TYPE, (Object)"font-size");
        this.installMouseListener(fontSizeButton);
        this.fontSizeControl = fontSizeButton;
    }

    private void initFontSize() {
        this.ideaFontSize = this.getIdeaFontSize(this.findMindMap());
    }

    private int getIdeaFontSize(IMindMap mindmap) {
        ITopicExtensionElement content;
        ITopicExtensionElement fontSizeElement;
        ITopic rootTopic;
        ITopicExtension ext;
        if (mindmap != null && (ext = (rootTopic = mindmap.getSheet().getRootTopic()).getExtension("org.xmind.ui.ideafactory")) != null && (fontSizeElement = (ITopicExtensionElement)(content = ext.getContent()).getFirstChild("font-size")) != null) {
            int fontSize = NumberUtils.safeParseInt((String)fontSizeElement.getTextContent(), (int)11);
            return FontSizeConstants.IDEA_FONT_SIZE_LIST.contains(fontSize) ? fontSize : 11;
        }
        return 11;
    }

    private void installMouseListener(Label label) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 6) {
                    IdeaFactoryWrapper.this.handleMouseEnter(event);
                } else if (event.type == 7) {
                    IdeaFactoryWrapper.this.handleMouseExit(event);
                } else if (event.type == 3) {
                    IdeaFactoryWrapper.this.handleMouseDown(event);
                }
            }
        };
        label.addListener(6, listener);
        label.addListener(7, listener);
        label.addListener(3, listener);
    }

    private void handleMouseEnter(Event event) {
        if (event.widget instanceof Label) {
            Label label = (Label)event.widget;
            Object data = label.getData(BUTTON_TYPE);
            Image image = null;
            if ("font-size".equals(data)) {
                image = (Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("font-size-button-focus.png"));
            } else if ("font-size-up".equals(data)) {
                image = (Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("font-size-up-focus.png"));
            } else if ("font-size-down".equals(data)) {
                image = (Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("font-size-down-focus.png"));
            } else if ("add-group".equals(data)) {
                image = (Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("add-group-focus.png"));
            }
            if (image != null) {
                label.setImage(image);
                label.getParent().layout();
            }
        }
    }

    private void handleMouseExit(Event event) {
        if (event.widget instanceof Label) {
            Label label = (Label)event.widget;
            Object data = label.getData(BUTTON_TYPE);
            Image image = null;
            if ("font-size".equals(data)) {
                image = (Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("font-size-button.png"));
            } else if ("font-size-up".equals(data)) {
                image = (Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("font-size-up.png"));
            } else if ("font-size-down".equals(data)) {
                image = (Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("font-size-down.png"));
            } else if ("add-group".equals(data)) {
                image = (Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("add-group.png"));
            }
            if (image != null) {
                label.setImage(image);
                label.getParent().layout();
            }
        }
    }

    private void handleMouseDown(Event event) {
        if (event.widget instanceof Label) {
            Label label = (Label)event.widget;
            Object data = label.getData(BUTTON_TYPE);
            if ("font-size".equals(data)) {
                this.openFontSizePopup();
            } else if ("font-size-up".equals(data)) {
                int index = FontSizeConstants.IDEA_FONT_SIZE_LIST.indexOf(this.ideaFontSize);
                if (index < FontSizeConstants.IDEA_FONT_SIZE_LIST.size() - 1) {
                    this.ideaFontSize = (Integer)FontSizeConstants.IDEA_FONT_SIZE_LIST.get(index + 1);
                    this.modifyIdeaFontSize(this.ideaFontSize);
                }
            } else if ("font-size-down".equals(data)) {
                int index = FontSizeConstants.IDEA_FONT_SIZE_LIST.indexOf(this.ideaFontSize);
                if (index > 0) {
                    this.ideaFontSize = (Integer)FontSizeConstants.IDEA_FONT_SIZE_LIST.get(index - 1);
                    this.modifyIdeaFontSize(this.ideaFontSize);
                }
            } else if ("add-group".equals(data)) {
                this.ideaFactoryBody.createIdeaGroup();
            }
        }
    }

    private void modifyIdeaFontSize(int ideaFontSize) {
        IMindMap mindmap = this.findMindMap();
        if (mindmap != null) {
            int oldSize = this.getIdeaFontSize(mindmap);
            if (FontSizeConstants.IDEA_FONT_SIZE_LIST.contains(ideaFontSize) && ideaFontSize != oldSize) {
                FontSizeConstants.IDEA_FONT_SIZE_POPUP.add(ideaFontSize);
                if (this.sourceEditor != null) {
                    ICommandStack commandStack = this.sourceEditor.getCommandStack();
                    commandStack.execute((Command)new ModifyIdeaFontSizeCommand(this.findMindMap().getSheet().getRootTopic(), ideaFontSize));
                }
            }
        }
    }

    private void createAddGroupButton(Composite parent) {
        Label addGroupButton = new Label(parent, 8);
        addGroupButton.setBackground(parent.getBackground());
        addGroupButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("add-group.png")));
        addGroupButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        addGroupButton.setToolTipText(BrainstormMessages.IdeaFactoryWrapper_Tip_Add_Group);
        addGroupButton.setData(BUTTON_TYPE, (Object)"add-group");
        this.installMouseListener(addGroupButton);
    }

    private void createIdeaFactoryBody(Composite parent) {
        this.ideaFactoryBody = new IdeaFactoryBody(this.properties);
        this.ideaFactoryBody.createControl(parent);
        this.ideaFactoryBody.setSourceEditor(this.sourceEditor);
        this.ideaFactoryBody.setInput(this.findMindMap());
        this.initFontSize();
        this.ideaFactoryBody.setIdeasFontSize(this.ideaFontSize);
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
        this.control.setVisible(isVisible);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    private IMindMap findMindMap() {
        Object o;
        if (this.sourceEditor == null) {
            return null;
        }
        IGraphicalEditorPage page = this.sourceEditor.getActivePageInstance();
        if (page == null) {
            return null;
        }
        Object input = page.getInput();
        if (input instanceof IMindMap) {
            return (IMindMap)input;
        }
        if (input instanceof IAdaptable && (o = ((IAdaptable)input).getAdapter(IMindMap.class)) instanceof IMindMap) {
            return (IMindMap)o;
        }
        return (IMindMap)page.getAdapter(IMindMap.class);
    }

    private void openFontSizePopup() {
        if (this.popupList == null) {
            this.popupList = this.createPopupList();
        }
        if (this.popupList != null) {
            this.popupList.setDefaultSelection((Object)this.ideaFontSize);
            this.openPopupList(this.popupList);
        }
    }

    private PopupFilteredList createPopupList() {
        PopupFilteredList list = new PopupFilteredList(this.control.getShell());
        this.refreshPopupList(list);
        list.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (obj instanceof String) {
                        obj = NumberUtils.safeParseInt((String)((String)obj), (int)-1);
                    }
                    if (obj instanceof Integer && (Integer)obj != -1 && IdeaFactoryWrapper.this.ideaFontSize != (Integer)obj) {
                        IdeaFactoryWrapper.this.ideaFontSize = (Integer)obj;
                        List fontLists = FontSizeConstants.IDEA_FONT_SIZE_LIST;
                        if (IdeaFactoryWrapper.this.ideaFontSize < (Integer)fontLists.get(0)) {
                            IdeaFactoryWrapper.this.ideaFontSize = (Integer)fontLists.get(0);
                        } else if (IdeaFactoryWrapper.this.ideaFontSize > (Integer)fontLists.get(fontLists.size() - 1)) {
                            IdeaFactoryWrapper.this.ideaFontSize = (Integer)fontLists.get(fontLists.size() - 1);
                        }
                        IdeaFactoryWrapper.this.modifyIdeaFontSize(IdeaFactoryWrapper.this.ideaFontSize);
                    }
                }
            }
        });
        return list;
    }

    private void refreshPopupList(PopupFilteredList list) {
        list.setContentProvider((IContentProvider)new ArrayContentProvider());
        list.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        list.setInput((Object)FontSizeConstants.IDEA_FONT_SIZE_POPUP);
        list.setPermitsUnprovidedElement(true);
    }

    private void openPopupList(PopupFilteredList list) {
        this.locatePopupList(list);
        list.open();
    }

    private void locatePopupList(PopupFilteredList list) {
        org.eclipse.swt.graphics.Rectangle r = this.fontSizeControl.getBounds();
        org.eclipse.swt.graphics.Point loc = this.fontSizeControl.toDisplay(r.x, r.y);
        r.x = loc.x - 6;
        r.y = loc.y;
        list.setBoundsReference(r);
    }

    private void registerCoreEvent() {
        ITopic centralTopic = this.findMindMap().getSheet().getRootTopic();
        if (this.register != null) {
            this.register.unregisterAll();
        } else {
            this.register = new CoreEventRegister((ICoreEventListener)this);
        }
        if (centralTopic != null && centralTopic instanceof ICoreEventSource) {
            this.register.setNextSource((ICoreEventSource)centralTopic);
            this.register.register("fontSize");
        }
    }

    private void unregisterCoreEvent() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        if ("fontSize".equals(event.getType())) {
            this.ideaFontSize = this.getIdeaFontSize(this.findMindMap());
            if (this.ideaFactoryBody != null) {
                this.ideaFactoryBody.setIdeasFontSize(this.ideaFontSize);
            }
        }
    }
}

