/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.AttachmentImageDescriptor;
import org.xmind.ui.internal.layers.BackgroundLayer;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class SheetDecorator
extends Decorator {
    private static final SheetDecorator instance = new SheetDecorator();
    private static final String CACHE_WALLPAPER_KEY = "org.xmind.ui.cache.wallpaperKey";
    private WallpaperImageRegistry imageRegistry = null;
    private Map<IGraphicalPart, Image> partToWrapImage = new HashMap<IGraphicalPart, Image>();

    protected SheetDecorator() {
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        IStyleSelector ss = StyleUtils.getStyleSelector(part);
        this.decorateSheet(part, ss, figure);
    }

    private void decorateSheet(IGraphicalPart part, IStyleSelector ss, IFigure figure) {
        IGraphicalViewer viewer = (IGraphicalViewer)part.getSite().getViewer();
        Layer layer = viewer.getLayer(GEF.LAYER_BACKGROUND);
        if (layer != null) {
            this.decorateBackground(part, ss, layer);
        }
    }

    private void decorateBackground(IGraphicalPart part, IStyleSelector ss, Layer layer) {
        Color backgroundColor = this.getBackgroundColor(part, ss);
        if (backgroundColor != null) {
            layer.setBackgroundColor(backgroundColor);
        }
        if (layer instanceof BackgroundLayer) {
            BackgroundLayer bgLayer = (BackgroundLayer)layer;
            Pattern newWallpaper = this.getWallpaper(part, ss);
            Pattern oldWallpaper = bgLayer.getWallpaper();
            if (oldWallpaper != null) {
                oldWallpaper.dispose();
            }
            bgLayer.setWallpaper(newWallpaper);
            bgLayer.setSubAlpha(this.getWallpaperAlpha(part, ss));
        }
    }

    private Color getBackgroundColor(IGraphicalPart part, IStyleSelector ss) {
        return StyleUtils.getColor(part, ss, "svg:fill", null, "#ffffff");
    }

    private int getWallpaperAlpha(IGraphicalPart part, IStyleSelector ss) {
        double opacity = StyleUtils.getDouble(part, ss, "svg:opacity", 0.8);
        return (int)Math.round(opacity * 255.0);
    }

    private Pattern getWallpaper(IGraphicalPart part, IStyleSelector ss) {
        Image image = this.getWallpaperImage(part, ss);
        Image wrapImage = this.partToWrapImage.get(part);
        if (wrapImage != null) {
            wrapImage.dispose();
            wrapImage = null;
        }
        if (image != null) {
            Rectangle b = image.getBounds();
            wrapImage = new Image(null, b.width, b.height);
            GC gc = new GC((Drawable)wrapImage);
            gc.setBackground(this.getBackgroundColor(part, ss));
            gc.fillRectangle(b);
            gc.drawImage(image, b.x, b.y);
            gc.dispose();
        }
        this.partToWrapImage.put(part, wrapImage);
        return wrapImage == null ? null : new Pattern((Device)Display.getCurrent(), wrapImage);
    }

    private Image getWallpaperImage(IGraphicalPart part, IStyleSelector ss) {
        if (this.imageRegistry == null) {
            this.imageRegistry = new WallpaperImageRegistry();
        }
        return this.imageRegistry.getImage(part, ss);
    }

    public void deactivate(IGraphicalPart part, IFigure figure) {
        Image wrapImage;
        IGraphicalViewer viewer = (IGraphicalViewer)part.getSite().getViewer();
        Layer layer = viewer.getLayer(GEF.LAYER_BACKGROUND);
        if (layer instanceof BackgroundLayer) {
            Pattern wallpaper = ((BackgroundLayer)layer).getWallpaper();
            if (wallpaper != null) {
                wallpaper.dispose();
            }
            ((BackgroundLayer)layer).setWallpaper(null);
        }
        if ((wrapImage = this.partToWrapImage.remove(part)) != null) {
            wrapImage.dispose();
            wrapImage = null;
        }
        if (this.imageRegistry != null) {
            this.imageRegistry.removeHost(part, StyleUtils.getStyleSelector(part));
        }
        super.deactivate(part, figure);
    }

    public static SheetDecorator getInstance() {
        return instance;
    }

    protected static class WallpaperImageRegistry {
        private Map<Object, Entry> map = new HashMap<Object, Entry>();

        protected WallpaperImageRegistry() {
        }

        public Image getImage(IGraphicalPart host, IStyleSelector ss) {
            Object oldKey = MindMapUtils.getCache((IPart)host, SheetDecorator.CACHE_WALLPAPER_KEY);
            Object newKey = this.generateKey(host, ss);
            MindMapUtils.setCache((IPart)host, SheetDecorator.CACHE_WALLPAPER_KEY, newKey);
            if (oldKey != null && !oldKey.equals(newKey)) {
                this.remove(host, oldKey);
            }
            if (newKey != null) {
                Entry entry = this.map.get(newKey);
                if (entry == null) {
                    if (newKey instanceof ImageDescriptor) {
                        entry = new Entry((ImageDescriptor)newKey);
                    } else if (newKey instanceof String) {
                        ImageDescriptor entryKey = null;
                        try {
                            entryKey = ImageDescriptor.createFromURL((URL)new URL((String)newKey));
                        }
                        catch (MalformedURLException malformedURLException) {
                            entryKey = ImageDescriptor.getMissingImageDescriptor();
                        }
                        entry = new Entry(entryKey);
                    }
                    this.map.put(newKey, entry);
                }
                if (entry != null) {
                    return entry.getImage(host);
                }
            }
            return null;
        }

        private Object generateKey(IGraphicalPart host, IStyleSelector ss) {
            String value = ss.getStyleValue(host, "background");
            if (value != null) {
                if (HyperlinkUtils.isAttachmentURL((String)value)) {
                    String attachmentPath = HyperlinkUtils.toAttachmentPath((String)value);
                    IWorkbook workbook = this.getWorkbook(host);
                    return AttachmentImageDescriptor.createFromEntryPath(workbook, attachmentPath);
                }
                if (HyperlinkUtils.isInternalAttachmentURL((String)value)) {
                    return value;
                }
            }
            return null;
        }

        public void removeHost(IGraphicalPart host, IStyleSelector ss) {
            Object key = this.generateKey(host, ss);
            if (key != null) {
                this.remove(host, key);
            }
        }

        private void remove(IGraphicalPart host, Object key) {
            Entry entry = this.map.get(key);
            if (entry != null) {
                entry.remove(host);
                if (entry.isEmpty()) {
                    this.map.remove(key);
                    entry.dispose();
                }
            }
        }

        private IWorkbook getWorkbook(IGraphicalPart host) {
            ISheet sheet;
            IViewer viewer = host.getSite().getViewer();
            if (viewer instanceof IMindMapViewer && (sheet = ((IMindMapViewer)viewer).getSheet()) != null) {
                return sheet.getOwnedWorkbook();
            }
            return null;
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        private static class Entry {
            ImageDescriptor imageDescriptor;
            Image image;
            Set<IGraphicalPart> hosts;

            public Entry(ImageDescriptor key) {
                this.imageDescriptor = key;
            }

            public Image getImage(IGraphicalPart host) {
                if (this.hosts == null) {
                    this.hosts = new HashSet<IGraphicalPart>();
                }
                this.hosts.add(host);
                if (this.image == null) {
                    this.image = this.imageDescriptor.createImage(false);
                }
                return this.image;
            }

            public void remove(IGraphicalPart host) {
                if (this.hosts != null) {
                    this.hosts.remove(host);
                }
            }

            public boolean isEmpty() {
                return this.hosts == null || this.hosts.isEmpty();
            }

            public void dispose() {
                if (this.image != null) {
                    this.image.dispose();
                    this.image = null;
                }
            }
        }
    }
}

