/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dnd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.ui.internal.dnd.MindMapDNDClientBase;
import org.xmind.ui.util.MindMapUtils;

public class TextDndClient
extends MindMapDNDClientBase {
    private static final String LINE_DELIMITER = System.getProperty("line.separator");
    private TextTransfer transfer = TextTransfer.getInstance();

    public Object toTransferData(Object[] viewerElements, IViewer viewer) {
        StringBuilder sb = new StringBuilder(viewerElements.length * 10);
        Object[] objectArray = viewerElements;
        int n = viewerElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.append(sb, element);
            ++n2;
        }
        if (sb.length() == 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, Object element) {
        if (element instanceof ITopic) {
            this.appendTopic(sb, (ITopic)element);
        } else {
            String text = this.toText(element);
            if (text != null) {
                if (sb.length() > 0) {
                    sb.append(LINE_DELIMITER);
                }
                sb.append(text);
            }
        }
    }

    private void appendTopic(StringBuilder sb, ITopic topic) {
        this.appendTopic(sb, topic, 0);
    }

    private void appendTopic(StringBuilder sb, ITopic topic, int level) {
        if (sb.length() > 0) {
            sb.append(LINE_DELIMITER);
        }
        int i = 0;
        while (i < level) {
            sb.append('\t');
            ++i;
        }
        sb.append(topic.getTitleText());
        List children = topic.getAllChildren();
        if (!children.isEmpty()) {
            int nextLevel = level + 1;
            for (ITopic c : children) {
                this.appendTopic(sb, c, nextLevel);
            }
        }
    }

    private String toText(Object element) {
        return MindMapUtils.getText(element, null);
    }

    @Override
    protected Object[] toViewerElements(Object transferData, Request request, IWorkbook workbook, ITopic targetParent, boolean dropInParent) {
        if (transferData instanceof String) {
            String text = (String)transferData;
            if (workbook != null) {
                return this.buildeTopics(text, workbook);
            }
            return new Object[]{text};
        }
        return null;
    }

    private Object[] buildeTopics(String text, IWorkbook wb) {
        String[] lines = text.split("\\r\\n|\\r|\\n|\u2028|\u2029");
        ArrayList<ITopic> topics = new ArrayList<ITopic>(lines.length);
        HashMap<ITopic, Integer> map = new HashMap<ITopic, Integer>();
        ITopic lastTopic = null;
        int topLevel = -1;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ITopic topic = wb.createTopic();
            int level = 0;
            int i = 0;
            while (i < line.length()) {
                char c = line.charAt(i);
                if (c != '\t') break;
                ++level;
                ++i;
            }
            String title = line.substring(level);
            topic.setTitleText(title);
            if (topLevel < 0 || level <= topLevel || lastTopic == null) {
                topLevel = level;
                topics.add(topic);
            } else {
                ITopic parent;
                block9: {
                    int lastLevel = (Integer)map.get(lastTopic);
                    parent = null;
                    if (level > lastLevel) {
                        parent = lastTopic;
                    } else {
                        while (true) {
                            ITopic tempTopic;
                            if (level == lastLevel) {
                                tempTopic = lastTopic.getParent();
                                if (tempTopic == null) continue;
                                parent = tempTopic;
                                break block9;
                            }
                            if (level >= lastLevel) break;
                            tempTopic = lastTopic.getParent();
                            if (tempTopic == null) continue;
                            lastLevel = (Integer)map.get(tempTopic);
                            lastTopic = tempTopic;
                        }
                        parent = lastTopic;
                    }
                }
                if (parent != null) {
                    parent.add(topic);
                }
            }
            lastTopic = topic;
            map.put(topic, level);
            ++n2;
        }
        return topics.toArray();
    }

    public Object getData(Transfer transfer, TransferData data) {
        if (transfer == this.transfer) {
            return this.transfer.nativeToJava(data);
        }
        return null;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }
}

