/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import org.eclipse.swt.widgets.Control;
import org.xmind.gef.Disposable;
import org.xmind.gef.IViewer;
import org.xmind.gef.service.IViewerService;

public abstract class AbstractViewerService
extends Disposable
implements IViewerService {
    private IViewer viewer;
    private boolean active = false;
    private Control control;

    public AbstractViewerService(IViewer viewer) {
        this.viewer = viewer;
    }

    public IViewer getViewer() {
        return this.viewer;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (active == this.active) {
            return;
        }
        this.active = active;
        if (active) {
            if (this.getControl() != null) {
                this.hookControl(this.getControl());
            }
            this.activate();
        } else {
            this.deactivate();
            if (this.getControl() != null) {
                this.unhookControl(this.getControl());
            }
        }
    }

    protected abstract void activate();

    protected abstract void deactivate();

    public void setControl(Control viewerControl) {
        if (viewerControl == this.control) {
            return;
        }
        if (this.control != null && this.isActive()) {
            this.unhookControl(this.control);
        }
        this.control = viewerControl;
        if (this.control != null && this.isActive()) {
            this.hookControl(this.control);
        }
    }

    public Control getControl() {
        return this.control;
    }

    protected void hookControl(Control control) {
    }

    protected void unhookControl(Control control) {
    }

    public void dispose() {
        this.setControl(null);
        this.setActive(false);
        super.dispose();
    }

    public void inputChanged(Object oldInput, Object newInput) {
    }
}

