/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.ui.internal.browser.BrowserPlugin;

public class BrowserUtil {
    private static final String BROWSER_PACKAGE_NAME = "org.eclipse.swt.browser.Browser";
    private static Boolean isInternalBrowserOperational = null;

    private BrowserUtil() {
    }

    public static Object getWindowKey(IWorkbenchWindow window) {
        return new Integer(window.hashCode());
    }

    public static boolean gotoUrl(String url) {
        if (url != null && !BrowserUtil.isWindows()) {
            int index = url.indexOf(" ");
            while (index >= 0) {
                url = String.valueOf(url.substring(0, index)) + "%20" + url.substring(index + 1);
                index = url.indexOf(" ");
            }
        }
        boolean success = false;
        try {
            success = Program.launch((String)url);
        }
        catch (Throwable throwable) {
            Program program = Program.findProgram((String)"html");
            if (program == null) {
                program = Program.findProgram((String)"htm");
            }
            try {
                if (program != null) {
                    success = program.execute(url);
                }
            }
            catch (Throwable throwable2) {}
        }
        return success;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("win") >= 0;
    }

    public static boolean canUseInternalWebBrowser() {
        if (isInternalBrowserOperational != null) {
            return isInternalBrowserOperational;
        }
        try {
            Class.forName(BROWSER_PACKAGE_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            isInternalBrowserOperational = new Boolean(false);
            return false;
        }
        Shell shell = null;
        try {
            shell = new Shell(PlatformUI.getWorkbench().getDisplay());
            new Browser((Composite)shell, 0);
            isInternalBrowserOperational = new Boolean(true);
            return true;
        }
        catch (Throwable t) {
            BrowserPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.browser", 0, "Internal browser is not available: " + t.getMessage(), null));
            isInternalBrowserOperational = new Boolean(false);
            return false;
        }
        finally {
            if (shell != null) {
                shell.dispose();
            }
        }
    }

    public static boolean canUseSystemBrowser() {
        return !"solaris".equals(Platform.getOS());
    }

    public static String encodeStyle(String clientId, int style) {
        return String.valueOf(clientId) + "-" + style;
    }

    public static int decodeStyle(String id) {
        return Integer.parseInt(id.substring(id.lastIndexOf(45) + 1));
    }

    public static String decodeClientId(String id) {
        return id.substring(0, id.lastIndexOf(45));
    }

    public static String normalizeURL(String url) {
        String host;
        URI uri;
        if (url == null || "".equals(url)) {
            return url;
        }
        if (!url.startsWith("http:") && !url.startsWith("https:")) {
            return url;
        }
        try {
            uri = new URI(url);
            url = uri.toString();
        }
        catch (Exception exception) {
            uri = null;
        }
        if (uri != null && (host = uri.getHost()) != null && (host.endsWith(".xmind.net") || host.endsWith(".xmind.cn"))) {
            return BrowserUtil.makeRedirectURL(url);
        }
        return url;
    }

    public static String makeRedirectURL(String url) {
        String distributionId;
        StringBuffer buffer = new StringBuffer(100);
        boolean isCnLink = url.contains("www.xmind.cn") && url.indexOf("www.xmind.cn") < "www.xmind.net".length();
        buffer.append(LinkUtils.getLinkByUser((boolean)isCnLink, (boolean)true, (boolean)false, (String)"/xmind/go?r="));
        buffer.append(BrowserUtil.encode(url));
        buffer.append("&u=");
        String user = System.getProperty("net.xmind.signin.account.user");
        if (user != null) {
            buffer.append(BrowserUtil.encode(user));
        }
        buffer.append("&t=");
        String token = System.getProperty("net.xmind.signin.account.token");
        if (token != null) {
            buffer.append(BrowserUtil.encode(token));
            buffer.append("&exp=");
            buffer.append(BrowserUtil.encode(System.getProperty("net.xmind.signin.account.expireDate", "")));
        }
        if ((distributionId = System.getProperty("org.xmind.product.distribution.id")) != null) {
            buffer.append("&distrib=");
            buffer.append(BrowserUtil.encode(distributionId));
        }
        buffer.append("&nl=");
        buffer.append(BrowserUtil.encode(Platform.getNL()));
        buffer.append("&os=");
        buffer.append(BrowserUtil.encode(Platform.getOS()));
        buffer.append("&arch=");
        buffer.append(BrowserUtil.encode(Platform.getOSArch()));
        buffer.append("&app=");
        buffer.append(BrowserUtil.encode(Platform.getProduct().getApplication()));
        return buffer.toString();
    }

    private static String encode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return text;
        }
    }
}

