/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;

public abstract class GraphicalAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow window;
    private IGraphicalEditor editor;
    private Object data = null;

    public GraphicalAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException("Can't initialize a graphical action without a workbench window or an editor.");
        }
        this.window = window;
    }

    public GraphicalAction(IGraphicalEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Can't initialize a graphical action without a workbench window or an editor.");
        }
        this.editor = editor;
    }

    public GraphicalAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    protected IWorkbenchWindow getWindow() {
        if (this.window != null) {
            return this.window;
        }
        if (this.editor != null) {
            return this.editor.getSite().getWorkbenchWindow();
        }
        return null;
    }

    protected Shell getShell() {
        IWorkbenchWindow window = this.getWindow();
        return window == null ? null : window.getShell();
    }

    protected IGraphicalEditor getEditor() {
        if (this.editor != null) {
            return this.editor;
        }
        IWorkbenchWindow window = this.getWindow();
        if (window == null) {
            return null;
        }
        IEditorPart editor = window.getActivePage().getActiveEditor();
        if (editor instanceof IGraphicalEditor) {
            return (IGraphicalEditor)editor;
        }
        return null;
    }

    protected IGraphicalEditorPage getActivePage() {
        IGraphicalEditor editor = this.getEditor();
        return editor == null ? null : editor.getActivePageInstance();
    }

    protected IGraphicalViewer getActiveViewer() {
        IGraphicalEditorPage page = this.getActivePage();
        return page == null ? null : page.getViewer();
    }

    protected ITool getActiveTool() {
        IGraphicalViewer viewer = this.getActiveViewer();
        return viewer == null ? null : viewer.getEditDomain().getActiveTool();
    }

    protected ISelection getSelection() {
        IGraphicalEditor editor = this.getEditor();
        return editor == null ? StructuredSelection.EMPTY : editor.getSite().getSelectionProvider().getSelection();
    }

    protected ICommandStack getCommandStack() {
        IGraphicalEditor editor = this.getEditor();
        return editor == null ? null : editor.getCommandStack();
    }

    protected void saveAndRun(Command command) {
        ICommandStack cs = this.getCommandStack();
        if (cs != null) {
            cs.execute(command);
        }
    }

    public void dispose() {
        this.window = null;
        this.editor = null;
    }

    protected boolean isDisposed() {
        return this.window == null && this.editor == null;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

