/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ComponentModuleMetadataDetails;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.dsl.ModuleReplacementsData;
import org.gradle.api.internal.notations.ModuleIdentifierNotationConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;

public class ComponentModuleMetadataContainer
implements ModuleReplacementsData {
    private final Map<ModuleIdentifier, ModuleReplacementsData.Replacement> replacements = Maps.newHashMap();
    private final Set<ModuleIdentifier> targets = Sets.newHashSet();
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public ComponentModuleMetadataContainer(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public ComponentModuleMetadataDetails module(Object sourceModule) {
        final NotationParser<Object, ModuleIdentifier> parser = ComponentModuleMetadataContainer.parser(this.moduleIdentifierFactory);
        final ModuleIdentifier source = (ModuleIdentifier)parser.parseNotation(sourceModule);
        return new ComponentModuleMetadataDetails(){

            public void replacedBy(Object moduleNotation) {
                this.replacedBy(moduleNotation, null);
            }

            public void replacedBy(Object targetModule, @Nullable String reason) {
                ModuleIdentifier target = (ModuleIdentifier)parser.parseNotation(targetModule);
                ComponentModuleMetadataContainer.detectCycles(ComponentModuleMetadataContainer.this.replacements, source, target);
                ComponentModuleMetadataContainer.this.replacements.put(source, new ModuleReplacementsData.Replacement(target, reason));
                ComponentModuleMetadataContainer.this.targets.add(target);
            }

            public ModuleIdentifier getId() {
                return source;
            }

            public ModuleIdentifier getReplacedBy() {
                return ComponentModuleMetadataContainer.unwrap((ModuleReplacementsData.Replacement)ComponentModuleMetadataContainer.this.replacements.get(source));
            }
        };
    }

    @Override
    public ModuleReplacementsData.Replacement getReplacementFor(ModuleIdentifier sourceModule) {
        return this.replacements.get(sourceModule);
    }

    @Override
    public boolean participatesInReplacements(ModuleIdentifier moduleId) {
        return this.targets.contains(moduleId) || this.replacements.keySet().contains(moduleId);
    }

    private static void detectCycles(Map<ModuleIdentifier, ModuleReplacementsData.Replacement> replacements, ModuleIdentifier source, ModuleIdentifier target) {
        if (source.equals(target)) {
            throw new InvalidUserDataException(String.format("Cannot declare module replacement that replaces self: %s->%s", source, target));
        }
        ModuleIdentifier m = ComponentModuleMetadataContainer.unwrap(replacements.get(target));
        if (m == null) {
            return;
        }
        LinkedHashSet<ModuleIdentifier> visited = new LinkedHashSet<ModuleIdentifier>();
        visited.add(source);
        visited.add(target);
        while (m != null) {
            if (!visited.add(m)) {
                throw new InvalidUserDataException(String.format("Cannot declare module replacement %s->%s because it introduces a cycle: %s", source, target, Joiner.on((String)"->").join(visited) + "->" + source));
            }
            m = ComponentModuleMetadataContainer.unwrap(replacements.get(m));
        }
    }

    private static ModuleIdentifier unwrap(ModuleReplacementsData.Replacement replacement) {
        return replacement == null ? null : replacement.getTarget();
    }

    private static NotationParser<Object, ModuleIdentifier> parser(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        return NotationParserBuilder.toType(ModuleIdentifier.class).fromCharSequence((NotationConverter)new ModuleIdentifierNotationConverter(moduleIdentifierFactory)).toComposite();
    }
}

