/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMExternalizableStringList;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.ArrayBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.BeanBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.CollectionBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.CompactCollectionBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMElementBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MapBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Serializer;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.CollectionBean;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.Text;

public final class XmlSerializerImpl {
    static final XmlSerializer serializer = new XmlSerializer();

    @NotNull
    static Class<?> typeToClass(@NotNull Type type2) {
        if (type2 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(3);
        }
        if (type2 instanceof Class) {
            Class clazz2 = (Class)type2;
            if (clazz2 == null) {
                XmlSerializerImpl.$$$reportNull$$$0(4);
            }
            return clazz2;
        }
        if (type2 instanceof TypeVariable) {
            Type bound = ((TypeVariable)type2).getBounds()[0];
            Class clazz3 = bound instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType();
            if (clazz3 == null) {
                XmlSerializerImpl.$$$reportNull$$$0(5);
            }
            return clazz3;
        }
        if (type2 instanceof WildcardType) {
            Class clazz4 = (Class)((WildcardType)type2).getUpperBounds()[0];
            if (clazz4 == null) {
                XmlSerializerImpl.$$$reportNull$$$0(6);
            }
            return clazz4;
        }
        Class clazz5 = (Class)((ParameterizedType)type2).getRawType();
        if (clazz5 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(7);
        }
        return clazz5;
    }

    static boolean isPrimitive(@NotNull Class<?> aClass2) {
        if (aClass2 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(8);
        }
        return aClass2.isPrimitive() || aClass2 == String.class || aClass2 == Integer.class || aClass2 == Long.class || aClass2 == Boolean.class || aClass2 == Double.class || aClass2 == Float.class || aClass2.isEnum() || Date.class.isAssignableFrom(aClass2);
    }

    @Nullable
    static Object convert(@Nullable String value, @NotNull Class<?> valueClass) {
        if (valueClass == null) {
            XmlSerializerImpl.$$$reportNull$$$0(9);
        }
        if (value == null) {
            return null;
        }
        if (valueClass == String.class) {
            return value;
        }
        if (valueClass == Integer.TYPE || valueClass == Integer.class) {
            return Integer.parseInt(value);
        }
        if (valueClass == Boolean.TYPE || valueClass == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (valueClass == Double.TYPE || valueClass == Double.class) {
            return Double.parseDouble(value);
        }
        if (valueClass == Float.TYPE || valueClass == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (valueClass == Long.TYPE || valueClass == Long.class) {
            return Long.parseLong(value);
        }
        if (valueClass.isEnum()) {
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                return enumConstant;
            }
            return null;
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            try {
                return new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return new Date(0L);
            }
        }
        return value;
    }

    static void doSet(@NotNull Object host, @Nullable String value, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        if (host == null) {
            XmlSerializerImpl.$$$reportNull$$$0(10);
        }
        if (accessor == null) {
            XmlSerializerImpl.$$$reportNull$$$0(11);
        }
        if (valueClass == null) {
            XmlSerializerImpl.$$$reportNull$$$0(12);
        }
        if (value == null) {
            accessor.set(host, null);
        } else if (valueClass == String.class) {
            accessor.set(host, value);
        } else if (valueClass == Integer.TYPE) {
            accessor.setInt(host, Integer.parseInt(value));
        } else if (valueClass == Boolean.TYPE) {
            accessor.setBoolean(host, Boolean.parseBoolean(value));
        } else if (valueClass == Double.TYPE) {
            accessor.setDouble(host, Double.parseDouble(value));
        } else if (valueClass == Float.TYPE) {
            accessor.setFloat(host, Float.parseFloat(value));
        } else if (valueClass == Long.TYPE) {
            accessor.setLong(host, Long.parseLong(value));
        } else if (valueClass == Short.TYPE) {
            accessor.setShort(host, Short.parseShort(value));
        } else if (valueClass.isEnum()) {
            accessor.set(host, XmlSerializerUtil.stringToEnum(value, valueClass, false));
        } else if (Date.class.isAssignableFrom(valueClass)) {
            try {
                accessor.set(host, new Date(Long.parseLong(value)));
            }
            catch (NumberFormatException e) {
                accessor.set(host, new Date(0L));
            }
        } else {
            Object deserializedValue = value;
            if (valueClass == Boolean.class) {
                deserializedValue = Boolean.parseBoolean(value);
            } else if (valueClass == Integer.class) {
                deserializedValue = Integer.parseInt(value);
            } else if (valueClass == Short.class) {
                deserializedValue = Short.parseShort(value);
            } else if (valueClass == Long.class) {
                deserializedValue = Long.parseLong(value);
            } else if (valueClass == Double.class) {
                deserializedValue = Double.parseDouble(value);
            } else if (valueClass == Float.class) {
                deserializedValue = Float.valueOf(Float.parseFloat(value));
            } else if (XmlSerializerImpl.callFromStringIfDefined(host, value, accessor, valueClass)) {
                return;
            }
            accessor.set(host, deserializedValue);
        }
    }

    private static boolean callFromStringIfDefined(@NotNull Object host, @NotNull String value, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        Method fromText;
        if (host == null) {
            XmlSerializerImpl.$$$reportNull$$$0(13);
        }
        if (value == null) {
            XmlSerializerImpl.$$$reportNull$$$0(14);
        }
        if (accessor == null) {
            XmlSerializerImpl.$$$reportNull$$$0(15);
        }
        if (valueClass == null) {
            XmlSerializerImpl.$$$reportNull$$$0(16);
        }
        try {
            fromText = valueClass.getMethod("fromText", String.class);
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
        try {
            fromText.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            accessor.set(host, fromText.invoke(null, value));
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    @NotNull
    static String getTextValue(@NotNull Element element, @NotNull String defaultText) {
        if (element == null) {
            XmlSerializerImpl.$$$reportNull$$$0(20);
        }
        if (defaultText == null) {
            XmlSerializerImpl.$$$reportNull$$$0(21);
        }
        List<Content> content = element.getContent();
        int size = content.size();
        StringBuilder builder = null;
        for (int i = 0; i < size; ++i) {
            Content child = content.get(i);
            if (!(child instanceof Text)) continue;
            String value = child.getValue();
            if (builder == null && i == size - 1) {
                String string = value;
                if (string == null) {
                    XmlSerializerImpl.$$$reportNull$$$0(22);
                }
                return string;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(value);
        }
        String string = builder == null ? defaultText : builder.toString();
        if (string == null) {
            XmlSerializerImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "typeToClass";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToString";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "typeToClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitive";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doSet";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "callFromStringIfDefined";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertToString";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTextValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class XmlSerializer
    extends XmlSerializerBase {
        private Reference<Map<Pair<Type, MutableAccessor>, Binding>> ourBindings;

        XmlSerializer() {
        }

        @NotNull
        private Map<Pair<Type, MutableAccessor>, Binding> getBindingCacheMap() {
            Map<Pair<Type, MutableAccessor>, Binding> map2 = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.ourBindings);
            if (map2 == null) {
                map2 = ContainerUtil.newConcurrentMap();
                this.ourBindings = new SoftReference<Map<Pair<Type, MutableAccessor>, Binding>>(map2);
            }
            Map<Pair<Type, MutableAccessor>, Binding> map3 = map2;
            if (map3 == null) {
                XmlSerializer.$$$reportNull$$$0(0);
            }
            return map3;
        }

        @Override
        @NotNull
        public synchronized Binding getClassBinding(@NotNull Class<?> aClass2, @NotNull Type originalType, @Nullable MutableAccessor accessor) {
            if (aClass2 == null) {
                XmlSerializer.$$$reportNull$$$0(1);
            }
            if (originalType == null) {
                XmlSerializer.$$$reportNull$$$0(2);
            }
            Pair<Type, MutableAccessor> key = Pair.create(originalType, accessor);
            Map<Pair<Type, MutableAccessor>, Binding> map2 = this.getBindingCacheMap();
            Binding binding = map2.get(key);
            if (binding == null) {
                binding = XmlSerializer.createClassBinding(aClass2, accessor, originalType);
                if (binding == null) {
                    binding = new BeanBinding(aClass2, accessor);
                }
                map2.put(key, binding);
                try {
                    binding.init(originalType, this);
                }
                catch (Error | RuntimeException e) {
                    map2.remove(key);
                    throw e;
                }
            }
            Binding binding2 = binding;
            if (binding2 == null) {
                XmlSerializer.$$$reportNull$$$0(3);
            }
            return binding2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBindingCacheMap";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassBinding";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getClassBinding";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class XmlSerializerBase
    implements Serializer {
        @Override
        @Nullable
        public final Binding getBinding(@NotNull Type type2) {
            if (type2 == null) {
                XmlSerializerBase.$$$reportNull$$$0(0);
            }
            return this.getBinding(XmlSerializerImpl.typeToClass(type2), type2, null);
        }

        @Nullable
        protected final Binding getBinding(@NotNull Class<?> aClass2, @NotNull Type originalType, @Nullable MutableAccessor accessor) {
            if (aClass2 == null) {
                XmlSerializerBase.$$$reportNull$$$0(1);
            }
            if (originalType == null) {
                XmlSerializerBase.$$$reportNull$$$0(2);
            }
            return XmlSerializerImpl.isPrimitive(aClass2) ? null : this.getClassBinding(aClass2, originalType, accessor);
        }

        @Override
        @Nullable
        public final Binding getBinding(@NotNull Class<?> aClass2, @NotNull Type type2) {
            if (aClass2 == null) {
                XmlSerializerBase.$$$reportNull$$$0(3);
            }
            if (type2 == null) {
                XmlSerializerBase.$$$reportNull$$$0(4);
            }
            return this.getBinding(aClass2, type2, null);
        }

        @Override
        @Nullable
        public final Binding getBinding(@NotNull MutableAccessor accessor) {
            if (accessor == null) {
                XmlSerializerBase.$$$reportNull$$$0(5);
            }
            Type type2 = accessor.getGenericType();
            return this.getBinding(XmlSerializerImpl.typeToClass(type2), type2, accessor);
        }

        public final Binding getClassBinding(@NotNull Class<?> aClass2) {
            if (aClass2 == null) {
                XmlSerializerBase.$$$reportNull$$$0(6);
            }
            return this.getClassBinding(aClass2, aClass2, null);
        }

        @Nullable
        protected static Binding createClassBinding(@NotNull Class<?> aClass2, @Nullable MutableAccessor accessor, @NotNull Type originalType) {
            if (aClass2 == null) {
                XmlSerializerBase.$$$reportNull$$$0(7);
            }
            if (originalType == null) {
                XmlSerializerBase.$$$reportNull$$$0(8);
            }
            if (aClass2.isArray()) {
                if (Element.class.isAssignableFrom(aClass2.getComponentType())) {
                    assert (accessor != null);
                    return new JDOMElementBinding(accessor);
                }
                return new ArrayBinding(aClass2, accessor);
            }
            if (Collection.class.isAssignableFrom(aClass2) && originalType instanceof ParameterizedType) {
                CollectionBean listBean;
                if (accessor != null && (listBean = accessor.getAnnotation(CollectionBean.class)) != null) {
                    return new CompactCollectionBinding(accessor);
                }
                return new CollectionBinding((ParameterizedType)originalType, accessor);
            }
            if (Map.class.isAssignableFrom(aClass2) && originalType instanceof ParameterizedType) {
                return new MapBinding(accessor, aClass2);
            }
            if (accessor != null) {
                if (Element.class.isAssignableFrom(aClass2)) {
                    return new JDOMElementBinding(accessor);
                }
                if (JDOMExternalizableStringList.class == aClass2) {
                    return new CompactCollectionBinding(accessor);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBinding";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getClassBinding";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createClassBinding";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

