/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.gradle.problems.Solution;

public class BaseSolution
implements Solution {
    private final Supplier<String> shortDescription;
    private final Supplier<String> longDescription;
    private final Supplier<String> documentationLink;

    public BaseSolution(Supplier<String> shortDescription, Supplier<String> longDescription, Supplier<String> documentationLink) {
        this.shortDescription = Objects.requireNonNull(shortDescription, "short description supplier must not be null");
        this.longDescription = Objects.requireNonNull(longDescription, "long description supplier must not be null");
        this.documentationLink = Objects.requireNonNull(documentationLink, "documentation link supplier must not be null");
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription.get();
    }

    @Override
    public Optional<String> getLongDescription() {
        return Optional.ofNullable(this.longDescription.get());
    }

    @Override
    public Optional<String> getDocumentationLink() {
        return Optional.ofNullable(this.documentationLink.get());
    }
}

