/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import moulserver.Manager;
import moulserver.Node;
import moulserver.NodeUtils;
import moulserver.Results;
import moulserver.SharedServer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.log.Logger;
import shared.EscapeUtils;
import shared.b;
import shared.m;

public class HttpServer
extends SharedServer {
    Server server;
    Manager manager;

    public HttpServer(Manager manager) {
        this.manager = manager;
    }

    public void run() {
        m.msg("Starting Http Server...");
        int port = 80;
        try {
            String loggername = DustLogger.class.getName();
            System.setProperty("org.eclipse.jetty.util.log.class", loggername);
            this.server = new Server();
            SocketConnector connector = new SocketConnector();
            connector.setPort(80);
            this.server.setConnectors(new Connector[]{connector});
            DustHandler handler = new DustHandler();
            this.server.setHandler(handler);
            this.server.start();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public class DustHandler
    extends AbstractHandler {
        public void handle(String target, Request req2, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            m.msg("HttpServer: Handling target: ", target);
            if (target.equals("/")) {
                this.handleSimpleString(request, response, "<html><body>Welcome to the root!</body></html>");
            } else if (target.equals("/serverstatus/moullive.php")) {
                this.handleSimpleString(request, response, "This is the server status!");
            } else if (target.equals("/signup.html")) {
                this.handleSimpleString(request, response, "Please signup, if you like!");
            } else if (target.equals("/admin.html")) {
                this.handleAdmin(request, response);
            } else {
                m.warn("HttpServer unhandled url: ", target);
            }
        }

        public void handleSimpleString(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
            ServletOutputStream out = response.getOutputStream();
            out.print(msg);
            response.setStatus(200);
            ((Request)request).setHandled(true);
        }

        public void handleAdmin(HttpServletRequest request, HttpServletResponse response) throws IOException {
            ServletOutputStream out = response.getOutputStream();
            out.print("<html><header><title>DrizzleTalcum Administration</title></header><body>");
            out.print("  Welcome to the DrizzleTalcum Administration panel!<br/><br/>  <form name='admin' method='post'>    Password:<input type='password' name='password' /><br/>    <button type='submit' value='resetdatabase' name='command'>Reset database</button><br/>    <button type='submit' value='ping' name='command'>Ping</button><br/>    <input type='text' name='createuser_username' /><input type='text' name='createuser_password' /><button type='submit' value='createuser' name='command'>Add User</button><br/>    <button type='submit' value='listusers' name='command'>List users</button><br/>    <button type='submit' value='test' name='command'>Test</button><br/>    <button type='submit' value='listplayers' name='command'>List Players</button><br/>    <input type='text' name='dumpplayer_username' /><button type='submit' value='dumpplayer' name='command'>Dump player info</button><br/>    <button type='submit' value='dumpvault' name='command'>List entire vault</button><br/>    <input type='text' name='dumpnode_idx' /><button type='submit' value='dumpnode' name='command'>Dump node info</button><br/>  </form>  <br/>");
            String mainpassword = request.getParameter("password");
            if (mainpassword != null) {
                if (!mainpassword.equals(HttpServer.this.manager.settings.getMainPassword())) {
                    out.print("Wrong password!<br/>");
                } else {
                    try {
                        String command = request.getParameter("command");
                        if (command == null) {
                            command = "";
                        }
                        if (command.equals("ping")) {
                            out.print("Ping!<br/>");
                        } else if (command.equals("resetdatabase")) {
                            HttpServer.this.manager.database.reset();
                            out.print("Database reset!<br/>");
                        } else if (command.equals("createuser")) {
                            String username = request.getParameter("createuser_username");
                            String password = request.getParameter("createuser_password");
                            HttpServer.this.manager.database.AddUser(username, password);
                            out.print("User created!");
                        } else if (command.equals("listusers")) {
                            Results results = HttpServer.this.manager.database.sqlquery("SELECT accountname,passwordhash FROM accounts", new Object[0]);
                            boolean hasrow = results.first();
                            while (hasrow) {
                                String acc = results.getString("accountname");
                                byte[] hash = results.getBytes("passwordhash");
                                out.print("Username:" + acc + " pwhash:" + b.BytesToHexString(hash) + "<br/>");
                                hasrow = results.next();
                            }
                            out.print("Done listing users!");
                        } else if (command.equals("test")) {
                            String sql = "UPDATE ref_vault SET seen=1, owner_idx=73";
                            HttpServer.this.manager.database.sqlupdate(sql, new Object[0]);
                            boolean dummy = false;
                        } else if (command.equals("listplayers")) {
                            for (Node.PlayerNode player : Node.PlayerNode.findAll()) {
                                out.print("<br/>PlayerName=" + player.getPlayerName() + " AvatarShape=" + player.getAvatarShape());
                            }
                            out.print("<br/>Done listing players!");
                        } else if (command.equals("dumpplayer")) {
                            String playername = request.getParameter("dumpplayer_username");
                            Node.PlayerNode player = Node.PlayerNode.findByName(playername);
                            String s = NodeUtils.ReportTree(player);
                            for (Node.Ref ref : Node.FindTreeRefs(player.getIdx())) {
                                s = s + "\n" + ref.dump();
                            }
                            s = "<pre>" + EscapeUtils.escapeHtmlString(s) + "</pre>";
                            this.handleSimpleString(request, response, s);
                        } else if (command.equals("dumpvault")) {
                            Results results = HttpServer.this.manager.database.sqlquery("SELECT * FROM vault", new Object[0]);
                            boolean hasrow = results.first();
                            while (hasrow) {
                                Object curnode = Node.getNode(results);
                                out.print("<br/>" + ((Node)curnode).toString());
                                hasrow = results.next();
                            }
                            out.print("<br/><br/>Refs:<br/>");
                            results = HttpServer.this.manager.database.sqlquery("SELECT * FROM ref_vault", new Object[0]);
                            for (Node.Ref ref : results.castAsRefs()) {
                                out.print("<br/>" + ref.dump());
                            }
                            out.print("<br/>Done listing entire vault!");
                        } else if (command.equals("dumpnode")) {
                            String idxstr = request.getParameter("dumpnode_idx");
                            int idx = Integer.parseInt(idxstr);
                            Object node = Node.getNodeWithIndex(idx);
                            String s = NodeUtils.ReportTree(node);
                            s = "<pre>" + EscapeUtils.escapeHtmlString(s) + "</pre>";
                            this.handleSimpleString(request, response, s);
                        } else {
                            out.print("Error: unknown command: " + command);
                        }
                    }
                    catch (Exception e2) {
                        PrintStream ps = new PrintStream(out);
                        e2.printStackTrace(ps);
                    }
                }
            }
            out.print("</body></html>");
            response.setStatus(200);
            ((Request)request).setHandled(true);
        }
    }

    public static class DustLogger
    implements Logger {
        String name;
        boolean debug = false;

        public DustLogger() {
            this("DustLogger");
        }

        public DustLogger(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void warn(String string, Object ... os) {
            m.warn("JETTY WARN: " + string);
        }

        public void warn(Throwable thrwbl) {
            m.warn("JETTY WARN: " + thrwbl.getMessage());
        }

        public void warn(String string, Throwable thrwbl) {
            m.warn("JETTY WARN: " + string);
            m.warn("JETTY WARN: " + thrwbl.getMessage());
        }

        public void info(String string, Object ... os) {
        }

        public void info(Throwable thrwbl) {
        }

        public void info(String string, Throwable thrwbl) {
        }

        public boolean isDebugEnabled() {
            return this.debug;
        }

        public void setDebugEnabled(boolean bln) {
            this.debug = bln;
        }

        public void debug(String string, Object ... os) {
        }

        public void debug(Throwable thrwbl) {
        }

        public void debug(String string, Throwable thrwbl) {
        }

        public Logger getLogger(String string) {
            return new DustLogger(string);
        }
    }
}

