/*
 * Decompiled with CFR 0.152.
 */
package shared;

import prpobjects.uruobj;
import shared.Flt;
import shared.IBytedeque;
import shared.IBytestream;
import shared.ICompilable;
import shared.Vector3;
import uru.Bytedeque;
import uru.context;

public strictfp class Vertex
extends uruobj
implements ICompilable {
    public Flt x;
    public Flt y;
    public Flt z;

    public Vertex(IBytestream c) {
        this.x = new Flt(c);
        this.y = new Flt(c);
        this.z = new Flt(c);
    }

    public Vertex(context c) {
        this.x = new Flt(c);
        this.y = new Flt(c);
        this.z = new Flt(c);
    }

    public Vertex(float x2, float y2, float z2) {
        this.x = new Flt(x2);
        this.y = new Flt(y2);
        this.z = new Flt(z2);
    }

    public Vertex(Flt x2, Flt y2, Flt z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    private Vertex() {
    }

    public static Vertex zero() {
        return new Vertex(new Flt(0), new Flt(0), new Flt(0));
    }

    public static Vertex createFromDoubles(double x, double y, double z) {
        Vertex result = new Vertex();
        result.x = Flt.createFromJavaFloat((float)x);
        result.y = Flt.createFromJavaFloat((float)y);
        result.z = Flt.createFromJavaFloat((float)z);
        return result;
    }

    public static Vertex createFromFloats(float x, float y, float z) {
        Vertex result = new Vertex();
        result.x = Flt.createFromJavaFloat(x);
        result.y = Flt.createFromJavaFloat(y);
        result.z = Flt.createFromJavaFloat(z);
        return result;
    }

    public static Vertex createFromFlts(Flt x, Flt y, Flt z) {
        return new Vertex(x, y, z);
    }

    public void compile(IBytedeque data) {
        this.x.compile(data);
        this.y.compile(data);
        this.z.compile(data);
    }

    public void compile(Bytedeque data) {
        this.x.compile(data);
        this.y.compile(data);
        this.z.compile(data);
    }

    public float dot(Vertex v2) {
        float result = this.x.toJavaFloat() * v2.x.toJavaFloat() + this.y.toJavaFloat() * v2.y.toJavaFloat() + this.z.toJavaFloat() * v2.z.toJavaFloat();
        return result;
    }

    public double[] convertToDouble4Vector() {
        double[] result = new double[]{this.x.toJavaFloat(), this.y.toJavaFloat(), this.z.toJavaFloat(), 1.0};
        return result;
    }

    public double[][] convertToDouble4x1Matrix() {
        double[][] result = new double[4][1];
        result[0][0] = this.x.toJavaFloat();
        result[1][0] = this.y.toJavaFloat();
        result[2][0] = this.z.toJavaFloat();
        result[3][0] = 1.0;
        return result;
    }

    public static Vertex createFromDouble4x1Matrix(double[][] mat) {
        Vertex result = new Vertex();
        double x = mat[0][0];
        double y = mat[1][0];
        double z = mat[2][0];
        double h = mat[3][0];
        result.x = Flt.createFromJavaFloat((float)(x / h));
        result.y = Flt.createFromJavaFloat((float)(y / h));
        result.z = Flt.createFromJavaFloat((float)(z / h));
        return result;
    }

    public Vertex add(Vertex v) {
        Flt x2 = this.x.add(v.x);
        Flt y2 = this.y.add(v.y);
        Flt z2 = this.z.add(v.z);
        Vertex result = new Vertex(x2, y2, z2);
        return result;
    }

    public Vertex add(double x, double y, double z) {
        Flt x2 = this.x.add((float)x);
        Flt y2 = this.y.add((float)y);
        Flt z2 = this.z.add((float)z);
        Vertex result = new Vertex(x2, y2, z2);
        return result;
    }

    public void addModify(Vertex v) {
        this.x = this.x.add(v.x);
        this.y = this.y.add(v.y);
        this.z = this.z.add(v.z);
    }

    public String toString() {
        String s = "  ";
        return "(" + this.x.toString() + s + this.y.toString() + s + this.z.toString() + ")";
    }

    public Vertex deepClone() {
        Vertex r = new Vertex();
        r.x = this.x.deepClone();
        r.y = this.y.deepClone();
        r.z = this.z.deepClone();
        return r;
    }

    public static Vertex read(IBytestream c) {
        return new Vertex(c);
    }

    public static Vertex readBigEndian(IBytestream c) {
        Vertex r = new Vertex();
        r.x = Flt.readBigEndian(c);
        r.y = Flt.readBigEndian(c);
        r.z = Flt.readBigEndian(c);
        return r;
    }

    public Vector3 getVector3() {
        return new Vector3(this.x.toJavaFloat(), this.y.toJavaFloat(), this.z.toJavaFloat());
    }
}

