/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import moulserver.AuthServer;
import moulserver.Client;
import moulserver.Node;
import moulserver.Server;
import shared.Concurrent;
import shared.m;
import shared.nested;

public class ClientNodesHelper {
    private static Set<Integer> UniqueIndexes(int rootIdx, ArrayList<Node.Ref> refs) {
        LinkedHashSet<Integer> r = new LinkedHashSet<Integer>();
        r.add(rootIdx);
        for (Node.Ref ref : refs) {
            r.add(ref.childIdx);
        }
        return r;
    }

    public static ArrayList<byte[]> GetRawNodes(Client.AuthConnection authconn, int rootNode) {
        ArrayList<Node.Ref> refs = authconn.GetNodeRefs(rootNode);
        Set<Integer> idxes = ClientNodesHelper.UniqueIndexes(rootNode, refs);
        final ArrayList<byte[]> rawnodes = new ArrayList<byte[]>();
        final CountDownLatch latch = new CountDownLatch(idxes.size());
        for (int idx : idxes) {
            authconn.GetNodeWithTransidCallback(idx, new Concurrent.Callback<Server.ServerMsg>(){

                @Override
                public void callback(Server.ServerMsg msg) {
                    AuthServer.VaultNodeFetched msg2 = (AuthServer.VaultNodeFetched)msg.cast();
                    rawnodes.add(msg2.data);
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
        return rawnodes;
    }

    public static NodesInfo GetNodes(Client.AuthConnection authconn, int rootNode) {
        ArrayList<Node.Ref> refs = authconn.GetNodeRefs(rootNode);
        final NodeManager mgr = new NodeManager(rootNode, refs);
        final CountDownLatch latch = new CountDownLatch(mgr.allIdxes.size());
        for (int idx : mgr.allIdxes) {
            authconn.GetNodeWithTransidCallback(idx, new Concurrent.Callback<Server.ServerMsg>(){

                @Override
                public void callback(Server.ServerMsg msg) {
                    AuthServer.VaultNodeFetched msg2 = (AuthServer.VaultNodeFetched)msg.cast();
                    Object node = Node.getNode(msg2.data);
                    mgr.AddNode((Node)node);
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
        NodesInfo result = new NodesInfo();
        result.mgr = mgr;
        return result;
    }

    public static class NodeManager {
        MgrNode root;
        private Map<Integer, MgrNode> idxLookup = Concurrent.getThreadsafeHashMap();
        public HashSet<Integer> allIdxes = new HashSet();

        public NodeManager(int rootNodeIdx, ArrayList<Node.Ref> treeRefs) {
            this.root = this.Get(rootNodeIdx);
            for (Node.Ref ref : treeRefs) {
                MgrNode parent = this.Get(ref.parentIdx);
                MgrNode child = this.Get(ref.childIdx);
                parent.children.add(child);
            }
        }

        public void AddNode(Node node) {
            MgrNode mgrnode = this.idxLookup.get(node.getIdx());
            mgrnode.node = node;
        }

        private MgrNode Get(int idx) {
            MgrNode node = this.idxLookup.get(idx);
            if (node == null) {
                node = new MgrNode(idx);
                this.idxLookup.put(idx, node);
            }
            return node;
        }

        public void report() {
            this.report(this.root, 0);
        }

        private void report(MgrNode mnode, int depth) {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                s.append("  ");
            }
            s.append(mnode.node.toString());
            m.msg(s.toString());
            for (MgrNode child : mnode.children) {
                this.report(child, depth + 1);
            }
        }

        public class MgrNode {
            int idx;
            Node node;
            ArrayList<MgrNode> children = new ArrayList();

            public MgrNode(int idx) {
                this.idx = idx;
                NodeManager.this.idxLookup.put(idx, this);
                NodeManager.this.allIdxes.add(idx);
            }
        }
    }

    public static class NodesInfo {
        public NodeManager mgr;
    }
}

