/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Queue;
import moulserver.AuthServer;
import moulserver.Comm;
import moulserver.Node;
import prpobjects.Guid;
import shared.m;
import shared.uncaughtexception;

public class VaultListeners {
    private HashMap<Integer, LinkedHashSet<WeakReference<Queue<Comm.CommItem>>>> listeners = new HashMap();
    private HashMap<WeakReference<Queue<Comm.CommItem>>, ListenInfo> infos = new HashMap();

    public void SubscribeIfApplicable(int nodeIdx, WeakReference<Queue<Comm.CommItem>> items, ArrayList<Node.Ref> refs) {
        Object root = Node.getNodeWithIndex(nodeIdx);
        int roottype = ((Node)root).getType();
        if (roottype == 2) {
            m.msg("Subscribing to PlayerNode: " + Integer.toString(nodeIdx));
            this.subscribe(items, nodeIdx, refs, 1);
        } else if (roottype == 3) {
            m.msg("Subscribing to AgeNode: " + Integer.toString(nodeIdx));
            this.subscribe(items, nodeIdx, refs, 2);
        } else {
            m.msg("Subscribing to children: " + Integer.toString(nodeIdx));
            this.subscribe(items, nodeIdx, refs, 0);
        }
    }

    private void sendMsgToNodeListeners(int nodeIdx, Comm.CommItem msg) {
        LinkedHashSet<WeakReference<Queue<Comm.CommItem>>> set = this.listeners.get(nodeIdx);
        if (set != null) {
            for (WeakReference weakReference : set) {
                Queue queue = (Queue)weakReference.get();
                if (queue == null) continue;
                queue.add(msg);
            }
        }
    }

    public void SignalNodeChanged(int nodeIdx, Guid revision) {
        AuthServer.VaultNodeChanged msg = new AuthServer.VaultNodeChanged();
        msg.nodeId = nodeIdx;
        msg.revisionId = revision;
        this.sendMsgToNodeListeners(nodeIdx, Comm.CommItem.SendMessage(msg));
    }

    public void SignalNodeAdded(int parentIdx, int childIdx, int ownerIdx) {
        AuthServer.VaultNodeAdded msg = new AuthServer.VaultNodeAdded();
        msg.parentId = parentIdx;
        msg.childId = childIdx;
        msg.ownerId = ownerIdx;
        this.sendMsgToNodeListeners(parentIdx, Comm.CommItem.SendMessage(msg));
    }

    public void SignalNodeDeleted(int nodeIdx) {
        m.throwUncaughtException("unimplemented SignalNodeDeleted");
    }

    private void subscribe(WeakReference<Queue<Comm.CommItem>> items, int nodeIdx, ArrayList<Node.Ref> refs, int type) {
        ListenInfo info = this.infos.get(items);
        if (info == null) {
            info = new ListenInfo();
            this.infos.put(items, info);
        }
        if (type == 1 && info.playerIdx != null) {
            throw new uncaughtexception("Tried to subscribe to a second PlayerNode.");
        }
        if (type == 2 && info.currentAgeIdx != null) {
            this.unsubscribe(items, info.currentAgeIdx);
        } else {
            if (type == 1) {
                info.playerIdx = nodeIdx;
            } else if (type == 2) {
                info.currentAgeIdx = nodeIdx;
            }
            this.addlistener(nodeIdx, items);
            for (Node.Ref ref : refs) {
                this.addlistener(ref.childIdx, items);
            }
        }
    }

    private void addlistener(int nodeIdx, WeakReference<Queue<Comm.CommItem>> items) {
        LinkedHashSet<WeakReference<Queue<Comm.CommItem>>> set = this.listeners.get(nodeIdx);
        if (set == null) {
            set = new LinkedHashSet();
            this.listeners.put(nodeIdx, set);
        }
        set.add(items);
    }

    private void unsubscribe(WeakReference<Queue<Comm.CommItem>> items, int nodeIdx) {
        m.warn("Unsubscribe not implemented yet.");
    }

    private static class ListenInfo {
        Integer playerIdx;
        Integer currentAgeIdx;

        private ListenInfo() {
        }
    }
}

