/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import shared.Bytedeque2;
import shared.Bytes;
import shared.FileUtils;
import shared.Format;
import shared.m;
import shared.translation;
import shared.uncaughtexception;
import shared.zip;

public class GetResource {
    public static boolean enableTranslations = true;

    public static Vector<String> listAllResources() {
        Vector<String> result = new Vector<String>();
        try {
            File jarfile = new File(GetResource.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            String jarpath = jarfile.getAbsolutePath();
            if (jarfile.isFile()) {
                Vector<String> zipentries = zip.getAllEntries(jarpath);
                for (String s : zipentries) {
                    result.add("/" + s);
                }
            } else {
                Vector<File> entries = FileUtils.FindAllFiles(jarpath, null, true);
                for (File f : entries) {
                    String relpath = FileUtils.GetRelativePath(jarfile, f);
                    result.add("/" + relpath);
                }
            }
        }
        catch (Exception e2) {
            throw new uncaughtexception("Unable to reflect on this jar file." + e2.getMessage());
        }
        return result;
    }

    public static boolean hasResource(String path) {
        URL url = GetResource.findResource(path);
        return url != null;
    }

    private static URL findResource(String path) {
        URL url = GetResource.class.getResource(path);
        if (url == null) {
            if (enableTranslations) {
                URL url2 = GetResource.class.getResource(path + "--" + translation.getCurLanguage());
                if (url2 == null) {
                    return GetResource.class.getResource(path + "--" + translation.getDefaultLanguage());
                }
                return url2;
            }
            return null;
        }
        return url;
    }

    public static Image getResourceAsImage(String path) {
        try {
            URL url = GetResource.findResource(path);
            BufferedImage img = ImageIO.read(url);
            return img;
        }
        catch (Exception e2) {
            m.err("Unable to load Image resource:", path);
            return null;
        }
    }

    public static String getResourceAsString(String path) {
        try {
            URL url = GetResource.findResource(path);
            InputStream in = url.openStream();
            int bytesread = 0;
            byte[] buffer = new byte[1024];
            StringBuilder result = new StringBuilder();
            while (bytesread != -1) {
                bytesread = in.read(buffer, 0, 1024);
                if (bytesread == -1) continue;
                result.append(new String(buffer, 0, bytesread, "ISO-8859-1"));
            }
            String result2 = result.toString();
            in.close();
            return result2;
        }
        catch (Exception e2) {
            m.err("Unable to load Image resource:", path);
            return null;
        }
    }

    public static InputStream getResourceAsStream(String path) {
        try {
            URL url = GetResource.findResource(path);
            InputStream in = url.openStream();
            return in;
        }
        catch (Exception e2) {
            m.err("Unable to load Stream resource:", path);
            return null;
        }
    }

    public static File getResourceAsFile(String path, boolean deleteOnExit) {
        try {
            File temp = File.createTempFile("Drizzle", null);
            if (deleteOnExit) {
                temp.deleteOnExit();
            }
            FileOutputStream out = new FileOutputStream(temp);
            URL url = GetResource.findResource(path);
            InputStream in = url.openStream();
            int bytesread = 0;
            byte[] buffer = new byte[1024];
            while (bytesread != -1) {
                bytesread = in.read(buffer, 0, 1024);
                if (bytesread == -1) continue;
                out.write(buffer, 0, bytesread);
            }
            in.close();
            out.flush();
            out.close();
            return temp;
        }
        catch (Exception e2) {
            m.err("Unable to open file resource:", path);
            e2.printStackTrace();
            return null;
        }
    }

    public static byte[] getResourceAsByteArray(String path) {
        Bytes result = GetResource.getResourceAsBytes(path);
        return result.getByteArray();
    }

    public static Bytes getResourceAsBytes(String path) {
        try {
            Bytedeque2 result = new Bytedeque2(Format.none);
            URL url = GetResource.findResource(path);
            InputStream in = url.openStream();
            int bytesread = 0;
            byte[] buffer = new byte[1024];
            while (bytesread != -1) {
                bytesread = in.read(buffer, 0, 1024);
                if (bytesread == -1) continue;
                result.writeBytes(buffer, 0, bytesread);
            }
            in.close();
            Bytes result2 = result.getBytes();
            return result2;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new uncaughtexception("Error while reading resource as Bytes.");
        }
    }
}

